/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class NoteSourceFileHierarchy extends NoteSource {

    private static Logger _logger = Logger.getLogger(NoteSourceFileHierarchy.class.getName());
    String _noteFileName = "NOTES";
    File _inputRoot = null;
    URI _baseURI = null;

    public NoteSourceFileHierarchy(File inputRoot) {
        this(inputRoot, null, null);
    }

    public NoteSourceFileHierarchy(File inputRoot, URI baseURI) {
        this(inputRoot, baseURI, null);
    }

    public NoteSourceFileHierarchy(File inputRoot, URI baseURI, String noteFileName) {
        super();
        _inputRoot = inputRoot;
        _baseURI = baseURI;
        if (noteFileName != null) {
            _noteFileName = noteFileName;
        }
    }

    @Override
    protected List<Note> getNoteListInternal() throws NoteException {
        List<Note> retval = new ArrayList<Note>();
        ArrayDeque<String> deque = new ArrayDeque<String>();
        deque.add("");
        while (!deque.isEmpty()) {
            checkInterrupts();
            String relpath = deque.removeFirst();
            File fullfile = new File(_inputRoot, relpath);
            if (fullfile.isFile()) {
                URI uri = null;
                if (_baseURI == null) {
                    File file = new File("/" + relpath);
                    String uristr = file.getParent();
                    try {
                        uri = new URI(uristr);
                    } catch (URISyntaxException e) {
                        throw new NoteException("Error parsing URI '" + uristr + "'", e);
                    }
                } else {
                    try {
                        URI relpathuri = new URI(relpath);
                        uri = _baseURI.resolve(relpathuri);
                    } catch (URISyntaxException e) {
                        throw new NoteException("Error parsing path '" + relpath + "' as URI", e);
                    }
                }
                NoteSourceFile source = new NoteSourceFile(fullfile, uri);
                try {
                    List<Note> newNoteList = source.getNoteList();
                    for (Note note : newNoteList) {
                        if (note.getPaths().isEmpty()) {
                            note.addPath(new URIWithType(URIWithType.TYPE_DIR, uri));
                        }
                    }
                    retval.addAll(newNoteList);
                } catch (NoteException e) {
                    // consider it a malformed file
                }
            } else if (fullfile.isDirectory()) {
                for (File child : fullfile.listFiles()) {
                    if (child.isDirectory() || (child.isFile() && child.getName().equals(_noteFileName))) {
                        deque.add(((relpath.length() == 0) ? "" : (relpath + File.separator)) + child.getName());
                    }
                }
            }
        }
        return retval;
    }
}
