/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.File;
import java.util.List;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;
import org.nbirn.fbirn.xcede2.catalog.CatalogException;

/**
 *
 * @author gadde
 */
public class NoteTargetCatalog extends NoteTarget {

    private File _file = null;

    public NoteTargetCatalog(ExperimentHierarchyModel model, File file) {
        super(model);
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        _file = file;
    }

    @Override
    public void putNoteListInternal(List<? extends Note> noteList) throws NoteException {
        Catalog cat = new Catalog();
        for (Note note : noteList) {
            Catalog subcat = new Catalog();
            cat.addCatalog(subcat);
            subcat.addMetaField("noteNamespace", note.getNamespace());
            subcat.addMetaField("noteName", note.getName());
            subcat.addMetaField("noteAuthor", note.getAuthor());
            subcat.addMetaField("noteTimeStamp", note.getTimeStamp().toString());
            subcat.addMetaField("noteValue", note.getValue());
            subcat.addMetaField("noteComment", note.getComment());
            for (URIWithType path : note.getPaths()) {
                CatalogEntry entry = subcat.addEntry(path.getURI(), null);
                String typestr = "unknown";
                if (path.getType() == URIWithType.TYPE_DIR) {
                    typestr = "dir";
                } else if (path.getType() == URIWithType.TYPE_FILE) {
                    typestr = "file";
                }
                entry.addMetaFieldString("fileType", typestr);
            }
        }
        try {
            cat.writeCatalogFile(_file);
        } catch (CatalogException e) {
            throw new NoteException("Writing catalog to file failed", e);
        }
    }
}
