/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.nbirn.fbirn.utilities.ChainedSQLException;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.ExceptionCollection;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromURL;

/**
 *
 * @author gadde
 */
public class NoteTargetHID extends NoteTarget {

    private static Logger _logger = Logger.getLogger(NoteTargetHID.class.getName());
    HID _hid = null;
    boolean _createItems = false;
    ExperimentHierarchyModel _model = null;
    private static final String _siteIDMarker = "__SITEID__=";
    private static final String _expNotesSuffix = "-notes";
    CredentialManager _credMan = null;

    public NoteTargetHID(ExperimentHierarchyModel model, HID hid, CredentialManager credMan) {
        super(model);
        _hid = hid;
        _model = model;
        _credMan = credMan;
    }

    public void fillInItemIDs(ExperimentHierarchyItem item, Connection connin) throws NoteException {
        if ((item.expID != null || item.expName == null)
                && (item.subjID != null || item.subjName == null)
                && (item.visitID != null || item.visitName == null)
                && (item.studyID != null || item.studyName == null)
                && (item.seriesID != null || item.seriesName == null)) {
            return;
        }
        Connection conn = connin;
        if (conn == null) {
            conn = _hid.connect();
        }
        Integer experimentUniqueID = null;
        try {
            ArrayList<ExperimentHierarchyItem> itemlist = new ArrayList<ExperimentHierarchyItem>();
            if (item.expName != null || item.expID != null) {
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement("SELECT name, uniqueid FROM nc_experiment WHERE name LIKE ?");
                    if (item.expName != null) {
                        stmt.setString(1, item.expName + "__%");
                    } else {
                        stmt.setString(1, "%__" + item.expID);
                    }
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        String fullExpName = rs.getString(1);
                        experimentUniqueID = rs.getInt(2);
                        if (item.expID == null) {
                            int sep = fullExpName.indexOf("__");
                            if (sep != -1) {
                                item.expID = Integer.parseInt(fullExpName.substring(sep + 2));
                            }
                        }
                    }
                } finally {
                    stmt.close();
                }
            }
            if (item.subjID == null && item.subjName != null) {
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement("SELECT subjectid FROM nc_humansubject WHERE name = ?");
                    stmt.setString(1, item.subjName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        item.subjID = rs.getString(1);
                    }
                } finally {
                    stmt.close();
                }
            }
            if (experimentUniqueID != null && item.visitID == null && item.visitName != null && item.expID != null && item.subjID != null) {
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement("SELECT componentid FROM nc_expcomponent WHERE nc_experiment_uniqueid = ? AND subjectid = ? AND name = ?");
                    stmt.setInt(1, experimentUniqueID);
                    stmt.setString(2, item.subjID);
                    stmt.setString(3, item.visitName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        item.visitID = rs.getInt(1);
                    }
                } finally {
                    stmt.close();
                }
            }
            if (experimentUniqueID != null && item.studyID == null && item.studyName != null && item.expID != null && item.subjID != null && item.visitID != null) {
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement("SELECT studyid FROM nc_expstudy WHERE experimentid = ? AND subjectid = ? AND componentid = ? AND name = ?");
                    stmt.setInt(1, experimentUniqueID);
                    stmt.setString(2, item.subjID);
                    stmt.setInt(3, item.visitID);
                    stmt.setString(4, item.studyName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        item.studyID = rs.getInt(1);
                    }
                } finally {
                    stmt.close();
                }
            }
            if (experimentUniqueID != null && item.seriesID == null && item.seriesName != null && item.expID != null && item.subjID != null && item.visitID != null) {
                PreparedStatement stmt = null;
                try {
                    if (item.studyID != null) {
                        stmt = conn.prepareStatement("SELECT segmentid FROM nc_expsegment WHERE nc_experiment_uniqueid = ? AND subjectid = ? AND componentid = ? AND studyid = ? AND name = ?");
                        stmt.setInt(1, experimentUniqueID);
                        stmt.setString(2, item.subjID);
                        stmt.setInt(3, item.visitID);
                        stmt.setInt(4, item.studyID);
                        stmt.setString(5, item.seriesName);
                    } else {
                        stmt = conn.prepareStatement("SELECT segmentid FROM nc_expsegment WHERE nc_experiment_uniqueid = ? AND subjectid = ? AND componentid = ? AND name = ?");
                        stmt.setInt(1, experimentUniqueID);
                        stmt.setString(2, item.subjID);
                        stmt.setInt(3, item.visitID);
                        stmt.setString(4, item.seriesName);
                    }
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        item.seriesID = rs.getInt(1);
                    }
                } finally {
                    stmt.close();
                }
            }
        } catch (SQLException e) {
            throw new NoteException("Error querying database", new ChainedSQLException(e));
        } finally {
            if (connin == null && conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    // oh well
                }
            }
        }

    }

    public boolean getCreateItems() {
        return _createItems;
    }

    /**
     * @param createItems If true, create the items in the HID if they don't exist.  Otherwise ignore notes that don't have existing items.
     */
    public void setCreateItems(boolean createItems) {
        _createItems = createItems;
    }

    /**
     * Put the comments in the given {@link Note}s into the items described by the Note's paths.
     * @param noteList List of {@link Note}s to add to the HID
     * @throws NoteException
     */
    @Override
    public void putNoteListInternal(List<? extends Note> noteList) throws NoteException {
        Connection conn = _hid.connect();
        try {
            _model.putNotes(noteList, _hid.getDBID(), conn, _createItems, this);
        } finally {
            try {
                conn.close();
            } catch (SQLException e) {
                // ignore
            }
        }
    }

    @Override
    public NotePrivileges getPrivileges() throws NoteException {
        Connection conn = _hid.connect();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
        } catch (SQLException e) {
            throw new NoteException("Error creating SQL statement", new ChainedSQLException(e));
        }
        try {
            ResultSet rs = stmt.executeQuery("SELECT value FROM nc_conf_params WHERE name = 'notecollector.privilegeFile'");
            NotePrivileges retval = null;
            if (rs.next()) {
                String privURLStr = rs.getString(1);
                URI privURL = null;
                try {
                    privURL = new URI(privURLStr);
                } catch (URISyntaxException e) {
                    throw new NoteException("Error converting privilege URL", e);
                }
                final PipedOutputStream pos = new PipedOutputStream();
                PipedInputStream pis = new PipedInputStream(pos);
                Reader reader = new InputStreamReader(pis);
                WorkerDownloadFromURL worker = new WorkerDownloadFromURL(privURL, pos, _credMan);
                worker.addPropertyChangeListener(new PropertyChangeListener() {

                    public void propertyChange(PropertyChangeEvent evt) {
                        String propName = evt.getPropertyName();
                        if ("state".equals(propName) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                            try {
                                pos.close();
                            } catch (Exception e) {
                                // don't care
                            }
                        }
                    }
                });
                Executors.newSingleThreadExecutor().execute(worker);
                Throwable readingException = null;
                try {
                    retval = NotePrivileges.read(reader);
                } catch (Throwable e) {
                    readingException = e;
                }
                reader.close();
                Throwable writingException = null;
                try {
                    worker.get();
                } catch (ExecutionException e) {
                    writingException = e;
                } catch (InterruptedException e) {
                    writingException = e;
                }
                if (readingException != null) {
                    if (writingException != null) {
                        ExceptionCollection ec = new ExceptionCollection();
                        ec.add(readingException);
                        ec.add(writingException);
                        throw new NoteException("Error reading and writing privileges", ec);
                    } else {
                        throw new NoteException("Error reading privileges", readingException);
                    }
                } else if (writingException != null) {
                    throw new NoteException("Error writing privileges", writingException);
                }
            }
            return retval;
        } catch (IOException e) {
            throw new NoteException("Error getting privileges from target HID", e);
        } catch (SQLException e) {
            throw new NoteException("Error getting privileges from target HID", new ChainedSQLException(e));
        } finally {
            try {
                stmt.close();
            } catch (SQLException e) {
                // oh well
            }
        }
    }
}
