/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.birncommunity.sample.proxy.LocalCredentialHelper;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import org.openide.util.lookup.ServiceProvider;

/**
 *
 * @author gadde
 */
@ServiceProvider(service = CredentialManager.class)
public class CredentialManager {

    private GSSCredential _credential = null;
    private Component _parent = null;
    private PropertySetManager _propset = null;
    private String _myproxyuser = null;
    private String _myproxypwd = null;
    private String _myproxyhost = null;
    private int _myproxyport = 7512;
    private boolean _canceled = false;
    GetMyProxyConnectionParams _getparamsobj = null;

    public CredentialManager() {
	this(new PropertySetManager(), null);
    }

    public CredentialManager(PropertySetManager propset) {
	this(propset, null);
    }

    public CredentialManager(PropertySetManager propset, Component parent) {
	if (propset == null) {
	    throw new NullPointerException("Got null pointer for propset manager");
	}
	_propset = propset;
	_parent = parent;
    }

    private class GetMyProxyConnectionParams implements Runnable {

	Component _parent = null;
	String _host = null;
	String _port = null;
	String _user = null;
	String _pwd = null;
	String _message = null;
	boolean _canceled = false;

	GetMyProxyConnectionParams(Component parent, String host, String port, String user, String pwd) {
	    _parent = parent;
	    _host = host;
	    _port = port;
	    _user = user;
	    _pwd = pwd;
	}

	void setMessage(String message) {
	    _message = message;
	}

	public void run() {
	    GridBagLayout layout = new GridBagLayout();
	    GridBagConstraints constraints = new GridBagConstraints();
	    JPanel panel = new JPanel(layout);
	    JTextField hostfield = new JTextField(_host);
	    JTextField portfield = new JTextField(_port);
	    JTextField userfield = new JTextField(_user);
	    JTextField pwdfield = new JPasswordField(_pwd);
	    constraints.fill = GridBagConstraints.HORIZONTAL;
	    constraints.gridx = 0;
	    constraints.gridy = 1;
	    panel.add(new JLabel("MyProxy host:"), constraints);
	    constraints.gridx = 0;
	    constraints.gridy = 2;
	    panel.add(new JLabel("MyProxy port:"), constraints);
	    constraints.gridx = 0;
	    constraints.gridy = 3;
	    panel.add(new JLabel("User name:"), constraints);
	    constraints.gridx = 0;
	    constraints.gridy = 4;
	    panel.add(new JLabel("Password:"), constraints);
	    constraints.weightx = 1.0;
	    constraints.gridx = 1;
	    constraints.gridy = 1;
	    panel.add(hostfield, constraints);
	    constraints.gridx = 1;
	    constraints.gridy = 2;
	    panel.add(portfield, constraints);
	    constraints.gridx = 1;
	    constraints.gridy = 3;
	    panel.add(userfield, constraints);
	    constraints.gridx = 1;
	    constraints.gridy = 4;
	    panel.add(pwdfield, constraints);
	    if (_message != null) {
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.gridwidth = 2;
		constraints.gridx = 0;
		constraints.gridy = 0;
		panel.add(new JLabel(_message), constraints);
	    }
	    int ret = JOptionPane.showConfirmDialog(_parent, panel, "MyProxy connection parameters", JOptionPane.OK_CANCEL_OPTION);
	    if (ret == JOptionPane.CANCEL_OPTION) {
		_canceled = true;
	    }
	    _host = hostfield.getText();
	    _port = portfield.getText();
	    _user = userfield.getText();
	    _pwd = pwdfield.getText();
	}
    }

    public boolean wasCanceled() {
	return _canceled;
    }

    public void resetCanceled() {
	_canceled = false;
    }

    // if we are not headless, we can ask the user for missing parameters
    public boolean canGetUserInput() {
	return !"true".equals(System.getProperty("java.awt.headless"));
    }

    public synchronized GSSCredential getCredential() {
	return _credential;
    }

    public synchronized GSSCredential getLocalCredential() {
	_canceled = false;
	try {
	    return new LocalCredentialHelper().getDefaultCredential();
	} catch (Exception e) {
	    return null;
	}
    }

    public synchronized GSSCredential getNewCredential(String msg) throws CanceledException, CredentialManagerException, MyProxyException {
	Exception lastexception = null;
	_canceled = false;
	_credential = null;
	if (_myproxyhost == null) {
	    _myproxyhost = _propset.getProperties().getProperty("MyProxyHost");
	}
	if (_myproxyhost == null) {
	    _myproxyhost = System.getenv("MYPROXY_SERVER");
	}
	if (_myproxyport == -1) {
	    String tmpport = _propset.getProperties().getProperty("MyProxyPort");
	    if (tmpport != null) {
		_myproxyport = Integer.valueOf(tmpport);
	    }
	}
	if (_myproxyport == -1) {
	    _myproxyport = 7512;
	}
	if (_myproxyuser == null) {
	    _myproxyuser = _propset.getProperties().getProperty("MyProxyUser");
	}
	if (_myproxyuser == null) {
	    _myproxyuser = System.getenv("MYPROXY_USER");
	}
	if (_myproxypwd == null) {
	    _myproxypwd = System.getenv("MYPROXY_PWD");
	}
	if (canGetUserInput()) {
	    if (_getparamsobj == null) {
		_getparamsobj = new GetMyProxyConnectionParams(_parent, _myproxyhost, (_myproxyport == -1 ? null : (new Integer(_myproxyport)).toString()), _myproxyuser, _myproxypwd);
	    }
	    _getparamsobj.setMessage(msg);
	    _getparamsobj._canceled = false;
	    try {
		SwingUtilities.invokeAndWait(_getparamsobj);
	    } catch (Exception e) {
		throw new CredentialManagerException("Error occurred getting credential params", e);
	    }
	    if (_getparamsobj._canceled) {
		_canceled = true;
		throw new CanceledException("Operation canceled by user");
	    }
	    _myproxyhost = _getparamsobj._host;
	    _myproxyport = (_getparamsobj._port != null) ? Integer.valueOf(_getparamsobj._port) : -1;
	    _myproxyuser = _getparamsobj._user;
	    _myproxypwd = _getparamsobj._pwd;
	}
	_propset.changeProperty("MyProxyHost", _myproxyhost);
	_propset.changeProperty("MyProxyPort", "" + _myproxyport);
	_propset.changeProperty("MyProxyUser", _myproxyuser);
	MyProxy myproxy = new MyProxy(_myproxyhost, _myproxyport);
	_credential = myproxy.get(_myproxyuser, _myproxypwd, 0);
	return _credential;
    }
}
