/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities;

import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 *
 * @author gadde
 */
public class ExceptionDialog {
    public static String getStackTraceAsString(Throwable e) {
	final Writer result = new StringWriter();
	final PrintWriter printWriter = new PrintWriter(result);
	e.printStackTrace(printWriter);
	return result.toString();
    }

    public static JScrollPane getScrollPane(Throwable e) {
	String msg = "Encountered an exception:\n";
	msg += e.toString() + "\n" + getStackTraceAsString(e);
	JTextArea textArea = new JTextArea();
	JScrollPane scrollPane = new JScrollPane(textArea);
	scrollPane.setPreferredSize(new Dimension(500, 200));
	textArea.setText(msg);
	return scrollPane;
    }

    public static void show(Component parent, Throwable e) {
	JScrollPane scrollPane = getScrollPane(e);
	JOptionPane.showMessageDialog(parent, scrollPane, "Error", JOptionPane.ERROR_MESSAGE);
    }
}
