/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities.db;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class LogConnection implements Connection {

    private Connection _conn;
    private String _ID;
    private Logger _logger;

    public LogConnection(Connection conn, String ID, Logger logger) {
        _conn = conn;
        _ID = ID;
        _logger = logger;
    }

    public Statement createStatement() throws SQLException {
        return new LogStatement(_conn.createStatement(), _ID, _logger);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new LogPreparedStatement(sql, _conn.prepareStatement(sql), _ID, _logger);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return _conn.prepareCall(sql);
    }

    public String nativeSQL(String sql) throws SQLException {
        return _conn.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        _conn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return _conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void rollback() throws SQLException {
        _conn.rollback();
    }

    public void close() throws SQLException {
        _conn.close();
    }

    public boolean isClosed() throws SQLException {
        return _conn.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return _conn.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        _conn.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return _conn.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        _conn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return _conn.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        _conn.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return _conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return _conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        _conn.clearWarnings();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return _conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LogPreparedStatement(sql, _conn.prepareStatement(sql, resultSetType, resultSetConcurrency), _ID, _logger);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return _conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return _conn.getTypeMap();
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        _conn.setTypeMap(map);
    }

    public void setHoldability(int holdability) throws SQLException {
        _conn.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        return _conn.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return _conn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return _conn.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        _conn.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        _conn.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return _conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LogPreparedStatement(sql, _conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), _ID, _logger);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return _conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new LogPreparedStatement(sql, _conn.prepareStatement(sql, autoGeneratedKeys), _ID, _logger);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new LogPreparedStatement(sql, _conn.prepareStatement(sql, columnIndexes), _ID, _logger);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new LogPreparedStatement(sql, _conn.prepareStatement(sql, columnNames), _ID, _logger);
    }

    public Clob createClob() throws SQLException {
        return _conn.createClob();
    }

    public Blob createBlob() throws SQLException {
        return _conn.createBlob();
    }

    public NClob createNClob() throws SQLException {
        return _conn.createNClob();
    }

    public SQLXML createSQLXML() throws SQLException {
        return _conn.createSQLXML();
    }

    public boolean isValid(int timeout) throws SQLException {
        return _conn.isValid(timeout);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        _conn.setClientInfo(name, value);
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        _conn.setClientInfo(properties);
    }

    public String getClientInfo(String name) throws SQLException {
        return _conn.getClientInfo(name);
    }

    public Properties getClientInfo() throws SQLException {
        return _conn.getClientInfo();
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return _conn.createArrayOf(typeName, elements);
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return _conn.createStruct(typeName, attributes);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return _conn.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return _conn.isWrapperFor(iface);
    }
}
