/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities.db;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class LogPreparedStatement extends LogStatement implements PreparedStatement {

    private Logger _logger;
    private PreparedStatement _stmt;
    private String _ID;
    private String _sql;
    private List<List<Object>> _paramBatches;

    public LogPreparedStatement(String sql, PreparedStatement stmt, String ID, Logger logger) {
        super(stmt, ID, logger);
        _sql = sql;
        _stmt = stmt;
        _ID = ID;
        _logger = logger;
        _paramBatches = new ArrayList<List<Object>>();
        _paramBatches.add(new ArrayList<Object>());
    }

    private class NullObj {

        private final int sqlType;

        NullObj(int sqlType_) {
            sqlType = sqlType_;
        }

        @Override
        public String toString() {
            return "NullObj{" + "sqlType=" + sqlType + '}';
        }
    }

    private void setParam(int parameterIndex, Object obj) {
        List<Object> _params = _paramBatches.get(_paramBatches.size() - 1);
        int numParams = _params.size();
        for (int i = numParams; i < parameterIndex - 1; i++) {
            _params.add(null);
            numParams++;
        }
        if (numParams == parameterIndex - 1) {
            _params.add(obj);
        } else {
            _params.set(parameterIndex - 1, obj);
        }
    }

    private void logInterpolatedStatement(String methodName) throws SQLException {
        ParameterMetaData meta = _stmt.getParameterMetaData();
        int numParams = meta.getParameterCount();
        StringBuilder sb = new StringBuilder("[" + _ID + "] ");
        for (List<Object> params : _paramBatches) {
            if (numParams  != params.size()) {
                _logger.log(Level.WARNING, "Number of logged params does not match that in prepared statement -- not logging interpolated query for: {0}", _sql);
                return;
            }
            int curind = 0;
            for (int i = 0; i < numParams; i++) {
                int qind = _sql.indexOf('?', curind);
                if (qind == -1) {
                    _logger.log(Level.WARNING, "Can''t find placeholder for param {0} in query.  Not logging interpolated query for: {1}", new Object[]{i + 1, _sql});
                    return;
                }
                sb.append(_sql.substring(curind, qind));
                Object param = params.get(i);
                if (param == null) {
                    sb.append("<null>");
                } else if (param instanceof String) {
                    sb.append("'").append(((String) param).replace("'", "\\'")).append("'");
                } else {
                    sb.append(param.toString());
                }
                curind = qind + 1;
            }
            sb.append(_sql.substring(curind));
            _logger.log(Level.FINE, "{0}: {1}", new Object[]{methodName, sb.toString()});
        }
    }

    public ResultSet executeQuery() throws SQLException {
        logInterpolatedStatement("executeQuery");
        return _stmt.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        logInterpolatedStatement("executeUpdate");
        return _stmt.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        setParam(parameterIndex, new NullObj(sqlType));
        _stmt.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        _paramBatches.clear();
        _stmt.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        logInterpolatedStatement("execute");
        return _stmt.execute();
    }

    public void addBatch() throws SQLException {
        _paramBatches.add(new ArrayList<Object>());
        _stmt.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        setParam(parameterIndex, reader);
        _stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setRef(parameterIndex, x);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setBlob(parameterIndex, x);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setClob(parameterIndex, x);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setArray(parameterIndex, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return _stmt.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        setParam(parameterIndex, new NullObj(sqlType));
        _stmt.setNull(parameterIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return _stmt.getParameterMetaData();
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setRowId(parameterIndex, x);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        setParam(parameterIndex, value);
        _stmt.setNString(parameterIndex, value);
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        setParam(parameterIndex, value);
        _stmt.setNCharacterStream(parameterIndex, value, length);
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        setParam(parameterIndex, value);
        _stmt.setNClob(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        setParam(parameterIndex, reader);
        _stmt.setClob(parameterIndex, reader, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        setParam(parameterIndex, inputStream);
        _stmt.setBlob(parameterIndex, inputStream, length);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        setParam(parameterIndex, reader);
        _stmt.setNClob(parameterIndex, reader, length);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        setParam(parameterIndex, xmlObject);
        _stmt.setSQLXML(parameterIndex, xmlObject);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setBinaryStream(parameterIndex, x, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        setParam(parameterIndex, reader);
        _stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setAsciiStream(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        setParam(parameterIndex, x);
        _stmt.setBinaryStream(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        setParam(parameterIndex, reader);
        _stmt.setCharacterStream(parameterIndex, reader);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        setParam(parameterIndex, value);
        _stmt.setNCharacterStream(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        setParam(parameterIndex, reader);
        _stmt.setClob(parameterIndex, reader);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        setParam(parameterIndex, inputStream);
        _stmt.setBlob(parameterIndex, inputStream);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        setParam(parameterIndex, reader);
        _stmt.setNClob(parameterIndex, reader);
    }
}
