/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.nbirn.fbirn.utilities.download;

import org.nbirn.fbirn.xcede2.catalog.DownloadCatalog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;

/**
 *
 * @author gadde
 */
public class DownloaderCatalog extends DownloadCatalog implements PropertyChangeListener {
    private static final Logger _logger = Logger.getLogger(DownloaderCatalog.class.getName());
    private JPanel _parentPanel;
    private DownloaderCatalogPanels _subPanels;
    private TitledBorder _border = null;

    @Override
    public DownloaderCatalog getCatalog(int index) {
        return (DownloaderCatalog) super.getCatalog(index);
    }

    @Override
    public DownloaderCatalogEntry getEntry(int index) {
        return (DownloaderCatalogEntry) super.getEntry(index);
    }

    @Override
    protected CatalogEntry getNewEntry() {
        return new DownloaderCatalogEntry();
    }

    @Override
    protected Catalog getNewCatalog() {
        return new DownloaderCatalog();
    }

    public DownloaderCatalogPanels getSubPanels() {
        return _subPanels;
    }

    public void setSubPanels(DownloaderCatalogPanels subPanels) {
        _subPanels = subPanels;
    }

    public JPanel getParentPanel() {
        return _parentPanel;
    }

    public void setParentPanel(JPanel _parentPanel) {
        this._parentPanel = _parentPanel;
    }

    public TitledBorder getBorder() {
        return _border;
    }

    public void setBorder(TitledBorder border) {
        _border = border;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("state".equals(propName) && SwingWorker.StateValue.DONE == evt.getNewValue()) {
            if (_parentPanel != null) {
                _parentPanel.setEnabled(false);
            }
        }
    }

}
