/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities.download;

import org.nbirn.fbirn.utilities.CanceledException;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.TimeZone;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class WorkerDownloadFromURL extends WorkerDownload {

    private static final Logger logger = Logger.getLogger(WorkerDownloadFromURL.class.getName());
    private Catalog _topcatalog = null;
    private URI _url = null;
    private File _destFile = null;
    private OutputStream _destStream = null;
    private Component _parent = null;
    private CredentialManager _credman = null;
    private boolean _updateonly = false;
    private TimeZone _timezone = null;
    private int _timeStampCheckDepth = 0;

    public WorkerDownloadFromURL(URI url, File destFile, CredentialManager credman) {
        super(false);
        _url = url;
        _destFile = destFile;
        _credman = credman;
        _updateonly = false;
        _timezone = null;
        _timeStampCheckDepth = 0;
    }

    public WorkerDownloadFromURL(URI url, File destFile, CredentialManager credman, boolean updateonly, boolean dryRun, TimeZone remoteTimeZone, int timeStampCheckDepth) {
        super(dryRun);
        _url = url;
        _destFile = destFile;
        _credman = credman;
        _updateonly = updateonly;
        _timezone = remoteTimeZone;
        _timeStampCheckDepth = timeStampCheckDepth;
    }

    public WorkerDownloadFromURL(URI url, OutputStream destStream, CredentialManager credman) {
        super(false);
        _url = url;
        _destStream = destStream;
        _credman = credman;
        _updateonly = false;
        _timezone = null;
        _timeStampCheckDepth = 0;
    }

    public WorkerDownloadFromURL(URI url, OutputStream destStream, CredentialManager credman, boolean updateonly, boolean dryRun, TimeZone remoteTimeZone, int timeStampCheckDepth) {
        super(dryRun);
        _url = url;
        _destStream = destStream;
        _credman = credman;
        _updateonly = updateonly;
        _timezone = remoteTimeZone;
        _timeStampCheckDepth = timeStampCheckDepth;
    }

    @Override
    public Void doInBackground() throws CanceledException, DownloadException {
        setProgress(0);
        if (_url.getScheme() != null && _url.getScheme().equals("gsiftp")) {
            if (_destFile != null) {
                downloadURLGSIFTP(_url, _destFile, _credman, _updateonly, _timezone, _timeStampCheckDepth);
            } else {
                downloadURLGSIFTP(_url, _destStream, _credman, _updateonly, _timezone, _timeStampCheckDepth);
            }
        } else {
            if (_destFile != null) {
                downloadURLDefault(_url, _destFile);
            } else {
                downloadURLDefault(_url, _destStream);
            }
        }
        return null;
    }

    @Override
    public void done() {
        cleanup(false);
    }
}
