/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.nbirn.fbirn.utilities.AppendOnlyStyledEditorKit;
import org.openide.util.Exceptions;

/**
 *
 * @author gadde
 */
public class EditorKitHandler extends Handler {

    AppendOnlyStyledEditorKit _kit = null;
    int _curOffset = 0;

    public EditorKitHandler(AppendOnlyStyledEditorKit kit, Formatter formatter) {
        _kit = kit;
        this.setFormatter(formatter);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (_kit != null) {
            String str = getFormatter().format(record);
            try {
                _kit.getDocument().insertString(_curOffset, str, null);
                //StringReader reader = new StringReader(str);
                //_kit.read(reader, _kit.createDefaultDocument(), _curOffset);
            //} catch (IOException ex) {
            //    Exceptions.printStackTrace(ex);
            } catch (BadLocationException ex) {
                Exceptions.printStackTrace(ex);
            }
            _curOffset += str.length();
        }
    }

    @Override
    public void flush() {
        // nothing to do
    }

    @Override
    public void close() throws SecurityException {
        // nothing to do
    }
}
