/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.io;

import java.io.File;
import java.io.StringWriter;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.nbirn.fbirn.notecollector.gui.shared.GlobalContainer;
import org.nbirn.fbirn.notes.NoteException;
import org.nbirn.fbirn.notes.NotePrivileges;
import org.nbirn.fbirn.utilities.ExceptionDialog;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
//import org.openide.util.ImageUtilities;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(dtd = "-//org.nbirn.fbirn.notecollector.gui.io//PrivilegesTopComponent//EN",
autostore = false)
public final class PrivilegesTopComponent extends TopComponent {

    private static PrivilegesTopComponent instance;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    private static final String PREFERRED_ID = "PrivilegesTopComponent";
    private GlobalContainer _gcont = null;
    private NotePrivileges _notePrivs = null;
    private Lookup.Result _privResult = null;

    private class PrivListener implements LookupListener {

        public void resultChanged(LookupEvent le) {
            _PrivDisplayArea.setText("");
            Lookup.Result r = (Lookup.Result) le.getSource();
            Collection c = r.allInstances();
            if (!c.isEmpty()) {
                NotePrivileges privs = (NotePrivileges) c.iterator().next();
                StringWriter w = new StringWriter();
                try {
                    privs.write(w);
                    _PrivDisplayArea.setText(w.toString());
                } catch (Exception e) {
                    ExceptionDialog.show(null, e);
                }
            }
        }
    }

    public PrivilegesTopComponent() {
        initComponents();
        setName(NbBundle.getMessage(PrivilegesTopComponent.class, "CTL_PrivilegesTopComponent"));
        setToolTipText(NbBundle.getMessage(PrivilegesTopComponent.class, "HINT_PrivilegesTopComponent"));
//        setIcon(ImageUtilities.loadImage(ICON_PATH, true));

        _gcont = Lookup.getDefault().lookup(GlobalContainer.class);
        Lookup gclookup = _gcont.getLookup();

        _privResult = gclookup.lookupResult(NotePrivileges.class);
        _privResult.addLookupListener(new PrivListener());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        _FileChooser = new javax.swing.JFileChooser();
        _PrivPanel = new javax.swing.JPanel();
        _PrivLoadButton = new javax.swing.JButton();
        _PrivShowButton = new javax.swing.JToggleButton();
        _PrivDisplayScrollPane = new javax.swing.JScrollPane();
        _PrivDisplayArea = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        _PrivPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(PrivilegesTopComponent.class, "PrivilegesTopComponent._PrivPanel.border.title"))); // NOI18N
        _PrivPanel.setMinimumSize(new java.awt.Dimension(200, 50));
        _PrivPanel.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(_PrivLoadButton, org.openide.util.NbBundle.getMessage(PrivilegesTopComponent.class, "PrivilegesTopComponent._PrivLoadButton.text")); // NOI18N
        _PrivLoadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _PrivLoadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        _PrivPanel.add(_PrivLoadButton, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(_PrivShowButton, org.openide.util.NbBundle.getMessage(PrivilegesTopComponent.class, "PrivilegesTopComponent._PrivShowButton.text")); // NOI18N
        _PrivShowButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _PrivShowButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        _PrivPanel.add(_PrivShowButton, gridBagConstraints);

        _PrivDisplayScrollPane.setMinimumSize(new java.awt.Dimension(10, 5));

        _PrivDisplayArea.setColumns(40);
        _PrivDisplayArea.setRows(5);
        _PrivDisplayScrollPane.setViewportView(_PrivDisplayArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        _PrivPanel.add(_PrivDisplayScrollPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(_PrivPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void _PrivLoadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__PrivLoadButtonActionPerformed
        _FileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        int returnVal = _FileChooser.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = _FileChooser.getSelectedFile();
            try {
                if (_notePrivs != null) {
                    _gcont.getContent().remove(_notePrivs);
                }
                _notePrivs = NotePrivileges.read(file);
                _gcont.getContent().add(_notePrivs);
            } catch (NoteException e) {
                ExceptionDialog.show(null, e);
            }
        }
}//GEN-LAST:event__PrivLoadButtonActionPerformed

    private void _PrivShowButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__PrivShowButtonActionPerformed
        if (_PrivShowButton.getModel().isSelected()) {
            _PrivDisplayScrollPane.setVisible(true);
            _PrivShowButton.setText("Hide");
        } else {
            _PrivDisplayScrollPane.setVisible(false);
            _PrivShowButton.setText("Show");
        }
}//GEN-LAST:event__PrivShowButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFileChooser _FileChooser;
    private javax.swing.JTextArea _PrivDisplayArea;
    private javax.swing.JScrollPane _PrivDisplayScrollPane;
    private javax.swing.JButton _PrivLoadButton;
    private javax.swing.JPanel _PrivPanel;
    private javax.swing.JToggleButton _PrivShowButton;
    // End of variables declaration//GEN-END:variables

    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link #findInstance}.
     */
    public static synchronized PrivilegesTopComponent getDefault() {
        if (instance == null) {
            instance = new PrivilegesTopComponent();
        }
        return instance;
    }

    /**
     * Obtain the PrivilegesTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized PrivilegesTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(PrivilegesTopComponent.class.getName()).warning(
                    "Cannot find " + PREFERRED_ID + " component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof PrivilegesTopComponent) {
            return (PrivilegesTopComponent) win;
        }
        Logger.getLogger(PrivilegesTopComponent.class.getName()).warning(
                "There seem to be multiple components with the '" + PREFERRED_ID
                + "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }

    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }

    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    Object readProperties(java.util.Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    @Override
    protected String preferredID() {
        return PREFERRED_ID;
    }
}
