/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes;

import java.awt.Image;
import java.beans.IntrospectionException;
import javax.swing.Action;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;

/**
 *
 * @author gadde
 */
public abstract class LevelNode extends NoteCollectorNode {

    private LevelChildFactory _childFactory = null;

    public LevelNode(NoteLevel level, LevelChildFactory childFactory) throws IntrospectionException {
        super((childFactory == null ? Children.LEAF : Children.create(childFactory, false)), level);
        _childFactory = childFactory;
        setName(level.getName());
    }

    public LevelChildFactory getChildFactory() {
        return _childFactory;
    }

    @Override
    public Action[] getActions(boolean context) {
        return new Action[]{};
    }

    @Override
    public Image getOpenedIcon(int type) {
        return getIcon(type);
    }
}
