/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes;

import java.awt.Image;
import java.beans.IntrospectionException;
import javax.swing.Action;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;

/**
 *
 * @author gadde
 */
public abstract class NoteNode extends NoteCollectorNode implements EditorNoteListener {

    private EditorNote _note = null;

    public NoteNode(String name, EditorNote note, NoteLevel level) throws IntrospectionException {
        super(Children.LEAF, level);
        setName(name);
        _note = note;
        _note.addNoteListener(this);
        initBean();
    }

    private void initBean() {
        if (_note == null) {
            return;
        }
        NoteCollectorNodeBean bean = getBean();
        if (_note.isDirty()) {
            bean.setNumDirty(1);
        } else {
            bean.setNumDirty(0);
        }
        if (_note.isEdited()) {
            bean.setNumEdited(1);
        } else {
            bean.setNumEdited(0);
        }
    }

    @Override
    public Action[] getActions(boolean context) {
        return new Action[]{};
    }

    public EditorNote getNote() {
        return _note;
    }

    public void setNote(EditorNote note) {
        _note = note;
        initBean();
    }

    @Override
    public Image getBaseIcon(int type) {
        return ImageUtilities.loadImage("org/nbirn/fbirn/notecollector/nodes/icons/paperclip.png");
    }

    @Override
    public Image getOpenedIcon(int type) {
        return getIcon(type);
    }

    @Override
    public void changedNote(EditorNote note) {
        NoteCollectorNodeBean bean = getBean();
        int oldNumDirty = bean.getNumDirty();
        int newNumDirty = note.isDirty() ? 1 : 0;
        int oldNumEdited = bean.getNumEdited();
        int newNumEdited = note.isEdited() ? 1 : 0;
        if (oldNumDirty != newNumDirty) {
            bean.setNumDirty(newNumDirty);
            fireIconChange();
        }
        if (oldNumEdited != newNumEdited) {
            bean.setNumEdited(newNumEdited);
            fireDisplayNameChange(null, getDisplayName());
        }
    }
}
