#!/bin/bash

# ===PROLOG START===
echo "This script won't run as is -- it must be installed into another"
echo "directory using Install.sh."
exit 1
# ===PROLOG END===


###################################################################################################
# This shell script add experimental visit, study and segments for a subject to HID as
# specified in the configuration xml file for the subject-visit
# 
#
# No input are needed if <Install.sh> script has been run and HIDPRD has the value of HID password
#	
###################################################################################################
##############################
# Function Definitions
##############################
SELECT_SCANNER()
  {
  echo
  echo "The following scanner files are found."
  echo 
  for ((j=1; j <= NUM_SCANNERS; j+=1));
  do
    echo "    $j. ${SCANNER_FILES[$j]}"
  done
  echo ""
  read -p "Please select one: " SCANNER_NUM
  }

Usage () {
	versionfile=
	if [ -f "${ScriptInstallDir}/SVNVERSION" ] ; then
		versionfile="${ScriptInstallDir}/SVNVERSION"
	elif [ -f "${ScriptInstallDir}/RELEASE_VERSION" ] ; then
		versionfile="${ScriptInstallDir}/RELEASE_VERSION"
	fi
	version="<unknown>"
	if [ x"${versionfile}" != x ] ; then
		version=`cat "${versionfile}"`
	fi
	echo 
	echo "$0 Release ver. $version"
	echo "Usage: $0 <XML Config File>"
	echo 
	echo "You must specify an XML Configuration File (See SubjectVisit.xml for an examples) which"
	echo "will be used to get the project name/id, visit name/id, and study name/id."
	echo
	echo
	echo; }

##############################


if [ "$#" -ne 1 ]
then
	Usage
	exit 1
fi

ConfigFile="$ScriptInstallDir/ConfigureSite"
if [ ! -e "$ConfigFile" ]
then
        echo -e "\n##########################################################################\n"
        echo "Cannot find the configuration file for the site, ConfigureSite."
        echo "Please run Install.sh before running AddExperiment2HID.sh"
        echo -e "\n##########################################################################"
        exit 1
fi

source $ConfigFile

if [ ! -e $1 ]
then
 echo "ERROR: cannot find $1"
 exit 1;
fi

if [ -z "$HostString" ]
then
        echo ""
        echo "Please input the value for the HostString of HID, eg. uci-bic-gpop.nbirn.net:1521:hidprd"
        echo " or uci-bic-gpop.nbirn.net:5432/hidprd for postgres"
        read HostString 
fi

if [ -z "$DBUser" ]
then
	DBUser="BIRNWEB"
         echo ""
        echo "Please input the value for the username of HID:"
        read DBUser

fi


if [ -z "$DBPass" ]
then
	echo ""
	echo "Please input the value for the password of HID:"
        read DBPass
fi

if [ -z "$DBType" ]
then
        echo ""
        echo "Please input the database type (postgres/oracle):"
        read DBType
fi

if [ ! -d $TempDIR ]
then
        mkdir -p $TempDIR
fi

javaString="java -cp $ScriptInstallDir/java:$ScriptInstallDir/java/classes12.jar:$ScriptInstallDir/java/postgresql-8.3-603.jdbc3.jar"


$javaString SqlRunner $HostString $DBUser $DBPass $DBType "select count(*) from nc_humansubject" >/dev/null
if [ $? -ne 0 ];
then
	echo ""
        echo "ERROR: Cannot connect to the database.  Please make sure connection parameters are correct"
        exit 1
fi


$javaString SubjectVisit $1 $DBUser $DBPass $HostString $DBType > $TempDIR/AddVisit_$$.log

if [ $? -ne 0 ];
then
	echo ""
        echo "ERROR: Inserting data to HID failed, please review the log file for more information:"
	echo "$TempDIR/AddVisit_$$.log"
	exit 1
else
	echo "The subject-visit-study has been added to HID successfully and it's ready for upload!"
	echo "The log file is $TempDIR/AddVisit_$$.log"
fi
