#!/usr/bin/python2

import sys, os, xml, xml.xpath, xml.dom.ext.Printer, string, math, re, shutil, time, tokenize, urlparse, tempfile, copy, types
import logging
import threading
if sys.version_info >= (2, 4):
  import subprocess
else:
  import popen2
from xml.dom.ext.reader import Sax2
try:
  import cx_Oracle
except:
  pass

from UploadFunctions import *

urlparse.uses_netloc.append('gsiftp')

################################################################################
# Classes
################################################################################

# Unchanging constants; accessed directly as member variables.
class _Constants:

  m_Species="Human"
  
  m_Institutions = {
  3: "duke-unc",
  5: "harvard-bwh",
  6: "harvard-mgh",
  14: "jhu-cis",
  9: "uci-bic",
  7: "ucla-loni",
  8: "ucsd-fmri",
  20: "ucsf-cind",
  12: "ui-mhcrc",
  13: "umn-cmrr",
  10: "unm-hsc",
  11: "stanford-lucas",
  18: "yale-lccn",
  25: "nih-cit",
  9999: "unknown",
  }
  
  m_SiteIDs={
  3: "0003",
  5: "0005",
  6: "0006",
  14: "0014",
  9: "0009",
  7: "0007",
  8: "0008",
  12: "0012",
  13: "0013",
  10: "0010",
  11: "0011",
  18: "0018",
  20: "0020",
  25: "0025",
  9999: "9999"
  }
  
  m_InstitutionsOrder = [3,5,6,14,9,7,8,20,12,13,10,11,18,25,9999]
  m_SiteOrder=          [3,5,6,14,9,7,8,20,12,13,10,11,18,25,9999]
  m_SiteIDsOrder =      [3,5,6,14,9,7,8,20,12,13,10,11,18,25,9999]

  m_DATASPEC_AUTODETECT = 0
  m_DATASPEC_DICOM = 1
  m_DATASPEC_PFILE = 2
  m_DATASPEC_FFILE = 3
  m_DATASPEC_UCIRAW = 4
  m_DATASPEC_IOWASIGNA5 = 5
  m_DATASPEC_ANALYZE = 6
  m_DATASPEC_MINC = 7
  m_DATASPEC_SIGNA5 = 8
  m_DATASPEC_EPRIME = 9
  m_DATASPEC_CIGAL = 10
  m_DATASPEC_XCEDE = 11
  m_DATASPEC_BXH = 12
  m_DATASPEC_AFNI = 13
  m_DATASPEC_UNKNOWN = 14
  m_DATASPEC_NIFTI = 15
  m_DataSpecifiers=[
  "Auto detect",
  "DICOM",
  "GE PFile",
  "Stanford F/MAG File",
  "UCI Raw",
  "Iowa GE5.x/Signa",
  "Analyze 7.5",
  "MINC",
  "Regular GE Signa 5.x",
  "EPRIME",
  "CIGAL",
  "XCEDE",
  "BXH",
  "AFNI",
  "Unknown",
  "NIFTI",
  ]
  

# Directories for staging remote uploads
class _StagingPaths:

  def __init__(self):
    self.m_TempDIR=None		# The base directory in which to make the root for temporary files for this given upload
    self.m_TempRoot=None	# The root for temporary files in this given upload.

  def get_TempDIR(self):
    return self.m_TempDIR

  def set_TempDIR(self, x):
    self.m_TempDIR = x

  def get_TempRoot(self):
    return self.m_TempRoot

  def set_TempRoot(self, x):
    self.m_TempRoot = x

  def get_TempPath(self, LocalDir):
    if os.path.isabs(LocalDir):
      raise StandardError("Oops!  You sent an absolute path to this function.")
    return os.path.join(self.get_TempRoot(), LocalDir)

  def get_NIFTIDir(self, LocalDir):
    if os.path.isabs(LocalDir):
      raise StandardError("Oops!  You sent an absolute path to this function.")
    return os.path.join(self.get_TempPath(LocalDir), "NiftiFormat")
  

# Variables needed for storing remote files
class _RemotePaths:

  def __init__(self):
    self.m_LocalRemoteHome=None	# The fourth argument to the program -- typically a symlink to the third argument, stored in UploadConfig.m_TargetDir.
    self.m_RemotePath=None	# The base path for where on the remote site to put the files.
    self.m_RemoteBaseURL=None
    self.m_ProjectPath=None		# The part of the remote path that indicates which project directory to upload to.

  def get_RemoteBaseURL(self):
    return self.m_RemoteBaseURL

  def set_RemoteBaseURLstr(self, x):
    self.m_RemoteBaseURL = urlparse.urlparse(x)
    self.set_RemotePath(self.m_RemoteBaseURL[2])
  
  def get_LocalRemoteHome(self):
    return self.m_LocalRemoteHome

  def set_LocalRemoteHome(self, x):
    self.m_LocalRemoteHome = x

  def get_RemotePath(self):
    return self.m_RemotePath

  def set_RemotePath(self, x):
    self.m_RemotePath = x
  
  def get_ProjectPath(self):
    return self.m_ProjectPath

  def set_ProjectPath(self, x):
    self.m_ProjectPath = x

  def get_BaseProject(self):
    return re.match("^/home/Projects/([^_]*)__([0-9]*)/.*$", self.get_RemoteBaseURL()[2]).group(1)

  def get_Project(self):
    return re.match("^/home/Projects/([^_]*__[0-9]*)/.*$", self.get_RemoteBaseURL()[2]).group(1)

#  def get_InstitutionID(self):
#    print [self.get_UploadPath()]
#    return re.match("^/home/Projects/([^_]*)__([0-9]*)/.*$", self.get_UploadPath()).group(2)

#  def get_Project(self):
#    return self.get_BaseProject() + "__" + ("%d" % self.get_InstitutionID())

  def get_LocalRemoteProjectName(self, siteinfo):
    return self.get_Project() + "__" + siteinfo.get_Institution()

  def get_RemoteProjectName(self):
    return self.get_Project()

  #############################################################################
  # A "factory" function that returns the appropriate remote upload class based
  # on the method in the given URL
  #############################################################################
  def get_RemoteUploader(self, insiteinfo, debug=False):
    baseurl = self.get_RemoteBaseURL()
    if baseurl[0] == "srb":
      return _RemoteUploaderSRB(baseurl, debug)
    if baseurl[0] == "gsiftp":
      return _RemoteUploaderGSIFTP(baseurl, insiteinfo, debug)
    logging.info("Can't find an appropriate upload class for " + urlparse.urlunparse(self.m_RemoteBaseURL))
    return None

# Optional FIPS variables
class _FIPSPaths:

  def __init__(self):
    self.m_FIPSFLACDir=None		# FIPS-related variables; not currently used.
    self.m_MyFIPSDir=None		# 
    self.m_FIPSDefaultDatabase=None	# 
    self.m_FIPSDefaultProjectName=None	# 
    self.m_FIPSDefaultProjectID=None	# 

  def get_FIPSFLACDir(self):
    return self.m_FIPSFLACDir

  def set_FIPSFLACDir(self, x):
    self.m_FIPSFLACDir = x

  def get_MyFIPSDir(self):
    return self.m_MyFIPSDir

  def set_MyFIPSDir(self, x):
    self.m_MyFIPSDir = x

  def get_FIPSDefaultDatabase(self):
    return self.m_FIPSDefaultDatabase

  def set_FIPSDefaultDatabase(self, x):
    self.m_FIPSDefaultDatabase = x

  def get_FIPSDefaultProjectName(self):
    return self.m_FIPSDefaultProjectName

  def set_FIPSDefaultProjectName(self, x):
    self.m_FIPSDefaultProjectName = x

  def get_FIPSDefaultProjectID(self):
    return self.m_FIPSDefaultProjectID

  def set_FIPSDefaultProjectID(self, x):
    self.m_FIPSDefaultProjectID = x


# Information about the site that collected the data; used to make sure
# that the data gets parsed from the site-specific format and structure to
# the needed format and structure.
class _SiteInfo:

  def __init__(self):
    self.m_ScriptInstallDir=None	# The directory in which this script resides
    self.m_NativeFormat=None		# The native image format of the unparsed data
    self.m_GeometricNativeFormat=None	# The same, but for geometric nonhuman phantoms
    self.m_StabilityNativeFormat=None	# The same, but for geometric nonhuman phantoms
    self.m_StructFormat=None		# The structural image format of the unparsed data
    self.m_StructAnonFormat=None	# The anonymized image format of the unparsed data
    self.m_BehavioralFormat=None	# The behavioral data format of the unparsed data
    self.m_SegmentFormat=None		# The segment data format of the unparsed data.
    self.m_Institution=None		# For example, "ui-mhcrc"
    self.m_InstitutionID=None		# For example, "0012"
    self.m_AcquisitionSite=None		# For example, "ui-mhcrc"
    self.m_AcquisitionSiteID=None	# For example, "0012"
    self.m_ScannerManufacturer=None	# The company that makes the scanner used in this study
    self.m_ScannerID=None		# The ID, in the database, for this scanner.
    self.m_BehavioralEquipment=None	# The company that makes the behavioral study equipment
    self.m_BehavioralEquipmentID=None	# The ID, in the database, for this equipment.
    self.m_dbHost=None			# The hostname of the Oracle database.
    self.m_dbPort=None			# The port of the Oracle database.
    self.m_dbInstance=None		# The SID of the Oracle database.
    self.m_dbUser=None			# The Oracle user to log in as.
    self.m_dbPass=None			# The password to use when logging in.
    self.m_dbType=None                  # database type (Postgres or Oracle) only for JDBC (IBO)
    self.m_UseCXOracle=1		# Whether or not to use the cx_Oracle module.
    self.m_User=None			# The HID user that we're accessing as.
    self.m_ScannerConfigFile=None	# The scanner config file we want to use.
    self.m_PhantomType=None		# The phantom type for nonhuman uploads (stability or geometric).
    self.m_QAAnalysis=None		# Whether or not to perform QA analysis.
    self.m_PhantomID=None		# The ID for phantoms
    self.m_MyProxyHost=None		# Hostname for MyProxy (if using GridFTP)
    self.m_MyProxyPort=None		# Port for MyProxy (if using GridFTP)
    self.m_GridFTPHost=None		# Hostname of GridFTP server
    self.m_GridFTPPort=None		# Port of GridFTP server

  def get_ScannerNum(self):
    return self.m_ScannerNum

  def set_ScannerConfigFileNum(self, x):
    self.m_ScannerNum = x

  def get_ScriptInstallDir(self):
    return self.m_ScriptInstallDir

  def set_ScriptInstallDir(self, x):
    self.m_ScriptInstallDir = x

  def get_NativeFormat(self):
    return self.m_NativeFormat

  def set_NativeFormat(self, x):
    self.m_NativeFormat = x

  def get_GeometricNativeFormat(self):
    return self.m_GeometricNativeFormat

  def set_GeometricNativeFormat(self, x):
    self.m_GeometricNativeFormat = x

  def get_StabilityNativeFormat(self):
    return self.m_StabilityNativeFormat

  def set_StabilityNativeFormat(self, x):
    self.m_StabilityNativeFormat = x

  def get_StructFormat(self):
    return self.m_StructFormat

  def set_StructFormat(self, x):
    self.m_StructFormat = x

  def get_StructAnonFormat(self):
    return self.m_StructAnonFormat

  def set_StructAnonFormat(self, x):
    self.m_StructAnonFormat = x

  def get_BehavioralFormat(self):
    return self.m_BehavioralFormat

  def set_BehavioralFormat(self, x):
    self.m_BehavioralFormat = x

  def get_SegmentFormat(self):
    return self.m_SegmentFormat

  def set_SegmentFormat(self, x):
    self.m_SegmentFormat = x

  def get_Institution(self):
    return self.m_Institution

  def set_Institution(self, x):
    self.m_Institution = x

  def get_InstitutionID(self):
    return self.m_InstitutionID

  def set_InstitutionID(self, x):
    self.m_InstitutionID = x

  def get_AcquisitionSite(self):
    return self.m_AcquisitionSite

  def set_AcquisitionSite(self, x):
    self.m_AcquisitionSite = x

  def get_AcquisitionSiteID(self):
    return self.m_AcquisitionSiteID

  def set_AcquisitionSiteID(self, x):
    self.m_AcquisitionSiteID = x

  def get_ScannerManufacturer(self):
    return self.m_ScannerManufacturer

  def set_ScannerManufacturer(self, x):
    self.m_ScannerManufacturer = x

  def get_ScannerID(self):
    return self.m_ScannerID

  def set_ScannerID(self, x):
    self.m_ScannerID = x

  def get_BehavioralEquipment(self):
    return self.m_BehavioralEquipment

  def set_BehavioralEquipment(self, x):
    self.m_BehavioralEquipment = x

  def get_BehavioralEquipmentID(self):
    return self.m_BehavioralEquipmentID

  def set_BehavioralEquipmentID(self, x):
    self.m_BehavioralEquipmentID = x

  def get_dbHost(self):
    return self.m_dbHost

  def set_dbHost(self, x):
    self.m_dbHost = x

  def get_dbPort(self):
    return self.m_dbPort

  def set_dbPort(self, x):
    self.m_dbPort = x

  def get_dbType(self):
    return self.m_dbType

  def set_dbType(self, x):
    self.m_dbType = x

  def get_dbInstance(self):
    return self.m_dbInstance

  def set_dbInstance(self, x):
    self.m_dbInstance = x

  def get_dbUser(self):
    return self.m_dbUser

  def set_dbUser(self, x):
    self.m_dbUser = x

  def get_dbPass(self):
    return self.m_dbPass

  def set_dbPass(self, x):
    self.m_dbPass = x

  def get_UseCXOracle(self):
    return self.m_UseCXOracle

  def set_UseCXOracle(self, x):
    self.m_UseCXOracle = x

  def get_User(self):
    return self.m_User

  def set_User(self, x):
    self.m_User = x

  def get_ScannerConfigFile(self):
    return self.m_ScannerConfigFile

  def set_ScannerConfigFile(self, x):
    self.m_ScannerConfigFile = x

  def get_PhantomType(self):
    return self.m_PhantomType

  def set_PhantomType(self, x):
    self.m_PhantomType = x

  def get_QAAnalysis(self):
    return self.m_QAAnalysis

  def set_QAAnalysis(self, x):
    if x[0].upper() == "Y":
      self.m_QAAnalysis = True
    elif x[0].upper() == "N":
      self.m_QAAnalysis = False

  def get_PhantomID(self):
    if self.m_PhantomID:
      return self.m_PhantomID
    else:
      logging.info("Please enter the ID for your phantom (such as 0010_01):")
      self.m_PhantomID = read_one_line()
      return self.m_PhantomID

  def set_PhantomID(self, x):
    self.m_PhantomID = x

  def set_MyProxyHost(self, x):
    self.m_MyProxyHost = x
      
  def set_MyProxyPort(self, x):
    self.m_MyProxyPort = x
      
  def set_GridFTPHost(self, x):
    self.m_GridFTPHost = x
      
  def set_GridFTPPort(self, x):
    self.m_GridFTPPort = x

  def get_MyProxyHost(self):
    return self.m_MyProxyHost
      
  def get_MyProxyPort(self):
    return self.m_MyProxyPort
      
  def get_GridFTPHost(self):
    return self.m_GridFTPHost
      
  def get_GridFTPPort(self):
    return self.m_GridFTPPort
      

# Information gleaned from the produced BXH file.
class _BXHInfo:

  def __init__(self):
    self.m_SeriesDesc=None		# All of the variables herein are parsed or immediately derived from the BXH file
    self.m_StudyDate=None		# 
    self.m_StudyTime=None		# 
    self.m_Modality="MR"		# 
    self.m_Manufacturer=None		# 
    self.m_Model=None			# 
    self.m_MagneticFieldStrength=None	# 
    self.m_SeriesNumber=None		# 
    self.m_ScanningSequence=None	# 
    self.m_AcqPlane=None		# 
    self.m_Matrix_X=None		# 
    self.m_Matrix_Y=None		# 
    self.m_Matrix_Z=None		# 
    self.m_PixelSpacing_X=None		# 
    self.m_PixelSpacing_Y=None		# 
    self.m_PixelSpacing_Z=None		#
    self.m_RASFlag_X=None		# 
    self.m_RASFlag_Y=None		# 
    self.m_RASFlag_Z=None		# 
    self.m_FlipAngle=None		# 
    self.m_SequenceVariant=None		# 
    self.m_StudyNum = None		#
    self.m_DICOMFlipZ = False           #
    self.m_SliceOrder = None            #
    self.m_ScanTime = None              #

  def get_SeriesDesc(self):
    return self.m_SeriesDesc

  def set_SeriesDesc(self, x):
    self.m_SeriesDesc = x

  def get_StudyDate(self):
    return self.m_StudyDate

  def set_StudyDate(self, x):
    self.m_StudyDate = x

  def get_StudyTime(self):
    return self.m_StudyTime

  def set_StudyTime(self, x):
    self.m_StudyTime = x

  def get_StudyDate_StudyTime(self):
    return self.get_StudyDate() + "_" + self.get_StudyTime()

  def get_Modality(self):
    return self.m_Modality

  def set_Modality(self, x):
    self.m_Modality = x

  def get_Manufacturer(self):
    return self.m_Manufacturer

  def set_Manufacturer(self, x):
    self.m_Manufacturer = x

  def get_Model(self):
    return self.m_Model

  def set_Model(self, x):
    self.m_Model = x

  def get_MagneticFieldStrength(self):
    return self.m_MagneticFieldStrength

  def set_MagneticFieldStrength(self, x):
    self.m_MagneticFieldStrength = x

  def get_SeriesNumber(self):
    return self.m_SeriesNumber

  def set_SeriesNumber(self, x):
    self.m_SeriesNumber = x

  def get_ScanningSequence(self):
    return self.m_ScanningSequence

  def set_ScanningSequence(self, x):
    self.m_ScanningSequence = x

  def get_AcqPlane(self):
    return self.m_AcqPlane

  def set_AcqPlane(self, x):
    self.m_AcqPlane = x

  def get_Matrix_X(self):
    return self.m_Matrix_X

  def set_Matrix_X(self, x):
    self.m_Matrix_X = x

  def get_Matrix_Y(self):
    return self.m_Matrix_Y

  def set_Matrix_Y(self, x):
    self.m_Matrix_Y = x

  def get_Matrix_Z(self):
    return self.m_Matrix_Z

  def set_Matrix_Z(self, x):
    self.m_Matrix_Z = x

  def get_PixelSpacing_X(self):
    return self.m_PixelSpacing_X

  def set_PixelSpacing_X(self, x):
    self.m_PixelSpacing_X = x

  def get_PixelSpacing_Y(self):
    return self.m_PixelSpacing_Y

  def set_PixelSpacing_Y(self, x):
    self.m_PixelSpacing_Y = x

  def get_PixelSpacing_Z(self):
    return self.m_PixelSpacing_Z

  def set_PixelSpacing_Z(self, x):
    self.m_PixelSpacing_Z = x

  def get_RASFlag_X(self):
    return self.m_RASFlag_X

  def set_RASFlag_X(self, x):
    self.m_RASFlag_X = x

  def get_RASFlag_Y(self):
    return self.m_RASFlag_Y

  def set_RASFlag_Y(self, x):
    self.m_RASFlag_Y = x

  def get_RASFlag_Z(self):
    return self.m_RASFlag_Z

  def set_RASFlag_Z(self, x):
    self.m_RASFlag_Z = x

  def get_FlipAngle(self):
    return self.m_FlipAngle

  def set_FlipAngle(self, x):
    self.m_FlipAngle = x

  def get_SequenceVariant(self):
    return self.m_SequenceVariant

  def set_SequenceVariant(self, x):
    self.m_SequenceVariant = x
  
  def get_StudyNum(self):
    return self.m_StudyNum

  def set_StudyNum(self, x):
    self.m_StudyNum = x

  def get_DICOMFlipZ(self):
    return self.m_DICOMFlipZ

  def set_DICOMFlipZ(self, x):
    self.m_DICOMFlipZ = x

  def get_SliceOrder(self):
    return self.m_SliceOrder

  def set_SliceOrder(self, x):
    self.m_SliceOrder = x

  def get_ScanTime(self):
    return self.m_ScanTime

  def set_ScanTime(self, x):
    self.m_ScanTime = x


# A helper class that tracks a variable, whether it was found in a config
# file, and whether we've changed it since.
class _LoadedDataCoreElem:

  def __init__(self):
    self.m_value = None		# The value that we're storing.
    self.m_missing = True	# Whether this information was missing from the config file.
    self.m_changed = False	# Whether we've changed this value from what we found in the config file.

  def get_value(self):
    return self.m_value

  def set_value(self, x):
    self.m_value = x

  def get_missing(self):
    return self.m_missing

  def set_missing(self, x):
    self.m_missing = x

  def get_changed(self):
    return self.m_changed

  def set_changed(self, x):
    self.m_changed = x


# A helper that wraps input/modification functions around LoadedDataCoreElem
class _LoadedDataElem:

  def __init__(self, name):
    self.m_name = name			# The name of this element -- used when requesting missing data
    self.m_core = _LoadedDataCoreElem()	# The actual class that contains the value and its missing/changed states.
  
  def get_value(self):
    return self.m_core.get_value()

  def get_int_value(self):
    return string.atoi(self.m_core.get_value())

  def set_value(self, x):
    if x == None:
      logging.info("Please enter the " + m_name + ":")
      self.m_core.set_value(read_one_line())
      self.m_core.set_missing(True)
    else:
      if self.m_core.get_value() != None:
        self.m_core.set_changed(True)
      self.m_core.set_value(x)
      self.m_core.set_missing(False)
      
  def get_changed(self):
    return self.m_core.get_changed()
  
  def get_missing(self):
    return self.m_core.get_missing()
  

# The large number of names and paths needed to build our tree that we want
# to upload to the remote site.  Many are autogenerated by functions.
class _UploadConfig:

  def __init__(self):
    self.m_TargetDir = None		# sys.argv[3].  The directory of parsed files to upload.
    self.m_FileSystem = "Local"		# Remote, Local, or Remote-Local
    self.m_RecruitSiteID = None		# The site that the subject came from.
    self.m_SiteID = None		# The site that did the study
    self.m_ScannerManufacturer = None   # The scanner manufacturer listed in Upload XML
    self.m_dbProjectID = None		# The HID uniqueid for the experiment.
    self.m_tarDICOM = 1                 # Whether to tar-up DICOM directories
    self.m_SeriesList = []		# The list of series (bh1, t1, etc) to upload
    self.m_SeriesDirLocal = []		# The local directory for the series (relative to DataPaths.get_DataRoot() if not absolute)
    self.m_SeriesType = []		# functional, functional-with-behavioral, structural, structural-anon, exclude, behavioral, extra, segmentation, or None
    self.m_SeriesSliceOrder = []	# The order that the slices are found in, in the given series directory.  Comma separated integers.
    self.m_SeriesTime = []	        # The time at which this scan was acquired.  In the form HH:MM:SS
    self.m_SeriesSkipInitialVols = []   # Number of volumes to skip in the series.  None for 'not set'.
    self.m_SeriesSourceData = []	# In derived data, this contains the source of the data for the given series.  Otherwise, None.
    self.m_SeriesSourceID = []		# The ID for the above.
    self.m_SeriesParadigm = []		# The <paradigm> in this series
    self.m_SeriesAnalysisLevelLevel = [] # value of analyisislevel/level
    self.m_SeriesAnalysisLevelName = [] # value of analyisislevel/name
    self.m_SeriesImageFormat = []	# The image format in this series
    self.m_SeriesSeriesNumber = []	# The (scanner) series number for this series
    self.m_SeriesBehaviorDirs = []      # Behavioral data dirs associated with this series
    self.m_Skip = []                    # For any reason, skip this series if True
    self.m_DICOMFlipZ = []              # For Siemens DICOM files which introduce an errant flip

    # canonicalized XML output (to see whether portions of upload XML file
    # have changed since last upload)
    self.m_ProjectXMLString = None
    self.m_VisitXMLString = None
    self.m_StudyXMLString = None
    self.m_SeriesXMLString = []

    self.m_ProjectName = _LoadedDataElem("Project Name")
    self.m_ProjectID = _LoadedDataElem("Project ID")
    self.m_VisitName = _LoadedDataElem("Visit Name")
    self.m_VisitID = _LoadedDataElem("Visit ID")
    self.m_VisitDate = _LoadedDataElem("Visit Date")
    self.m_StudyName = _LoadedDataElem("Study Name")
    self.m_StudyID = _LoadedDataElem("Study ID")
    self.m_StudyTime = _LoadedDataElem("Study Time")
    self.m_SubjectID = _LoadedDataElem("SubjectID")
    self.m_SubjectGroup = _LoadedDataElem("SubjectGroup")
    self.m_SubjectDir = _LoadedDataElem("Subject Dir")

  def get_FileSystem(self):
    return self.m_FileSystem

  def set_FileSystem(self, x):
    if x != "Local" and x != "Remote" and x != "Local-Remote" and x != "Local-In-Place":
      logging.info("Info: Valid FileSystem not set, changing to Local")
      self.m_FileSystem = "Local" 
    else:
      self.m_FileSystem = x

  def get_RecruitSiteID(self):
    return self.m_RecruitSiteID

  def set_RecruitSiteID(self, x):
    self.m_RecruitSiteID = x

  def get_SiteID(self):
    return self.m_SiteID

  def set_SiteID(self, x):
    self.m_SiteID = x

  def get_ScannerManufacturer(self):
    return self.m_ScannerManufacturer

  def set_ScannerManufacturer(self, x):
    self.m_ScannerManufacturer = x

  def get_dbProjectID(self):
    return self.m_dbProjectID

  def set_dbProjectID(self, x):
    self.m_dbProjectID = x

  def get_tarDICOM(self):
    return self.m_tarDICOM

  def set_tarDICOM(self, x):
    self.m_tarDICOM = x

  def get_SeriesList(self, x = None):
    if x == None:
      return self.m_SeriesList
    else:
      return self.m_SeriesList[x]

  def set_SeriesList(self, x, y = None):
    if y == None:
      self.m_SeriesList = x
    else:
      self.m_SeriesList[x] = y

  def get_SeriesDirLocal(self, x = None):
    if x == None:
      return self.m_SeriesDirLocal
    else:
      return self.m_SeriesDirLocal[x]

  def set_SeriesDirLocal(self, x, y = None):
    if y == None:
      self.m_SeriesDirLocal = x
    else:
      self.m_SeriesDirLocal[x] = y

  def get_SeriesNameLocal(self, x = None):
    if x == None:
      return map(self.get_SeriesNameLocal, range(len(self.m_SeriesDirLocal)))
    else:
      (pathhead, pathtail) = os.path.split(self.m_SeriesDirLocal[x])
      if not pathtail:
        (pathhead, pathtail) = os.path.split(path)
      return pathtail

  def get_SeriesType(self, x = None):
    if x == None:
      return self.m_SeriesType
    else:
      return self.m_SeriesType[x]

  def set_SeriesType(self, x, y = None):
    if y == None:
      self.m_SeriesType = x
    else:
      self.m_SeriesType[x] = y

  def get_SeriesSliceOrder(self, x = None):
    if x == None:
      return self.m_SeriesSliceOrder
    else:
      return self.m_SeriesSliceOrder[x]

  def set_SeriesSliceOrder(self, x, y = None):
    if y == None:
      self.m_SeriesSliceOrder = x
    else:
      self.m_SeriesSliceOrder[x] = y

  def get_SeriesTime(self, x = None):
    if x == None:
      return self.m_SeriesTime
    else:
      return self.m_SeriesTime[x]

  def set_SeriesTime(self, x, y = None):
    if y == None:
      self.m_SeriesTime = x
    else:
      self.m_SeriesTime[x] = y

  def get_SeriesSkipInitialVols(self, x = None):
    if x == None:
      return self.m_SeriesSkipInitialVols
    else:
      return self.m_SeriesSkipInitialVols[x]

  def set_SeriesSkipInitialVols(self, x, y = None):
    if y == None:
      self.m_SeriesSkipInitialVols = x
    else:
      self.m_SeriesSkipInitialVols[x] = y

  def get_SeriesSourceData(self, x = None):
    if x == None:
      return self.m_SeriesSourceData
    else:
      return self.m_SeriesSourceData[x]

  def set_SeriesSourceData(self, x, y = None):
    if y == None:
      self.m_SeriesSourceData = x
    else:
      self.m_SeriesSourceData[x] = y

  def get_SeriesSourceID(self, x = None):
    if x == None:
      return self.m_SeriesSourceID
    else:
      return self.m_SeriesSourceID[x]

  def set_SeriesSourceID(self, x, y = None):
    if y == None:
      self.m_SeriesSourceID = x
    else:
      self.m_SeriesSourceID[x] = y

  def get_SeriesParadigm(self, x = None):
    if x == None:
      return self.m_SeriesParadigm
    else:
      return self.m_SeriesParadigm[x]

  def set_SeriesParadigm(self, x, y = None):
    if y == None:
      self.m_SeriesParadigm = x
    else:
      self.m_SeriesParadigm[x] = y

  def get_SeriesAnalysisLevelLevel(self, x = None):
    if x == None:
      return self.m_SeriesAnalysisLevelLevel
    else:
      return self.m_SeriesAnalysisLevelLevel[x]

  def set_SeriesAnalysisLevelLevel(self, x, y = None):
    if y == None:
      self.m_SeriesAnalysisLevelLevel = x
    else:
      self.m_SeriesAnalysisLevelLevel[x] = y

  def get_SeriesAnalysisLevelName(self, x = None):
    if x == None:
      return self.m_SeriesAnalysisLevelName
    else:
      return self.m_SeriesAnalysisLevelName[x]

  def set_SeriesAnalysisLevelName(self, x, y = None):
    if y == None:
      self.m_SeriesAnalysisLevelName = x
    else:
      self.m_SeriesAnalysisLevelName[x] = y

  def get_SeriesImageFormat(self, x = None):
    if x == None:
      return self.m_SeriesImageFormat
    else:
      return self.m_SeriesImageFormat[x]

  def set_SeriesImageFormat(self, x, y = None):
    if y == None:
      self.m_SeriesImageFormat = x
    else:
      self.m_SeriesImageFormat[x] = y

  def get_SeriesSeriesNumber(self, x = None):
    if x == None:
      return self.m_SeriesSeriesNumber
    else:
      return self.m_SeriesSeriesNumber[x]

  def set_SeriesSeriesNumber(self, x, y = None):
    if y == None:
      self.m_SeriesSeriesNumber = x
    else:
      self.m_SeriesSeriesNumber[x] = y

  def get_SeriesBehaviorDirs(self, x = None):
    if x == None:
      return self.m_SeriesBehaviorDirs
    else:
      return self.m_SeriesBehaviorDirs[x]

  def set_SeriesBehaviorDirs(self, x, y = None):
    if y == None:
      self.m_SeriesBehaviorDirs = x
    else:
      self.m_SeriesBehaviorDirs[x] = y

  def get_Skip(self, x = None):
    if x == None:
      return self.m_Skip
    else:
      return self.m_Skip[x]

  def set_Skip(self, x, y = None):
    if y == None:
      self.m_Skip = x
    else:
      self.m_Skip[x] = y

  def get_DICOMFlipZ(self, x = None):
    if x == None:
      return self.m_DICOMFlipZ
    else:
      return self.m_DICOMFlipZ[x]

  def set_DICOMFlipZ(self, x, y = None):
    if y == None:
      self.m_DICOMFlipZ = x
    else:
      self.m_DICOMFlipZ[x] = y

  def get_ProjectXMLString(self):
    return self.m_ProjectXMLString

  def set_ProjectXMLString(self, x):
    self.m_ProjectXMLString = x

  def get_SubjectXMLString(self):
    return self.m_SubjectXMLString

  def set_SubjectXMLString(self, x):
    self.m_SubjectXMLString = x

  def get_VisitXMLString(self):
    return self.m_VisitXMLString

  def set_VisitXMLString(self, x):
    self.m_VisitXMLString = x

  def get_StudyXMLString(self):
    return self.m_StudyXMLString

  def set_StudyXMLString(self, x):
    self.m_StudyXMLString = x

  def get_SeriesXMLString(self, x = None):
    if x == None:
      return self.m_SeriesXMLString
    else:
      return self.m_SeriesXMLString[x]

  def set_SeriesXMLString(self, x, y = None):
    if y == None:
      self.m_SeriesXMLString = x
    else:
      self.m_SeriesXMLString[x] = y

  def get_TargetDir(self):
    return self.m_TargetDir

  def set_TargetDir(self, x):
    self.m_TargetDir = x

  def get_Project(self):
    return self.m_ProjectName.get_value() + "__" + self.m_ProjectID.get_value()
    
  def get_ProjectDir(self):
    return os.path.join(self.get_TargetDir(), self.get_Project())

  def get_ProjectDataMissing(self):
    return self.m_ProjectName.get_missing() | self.m_ProjectID.get_missing()

  def get_VisitDir(self):
    return self.m_VisitName.get_value()+"__"+self.get_SiteID()+"__"+self.m_VisitID.get_value()

  def get_VisitDataMissing(self):
    return self.m_VisitID.get_missing() | self.m_VisitName.get_missing()

  def get_Study(self):
    return self.m_StudyName.get_value() + "__" + self.m_StudyID.get_value()

  def get_StudyDataMissing(self):
    return self.m_StudyID.get_missing() | self.m_StudyName.get_missing()

  def get_SubjectDir(self):
    return self.m_SubjectID.get_value()

  def get_PathRoot(self):
    return os.path.join(self.get_TargetDir(), self.get_Project())

  def get_CurProjectName(self):
    return self.m_SubjectID.get_value()

  def get_CurProjectDir(self):
    return os.path.join(self.get_PathRoot(), self.get_CurProjectName())

  def get_NewProjectName(self):
    if self.m_SubjectID.get_changed():
      if len(self.m_SubjectID.get_value()) < 9:
        return self.get_RecruitSiteID() + "00000" + self.m_SubjectID.get_value()
      else:
        return self.get_CurProjectName()
    else:
      return self.get_CurProjectName()

  def get_NewProjectDir(self):
    return os.path.join(self.get_PathRoot(), self.get_NewProjectName())
  
  def get_LocalRemoteProjectName(self, siteinfo):
    return self.get_Project() + "__" + siteinfo.get_Institution()

  def get_RemoteProjectName(self):
    return self.get_Project()

  def get_CurVisitDir(self):
    return os.path.join(self.get_NewProjectDir(), self.get_VisitDir())

  def get_NewVisitName(self):
    return self.m_VisitName.get_value() + "__" + self.get_SiteID()+"__"+self.m_VisitID.get_value()

  def get_NewVisitDir(self):
    return os.path.join(self.get_NewProjectDir(), self.get_NewVisitName())

  def get_CurStudyDir(self):
    if self.get_FileSystem() != "Local-In-Place":
      return os.path.join(self.get_NewVisitDir(), self.get_Study())
    else:
      return self.get_TargetDir()

  def get_TrueCurStudyDir(self):
    return os.path.join(self.get_NewVisitDir(), self.get_Study())

  def get_NewStudyName(self):
    return self.m_StudyName.get_value() + "__" + self.m_StudyID.get_value()

  def get_NewStudyDir(self):
    if self.get_FileSystem() != "Local-In-Place":
      return os.path.join(self.get_NewVisitDir(), self.get_NewStudyName())
    else:
      return self.get_TargetDir()
    
  def get_TrueNewStudyDir(self):
    return os.path.join(self.get_NewVisitDir(), self.get_NewStudyName())
    
  def IsSeriesTypeValid(self, idx):
    if self.get_SeriesType(idx) == "structural" or self.get_SeriesType(idx) == "functional"  or self.get_SeriesType(idx) == "functional-with-behavioral" or self.get_SeriesType(idx) == "exclude" or  self.get_SeriesType(idx) == "structural-anon" or self.get_SeriesType(idx) == "behavioral" or self.get_SeriesType(idx) == "extra" or self.get_SeriesType(idx) == "segmentation":
      return True
    else:
      return False


# The class that handles paths of unparsed data.
class _DataPaths:

  def __init__(self):
    self.m_DataRoot = None		# sys.argv[1].  The directory of unparsed files to upload.
    self.m_BehaviorRoots = []           # list of directories to search for behavioral data
    
  def get_DataRoot(self):
    return self.m_DataRoot
    
  def set_DataRoot(self, x):
    self.m_DataRoot = x

  def get_LocalPath(self, LocalDir):
    # note that if LocalDir is absolute, then data root will be ignored (by design!)
    # This function also resolves pseudo-links.
    fullpath = os.path.join(self.get_DataRoot(), LocalDir)
    if not os.path.exists(fullpath):
      redirect = ResolvePseudoLink(fullpath)
      if redirect != None:
        logging.info("Resolving pseudo-link " + fullpath + " to " + redirect)
        return redirect
    return fullpath

  def get_BehaviorRoots(self):
    return self.m_BehaviorRoots
    
  def set_BehaviorRoots(self, x):
    self.m_BehaviorRoots = x



# The configuration variables for this particular run.
class _RunConfig:

  def get_TryMax(self):
    return self.m_TryMax

  def get_TryTime(self):
    return self.m_TryTime

  def get_StandardDirectoryNameNifti(self):
    return self.m_StandardDirectoryNameNifti

  m_TryMax=50		#number of trials before giving up a Scommand
  m_TryTime=3600	# number of seconds going to try for Srsync
  m_StandardDirectoryNameNifti="NIFTI4D"	# The directory for NIFTI data


class _Database:

  def __init__(self):
    self.m_db = None		# Our database connection for cx_Oracle
    self.m_cursor = None	# A cursor for issuing database commands
    self.m_result = None	# A temporary result storage variable used by the java version.
    self.m_JavaBin = None	# The location of the java binary.
    self.m_SiteInfo = None	# Our local site info class, needed by the java version to add the script install dir to the classpath

  def get_JavaBin(self):
    if self.m_JavaBin == None:
      self.m_JavaBin = which("java")
    return self.m_JavaBin
    
  def get_SiteInfo(self):
    return self.m_SiteInfo
    
  def set_SiteInfo(self, x):
    self.m_SiteInfo = x

    
  def get_ScriptInstallDir(self):
    return self.m_SiteInfo.get_ScriptInstallDir()
    
  def get_cx_OracleHostString(self):
    if self.m_SiteInfo.get_dbHost():
      return cx_Oracle.makedsn(self.m_SiteInfo.get_dbHost(), self.m_SiteInfo.get_dbPort(), self.m_SiteInfo.get_dbInstance())
    else:
      return self.m_SiteInfo.get_dbInstance()
  
  def get_JavaHostString(self):
    if self.m_SiteInfo.get_dbHost() != None and self.m_SiteInfo.get_dbType() == 'oracle':
      return self.m_SiteInfo.get_dbHost() + (":%d" % self.m_SiteInfo.get_dbPort()) + ":" + self.m_SiteInfo.get_dbInstance()
    elif self.m_SiteInfo.get_dbHost() != None and self.m_SiteInfo.get_dbType() == 'postgres':
      return self.m_SiteInfo.get_dbHost() + (":%d" % self.m_SiteInfo.get_dbPort()) + "/" + self.m_SiteInfo.get_dbInstance()
    else:
      return self.m_SiteInfo.get_dbInstance()
    
  def get_JavaCP(self):
    return " -cp " + self.get_ScriptInstallDir() + "/java" + ":" + self.get_ScriptInstallDir() + "/java/classes12.jar" + ":" + self.get_ScriptInstallDir() + "/java/postgresql-8.3-603.jdbc3.jar "

  def get_JavaString(self):
    try:
      return self.get_JavaBin() + " -Djava.net.preferIPv4Stack=true " + self.get_JavaCP()  + " SqlRunner " + self.get_JavaHostString() + " " + self.m_SiteInfo.get_dbUser() + " " + self.m_SiteInfo.get_dbPass() + " " + self.m_SiteInfo.get_dbType() + " "
    except:
      raise
      # Get more debugging info, then fail in the same way.
      #return self.get_JavaBin() + " -Djava.net.preferIPv4Stack=true " + self.get_JavaCP()  + " SqlRunner " + self.get_JavaHostString() + " " + self.m_SiteInfo.get_dbUser() + " " + self.m_SiteInfo.get_dbPass() + " " + self.m_SiteInfo.get_dbType() + " "
  
  def parse_java_result(self, result):
    if result == '':
      return []
    output = []
    for row in result[:-1].split("\n"):
      output.append(tokenize_string2(row[:-1]))
    return output

  def get_db(self):
    if self.m_SiteInfo.get_UseCXOracle():
      if self.m_db == None:
        try:
          self.m_db = cx_Oracle.connect(self.m_SiteInfo.get_dbUser(), self.m_SiteInfo.get_dbPass(), self.get_cx_OracleHostString())
        except:
          sys.stderr.write("Error connecting to the database.\n")
          sys.exit(2)
      
      return self.m_db
    else:
      return None

  def get_cursor(self):
    if self.m_SiteInfo.get_UseCXOracle():
      if self.m_cursor == None:
        self.m_cursor = self.get_db().cursor()
      return self.m_cursor
    
  def execute(self, statement, quiet=False):
    if not quiet:
      logging.info("SQL: " + statement)
    if self.m_SiteInfo.get_UseCXOracle():
      return self.get_cursor().execute(statement)
    else:
      if not quiet:
        logging.info(self.get_JavaString() + '"' + statement + '"')
      self.m_result = self.parse_java_result(run_cmd(self.get_JavaString() + '"' + statement + '"', quiet)[1])
      return self.m_result

  def executemany(self, statement, data, quiet=False):
    if not quiet:
      logging.info("SQL: " + statement)

    if self.m_SiteInfo.get_UseCXOracle():
      newdata = []
      for row in data:
        dict = {}
        for i in range(len(data)):
          dict[str(i + 1)] = data[i]
        newdata.append(dict)

      if not quiet:
        logging.info(newdata)
      return self.get_cursor().executemany(statement, data)
    else:
      for row in data:
        new_statement = statement
        for i in range(len(row)):
          try:
            # for Postgres boolean type (IBO)
            if row[i] in ['false','true']:
               new_statement = new_statement.replace(":%d" % (i+1), row[i])
            else:
               new_statement = new_statement.replace(":%d" % (i + 1), "'" + row[i] + "'")
          except TypeError:
            new_statement = new_statement.replace(":%d" % (i + 1), "%d" % row[i])
        self.parse_java_result( run_cmd(self.get_JavaString() + '"' + new_statement + '"', quiet)[1])
        
  def fetchone(self):
    if self.m_SiteInfo.get_UseCXOracle():
      return self.get_cursor().fetchone()
    else:
      if len(self.m_result) == 0:
        return []
      ret = self.m_result[0]
      self.m_result = self.m_result[1:]
      return ret

  def fetchall(self):
    if self.m_SiteInfo.get_UseCXOracle():
      return self.get_cursor().fetchall()
    else:
      ret = self.m_result[:]
      self.m_result = None
      return ret

class _LogErrorsFromFile(threading.Thread):
  def __init__(self, fileobj):
    threading.Thread.__init__(self, name='_LogErrorsFromFile')
    self.fileobj = fileobj

  def run(self):
    try:
      str = self.fileobj.readline(1024)
      while str != None:
        if str[-1] == '\n':
          str = str[:-1]
        logging.error(str)
        str = self.fileobj.readline(1024)
    except:
      return
        

# This is a base class for remote upload functionality.
# All methods (except constructor) are empty in the base class.
class _RemoteUploader:
  def __init__(self, inbaseurl):
    self.baseurl = inbaseurl
    self.host = None
    self.scheme = None

  def getHost(self):
    return self.host
  def getScheme(self):
    return self.scheme

  def get(self, remotefile, localfile):
    return None
  def put(self, localfile, remotefile):
    return None
  def pwd(self):
    return None
  def mkdir(self, dir):
    return None
  def rmdir(self, dir):
    return None
  def chdir(self, dir):
    return None
  def rmdirtree(self, dir):
    return None
  # mode is "r" (read), "w" (write), "x" (execute), or "a" (all)
  def addAccessToGroup(self, file, group, mode):
    return None
  def addAccessToGroupRecursive(self, file, group, mode):
    return None
  def addDirMeta(self, dir, name, value):
    return None
  def updateDirMeta(self, dir, name, value):
    return None
  def deleteDirMeta(self, dir, name, value):
    return None
    

class _RemoteUploaderSRB(_RemoteUploader):
  def __init__(self, inbaseurl):
    _RemoteUploader.__init__(self, inbaseurl, debug=False)
    self.scheme = 'srb'
    self.host = ''
    if not(which("Sinit")):
      raise StandardError("SRB Binaries Not Found! Please Check Path Environmental Variable!")
    run_cmd("Sinit")

  def __del__(self):
    run_cmd("Sexit")

  def put(self, localfile, remotefile):
    run_cmd("BSput -f " + localfile + " " + remotefile)
    return True

  def pwd(self):
    return run_cmd("Spwd")[1][:-1]

  def ls(self, glob):
    return run_cmd('Sls "' + glob + '"')[1]

  def mkdir(self, dir):
    run_cmd("Smkdir " + dir)
    return True

  def rmdir(self, dir):
    run_cmd("Srmdir " + dir)
    return True
    
  def chdir(self, dir):
    run_cmd("Scd " + dir)
    return True

  def rmdirtree(self, dir):
    run_cmd("Srm -r " + dir)
    return True

  def addAccessToGroup(self, file, group, mode):
    run_cmd("Schmod " + mode + " " + group + " groups " + file)
    return True

  def addAccessToGroupRecursive(self, file, group, mode):
    run_cmd("Schmod -r " + mode + " " + group + " groups " + file)
    return True

  def addDirMeta(self, dir, name, value):
    run_cmd("Smeta -c -i -I UDSMD_COLL0=" + name + " -I UDSMD_COLL1=" + value + " " + dir)
    return True

  # right now will only change first row
  def updateDirMeta(self, dir, name, value):
    run_cmd("Smeta -c -u 0 -I UDSMD_COLL0=" + name + " -I UDSMD_COLL1=" + value + " " + dir)
    return True


class _RemoteUploaderGSIFTP(_RemoteUploader):
  def __init__(self, inbaseurl, insiteinfo, debug=False):
    _RemoteUploader.__init__(self, inbaseurl)
    self.m_childPopen = None
    self.m_remoteCurDir = "."
    self.m_javaBin = which("java")
    if not(self.m_javaBin):
      raise StandardError("java not found!")
    if not(insiteinfo.get_MyProxyHost()) or not(insiteinfo.get_MyProxyPort()) or not(insiteinfo.get_GridFTPHost()) or not(insiteinfo.get_GridFTPPort()):
      raise StandardError("Error: Site info not populated with fields required for GridFTP!")
    self.scheme = 'gsiftp'
    self.host = insiteinfo.get_GridFTPHost()
    envs = os.environ
    self.scriptinstalldir = insiteinfo.get_ScriptInstallDir()
    self.myproxyhost = insiteinfo.get_MyProxyHost()
    self.myproxyport = insiteinfo.get_MyProxyPort()
    self.gridftphost = insiteinfo.get_GridFTPHost()
    self.gridftpport = insiteinfo.get_GridFTPPort()
    self.debug = debug
    self.connect()
    
  def __del__(self):
    self.disconnect()

  def debugOn(self):
    self.debug = True
  
  def debugOff(self):
    self.debug = False
  
  def connect(self):
    classpathentries = [
      'java',
      'java/cog-jglobus-1.8.0-birnfix.jar',
      'java/birn-sample-1.0.0.jar',
      'java/birn-gridftp-tar-1.0.3.jar',
      'java/birn-util-1.0.0.jar',
      'java/commons-compress-1.0.jar',
      ];
    classpathentriesdebug = [
      'java/log4j-1.2.15.jar',
      ];
    cmdandargs = None
    if self.debug:
      classpath = ':'.join(map(lambda x: os.path.join(self.scriptinstalldir, x), (classpathentries + classpathentriesdebug)))
      cmdandargs = [self.m_javaBin, "-DMYPROXY_SOCKET_TIMEOUT=120", "-Dlog4j.configuration=cog-log4j.properties", "-cp", classpath, "GridFTPCommand", "--debug", self.myproxyhost, self.myproxyport, self.gridftphost, self.gridftpport]
    else:
      classpath = ':'.join(map(lambda x: os.path.join(self.scriptinstalldir, x), classpathentries))
      cmdandargs = [self.m_javaBin, "-DMYPROXY_SOCKET_TIMEOUT=120", "-cp", classpath, "GridFTPCommand", self.myproxyhost, self.myproxyport, self.gridftphost, self.gridftpport]
    logging.debug(' '.join(cmdandargs))
    envs = os.environ
    if sys.version_info >= (2, 4):
      self.m_childPopen = subprocess.Popen(cmdandargs, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE, env=envs, close_fds=True)
    else:
      self.m_childPopen = popen2.Popen3(cmdandargs,True,0)
      self.m_childPopen.stdin = self.m_childPopen.tochild
      self.m_childPopen.stdout = self.m_childPopen.fromchild
      self.m_childPopen.stderr = self.m_childPopen.childerr
    self.m_stderrreader = _LogErrorsFromFile(self.m_childPopen.stderr)
    self.m_stderrreader.start()

    if not(self.m_childPopen):
      raise StandardError("pipe open to GridFTPCommand did not succeed!")
    # read initial prompt
    prompt = self.m_childPopen.stdout.read(2)
    if (prompt != "> "):
      message = prompt
      for line in self.m_childPopen.stdout.readlines():
        message = message + line
      self.m_childPopen.stdin.close()
      self.m_childPopen.stdout.close()
      if self.m_childPopen.poll() != None:
        raise StandardError("GridFTPCommand exited with the following message:\n" + message)
      else:
        raise StandardError("Did not get prompt from GridFTPCommand; got this instead:\n" + message);
      return None

  def disconnect(self):
    if self.m_childPopen != None:
      logging.info("_RemoteUploaderGSIFTP: Closing file objects...")
      self.m_childPopen.stdin.close()
      self.m_childPopen.stdout.close()
      self.m_childPopen.wait()
      logging.info("_RemoteUploaderGSIFTP: ...finished closing file objects.")

  def reconnect(self):
    self.disconnect()
    self.connect()

  def _fixPath(self, oldpath):
    return oldpath
#    if oldpath[0] == '/':
#      return oldpath
#    return self.m_remoteCurDir + "/" + oldpath

  def _callGridFTPCommand(self, command):
    # we assume unbuffered (or at least flushed) pipes to avoid blocking
    logging.info("Sending command: " + command)
    self.m_childPopen.stdin.write(command + "\n");
    lines = []
    curline = []
    afternewline = False
    afterpromptchar = False
    while True:
      c = self.m_childPopen.stdout.read(1)
      if c == '' or c == None:
        break
      if afterpromptchar:
        if c == " ":
          break
        curline.append(">")
        afterpromptchar = False
      if afternewline:
        if c == ">":
          afterpromptchar = True
        afternewline = False
      if c == "\n":
        afternewline = True
        lines.append(''.join(curline))
        curline = []
      else:
        curline.append(c)
    if not afterpromptchar or c != " ":
      raise StandardError("Did not get prompt from GridFTPCommand!");
    if len(lines) < 1:
      raise StandardError("Did not get any output from GridFTPCommand!");
    retval = None
    if lines[0] == "SUCCESS":
      retval = True
    elif lines[0] == "FAILURE":
      retval = False
    else:
      raise StandardError("Expected SUCCESS or FAILURE as first line of output from GridFTPCommand, but got:\n" + lines[0]);
    messagestart = None
    messageend = None
    if len(lines) > 1:
      if lines[1] == "START MESSAGE":
        messagestart = 2
        for i in range(2,len(lines)):
          if lines[i] == "END MESSAGE":
            messageend = i
            break
        if messageend == None:
          raise StandardError("Couldn't find end of message from GridFTPCommand!\n");
    output = lines[messagestart:messageend]
    message = "";
    if messageend != None:
      message = string.join(output, "\n")
    if retval == True:
      return output
    else:
      raise StandardError(message)

  def get(self, remotefile, localfile):
    if self._callGridFTPCommand("get " + self._fixPath(remotefile) + " " + localfile) == False:
      return False
    return True

  def put(self, localfile, remotefile):
    if self._callGridFTPCommand("put " + localfile + " " + self._fixPath(remotefile)) == False:
      return False
    return True

  def pwd(self):
    lines = self._callGridFTPCommand("pwd")
    if lines != None and lines != []:
      return lines[0]
    return None

  def ls(self, glob):
    return self._callGridFTPCommand("ls " + self._fixPath(glob))

  def chdir(self, dir):
    self._callGridFTPCommand("cd " + self._fixPath(dir))
    return True

  def mkdir(self, dir):
    self._callGridFTPCommand("mkdir " + self._fixPath(dir))
    return True

  def rmdir(self, dir):
    self._callGridFTPCommand("rmdir " + self._fixPath(dir))
    return True
    
  def rmdirtree(self, dir):
    self._callGridFTPCommand("rm -r " + self._fixPath(dir))
    return True

  def addAccessToGroup(self, file, group, mode):
    return True

  def addAccessToGroupRecursive(self, file, group, mode):
    return True

  def addDirMeta(self, dir, name, value):
    return True

  def updateDirMeta(self, dir, name, value):
    return True

class _RLS:
  def __init__(self, inrlsurl, insiteinfo, debug=False):
    self.m_javaBin = which("java")
    if not(self.m_javaBin):
      raise StandardError("java not found!")
    if not(insiteinfo.get_MyProxyHost()) or not(insiteinfo.get_MyProxyPort()):
      raise StandardError("Error: Site info not populated with fields required for RLS!")
    classpathentries = [
      'java',
      'java/globus_rls_client.jar',
      'java/cog-jglobus-1.8.0-birnfix.jar',
      'java/birn-sample-1.0.0.jar',
      ];
    classpathentriesdebug = [
      'java/log4j-1.2.15.jar',
      ];
    cmdandargs = None
    if debug:
      classpath = ':'.join(map(lambda x: os.path.join(insiteinfo.get_ScriptInstallDir(), x), (classpathentries + classpathentriesdebug)))
      cmdandargs = [self.m_javaBin, "-DMYPROXY_SOCKET_TIMEOUT=120", "-Dlog4j.configuration=cog-log4j.properties", "-cp", classpath, "RLSCommand", insiteinfo.get_MyProxyHost(), insiteinfo.get_MyProxyPort(), inrlsurl]
    else:
      classpath = ':'.join(map(lambda x: os.path.join(insiteinfo.get_ScriptInstallDir(), x), classpathentries))
      cmdandargs = [ self.m_javaBin, "-DMYPROXY_SOCKET_TIMEOUT=120", "-cp", classpath, "RLSCommand", insiteinfo.get_MyProxyHost(), insiteinfo.get_MyProxyPort(), inrlsurl]
    logging.debug(' '.join(cmdandargs))
    envs = os.environ
    if sys.version_info >= (2, 4):
      self.m_childPopen = subprocess.Popen(cmdandargs, stdin=subprocess.PIPE, stdout=subprocess.PIPE, env=envs, close_fds=True)
    else:
      self.m_childPopen = popen2.Popen3(cmdandargs,False,0)
      self.m_childPopen.stdin = self.m_childPopen.tochild
      self.m_childPopen.stdout = self.m_childPopen.fromchild
    if not(self.m_childPopen):
      raise StandardError("pipe open to RLSCommand did not succeed!")
    # read initial prompt
    prompt = self.m_childPopen.stdout.read(2)
    if (prompt != "> "):
      message = prompt
      for line in self.m_childPopen.stdout.readlines():
        message = message + line
      self.m_childPopen.stdin.close()
      self.m_childPopen.stdout.close()
      if self.m_childPopen.poll() != None:
        raise StandardError("RLSCommand exited with the following message:\n" + message)
      else:
        raise StandardError("Did not get prompt from RLSCommand; got this instead:\n" + message);
      return None

  def __del__(self):
    if self.m_childPopen:
      self.m_childPopen.stdin.close()
      self.m_childPopen.stdout.close()
      self.m_childPopen.wait()
  
  def _callRLSCommand(self, command):
    # we assume unbuffered (or at least flushed) pipes to avoid blocking
    logging.info("Sending command: " + command)
    self.m_childPopen.stdin.write(command + "\n");
    lines = []
    curline = []
    afternewline = False
    afterpromptchar = False
    while True:
      c = self.m_childPopen.stdout.read(1)
      if c == None:
        break
      if afterpromptchar:
        if c == " ":
          break
        curline.append(">")
        afterpromptchar = False
      if afternewline:
        if c == ">":
          afterpromptchar = True
        afternewline = False
      if c == "\n":
        afternewline = True
        lines.append(''.join(curline))
        curline = []
      else:
        curline.append(c)
    if not afterpromptchar or c != " ":
      raise StandardError("Did not get prompt from RLSCommand!");
    if len(lines) < 1:
      raise StandardError("Did not get any output from RLSCommand!");
    retval = None
    if lines[0] == "SUCCESS":
      retval = True
    elif lines[0] == "FAILURE":
      retval = False
    else:
      raise StandardError("Expected SUCCESS or FAILURE as first line of output from RLSCommand, but got:\n" + lines[0]);
    messagestart = None
    messageend = None
    if len(lines) > 1:
      if lines[1] == "START MESSAGE":
        messagestart = 2
        for i in range(2,len(lines)):
          if lines[i] == "END MESSAGE":
            messageend = i
            break
        if messageend == None:
          raise StandardError("Couldn't find end of message from RLSCommand!\n");
    output = []
    if messagestart != None and messageend != None:
      output = lines[messagestart:messageend]
    message = "";
    if messageend != None:
      message = string.join(output, "\n")
    if retval == True:
      return output
    else:
      raise StandardError(message)

  def query(self, lname):
    return self._callRLSCommand("query \"" + lname + "\"")

  def wildquery(self, lname):
    return self._callRLSCommand("wildquery \"" + lname + "\"")

  def delete(self, lname, target):
    self._callRLSCommand("delete \"" + lname + "\" \"" + target + "\"")
    return True

  def deleteall(self, lname):
    self._callRLSCommand("deleteall \"" + lname + "\"")
    return True

  def create(self, lname, tpath):
    self._callRLSCommand("create \"" + lname + "\" \"" + tpath + "\"")
    return True

  def add(self, lname, tpath):
    self._callRLSCommand("add \"" + lname + "\" \"" + tpath + "\"")
    return True

class _Schematron:
  def __init__(self, schematron):
    # Load the xml file
    reader = Sax2.Reader()
    self.schematron = schematron
    try:
      self.stdoc = reader.fromUri(self.schematron)
    except:
      logging.debug("Error reading from schematron file '%s'" % self.schematron)
      self.stdoc = None

  def __destroy__(self):
    if self.stdoc != None:
      del self.stdoc

  ##############################################################################
  # printtraverse() will traverse and only print out all possible tests
  ##############################################################################
  def printtraverse(self, debug=False):
    return self._aux(printtraverse=True, debug=debug)

  ##############################################################################
  # apply() will apply Schematron rules to an XML file and return a count of
  # errors and a list of error messages
  # Parameters:
  #  path           Schematron will be applied to this XML file
  #  phase          If specified, chooses the <phase> element in Schematron
  #  invbs          If specified, provides initial variable bindings
  #  debug          If true, debugging messages will be printed
  ##############################################################################
  def applyToFile(self, path=None, phase=None, invbs={}, debug=False):
    return self._aux(path=path, phase=phase, invbs=invbs, debug=debug)

  def applyToDoc(self, doc=None, docpathname=None, phase=None, invbs={}, debug=False):
    return self._aux(path=docpathname, docnode=doc, phase=phase, invbs=invbs, debug=debug)

  def _aux(self, path=None, docnode=None, phase=None, invbs={}, debug=False, printtraverse=False):
    if printtraverse:
      logging.info('Loading schematron '+self.schematron)
    else:
      logging.info('Applying schematron '+self.schematron)
    if path != None:
      logging.info(' to XML file '+path)
    if phase != None:
      logging.info(' (phase ' + phase + ')')
  
    errors = 0
    errorMsgs = []

    if not printtraverse and path == None and docnode == None:
      logging.error("_Schematron._aux: ERROR: one of path or docnode must be set!\n")
      raise StandardError("_Schematron._aux: ERROR: one of path or docnode must be set!\n")

    if path == None:
      path = "<unknown>"

    doc = None
    if docnode != None:
      doc = docnode
    if doc == None and not printtraverse:
      # Load the xml file
      reader = Sax2.Reader()
      doc = reader.fromUri(path)
    nss = {'xcede': 'http://nbirn.net/Resources/Users/Applications/xcede/', 'fbup': 'http://www.nbirn.net/fbirnupload'}
  
    patterns = []
    if phase == None and not printtraverse:
      patterns = xml.xpath.Evaluate('/schema/pattern', self.stdoc)
    else:
      phasenodes = xml.xpath.Evaluate('/schema/phase', self.stdoc)
      for phasenode in phasenodes:
        phaseid = None
        if not printtraverse:
          phaseid = xml.xpath.Evaluate('@id', phasenode)
          if len(phaseid) == 0 or phase != phaseid[0].nodeValue:
            continue
          if debug:
            logging.info("Found phase node with ID " + phaseid[0].nodeValue)
        activenodes = xml.xpath.Evaluate('active', phasenode)
        for activenode in activenodes:
          patternname = xml.xpath.Evaluate('@pattern', activenode)
          if len(patternname) == 0:
            logging.info("ERROR: no 'pattern' attribute in active element")
            return -1, []
          if debug:
            logging.info(" Looking for pattern " + patternname[0].nodeValue)
          patternnodes = xml.xpath.Evaluate('/schema/pattern[@name="' + patternname[0].nodeValue + '"]', self.stdoc)
          if len(patternnodes) == 0:
            if phaseid == None:
              logging.error("ERROR: phase element references a non-existent pattern '" + patternname[0].nodeValue + "'")
            else:
              logging.error("ERROR: phase element with id='" + phaseid[0].nodeValue + "' references a non-existent pattern '" + patternname[0].nodeValue + "'")
            return -1, []
          if debug:
            logging.info("  Found " + str(len(patternnodes)) + " matching patterns.")
          for patternnode in patternnodes:
            patterns.append(patternnode)
      if len(patterns) == 0:
        logging.info("Didn't find any patterns for phase '" + phase + "' in " + self.schematron + ", skipping...")
    for pattern in patterns:
      vbs = copy.copy(invbs)
      patternname = xml.xpath.Evaluate('string(@name)', pattern)
      fullpatternnamestr = None
      while True:
        if fullpatternnamestr == None:
          fullpatternnamestr = patternname
        else:
          fullpatternnamestr += " | " + patternname
        isanode = xml.xpath.Evaluate('@is-a', pattern)
        if len(isanode) == 0:
          break
        isa = isanode[0].nodeValue
        if debug:
          logging.info("Pattern '" + patternname + "' is a '" + isa + "'")
        abstractpatternnodes = xml.xpath.Evaluate('/schema/pattern[@abstract="true" and @name="' + isa + '"]', self.stdoc)
        if len(abstractpatternnodes) != 1:
          logging.info("ERROR: Can't find single abstract pattern with name '" + isa + "'!")
          return -1, []
        abstractpattern = abstractpatternnodes[0]
        paramnodes = xml.xpath.Evaluate('param', pattern)
        for paramnode in paramnodes:
          namenodes = xml.xpath.Evaluate('@name', paramnode)
          valuenodes = xml.xpath.Evaluate('@value', paramnode)
          if len(namenodes) != 1:
            logging.info("ERROR: Can't find 'name' attribute in param: " + xml2string(paramnode))
            return -1, []
          if len(valuenodes) != 1:
            logging.info("ERROR: Can't find 'value' attribute in param: " + xml2string(paramnode))
            return -1, []
          if debug:
            logging.info(" Adding param '" + namenodes[0].nodeValue + "' = '" + valuenodes[0].nodeValue + "'")
          vbs[(xml.dom.EMPTY_NAMESPACE, namenodes[0].nodeValue)] = valuenodes[0].nodeValue
        pattern = abstractpattern
        patternname = isa
  
      rules = xml.xpath.Evaluate('rule', pattern)
      for rule in rules:
        assertnodes = xml.xpath.Evaluate('assert', rule)
        reportnodes = xml.xpath.Evaluate('report', rule)
        assertreports = []
        for assertnode in assertnodes:
          assertreports.append(['assert', assertnode])
        for reportnode in reportnodes:
          assertreports.append(['report', reportnode])
        for assertreport in assertreports:
          [artype, arnode] = assertreport
          testnodes = xml.xpath.Evaluate('@test', arnode)
          if len(testnodes) == 0:
            logging.info("ERROR: Can't find 'test' attribute in schematron " + artype + ":\n " + xml2string(arnode))
            return -1, []
          artest = testnodes[0].nodeValue
          assertreport.append(artest)
  
        letlist = []
        letnodes = xml.xpath.Evaluate('let', rule)
        for letnode in letnodes:
          namenodes = xml.xpath.Evaluate('@name', letnode)
          valuenodes = xml.xpath.Evaluate('@value', letnode)
          if len(namenodes) != 1:
            logging.info("ERROR: Can't find 'name' attribute in let node in rule '" + rulecontext[0].nodeValue + "'!")
            return -1, []
          if len(valuenodes) != 1:
            logging.info("ERROR: Can't find 'value' attribute in let node in rule '" + rulecontext[0].nodeValue + "'!")
            return -1, []
          letlist.append((namenodes[0].nodeValue, valuenodes[0].nodeValue))
  
        if printtraverse:
          # just to get the variable bindings (like for params in "is-a" rules)
          ctx = xml.xpath.Context.Context(self.stdoc, processorNss=nss, varBindings=vbs)
          cvbs = copy.copy(vbs)
          for letentry in letlist:
            (namestr, valuestr) = letentry
            try:
              value = xml.xpath.Evaluate(valuestr, context=ctx)
            except xml.xpath.pyxpath.SyntaxError, e:
              logging.critical("SyntaxError \"" + e.msg + "\" in XPath expression:\n  " + e.str + "\n  Position:" + str(e.pos) + "\n")
              return -1, []
            except xml.xpath.RuntimeException:
              continue
            if debug:
              logging.info(" Let '" + namestr + "' = '" + valuestr + "'")
            cvbs[(xml.dom.EMPTY_NAMESPACE, namestr)] = value
          # now add the variable bindings from "let" nodes
          ctx = xml.xpath.Context.Context(self.stdoc, processorNss=nss, varBindings=cvbs)
          # go through each assert or report node
          for assertreport in assertreports:
            [artype, arnode, artest] = assertreport
            arstr = ''
            curnode = arnode.firstChild
            while curnode:
              if curnode.nodeType == xml.dom.Node.TEXT_NODE:
                arstr += curnode.nodeValue
              else:
                if curnode.nodeName == 'value-of':
                  selectnode = xml.xpath.Evaluate('@select', curnode)
                  if len(selectnode) != 1:
                    logging.info("Can't find 'select' attribute in 'value-of' element:\n " + xml2string(curnode))
                    return -1, []
                  try:
                    valueretval = xml.xpath.Evaluate('string(' + selectnode[0].nodeValue + ')', context=ctx)
                  except xml.xpath.RuntimeException:
                    valueretval = "<runtime value>"
                  if valueretval:
                    arstr += valueretval
              curnode = curnode.nextSibling
            phasestr = ''
            if phase != None:
              phasestr = phase
            logging.info("Schematron " + artype + ": PATTERN=\"" + fullpatternnamestr.replace('"', '""') + "\" MESSAGE=\"" + arstr.replace('"', '""') + "\"")
          continue
          
        rulecontext = xml.xpath.Evaluate('@context', rule)
        if len(rulecontext) == 0:
          logging.info("ERROR: Can't find 'context' attribute in schematron rule:\n " + xml2string(rule))
          return -1, []
        if debug:
          logging.info("Using rule with context '" + rulecontext[0].nodeValue + "'")
  #      contextstr = replaceParams(rulecontext[0].nodeValue, vbs)
        contextstr = rulecontext[0].nodeValue
        dctx = xml.xpath.Context.Context(doc, processorNss=nss, varBindings=vbs)
        try:
          contextnodes = xml.xpath.Evaluate(contextstr, context=dctx)
        except xml.xpath.pyxpath.SyntaxError, e:
          logging.critical("SyntaxError \"" + e.msg + "\" in XPath expression:\n  " + e.str + "\n  Position:" + str(e.pos) + "\n")
          return -1, []
        if debug:
          logging.info(" Found " + str(len(contextnodes)) + " context nodes")
  
        for contextnode in contextnodes:
          cvbs = copy.copy(vbs)
          for letentry in letlist:
            ctx = xml.xpath.Context.Context(contextnode, processorNss=nss, varBindings=cvbs)
            (namestr, valuestr) = letentry
            try:
              value = xml.xpath.Evaluate(valuestr, context=ctx)
            except xml.xpath.pyxpath.SyntaxError, e:
              logging.critical("SyntaxError \"" + e.msg + "\" in XPath expression:\n  " + e.str + "\n  Position:" + str(e.pos) + "\n")
              return -1, []
            if debug:
              logging.info(" Let '" + namestr + "' = '" + valuestr + "'")
            cvbs[(xml.dom.EMPTY_NAMESPACE, namestr)] = value
  
          ctx = xml.xpath.Context.Context(contextnode, processorNss=nss, varBindings=cvbs)
          for assertreport in assertreports:
            [artype, arnode, artest] = assertreport
            sctx = xml.xpath.Context.Context(arnode, processorNss=nss, varBindings=cvbs)
            showcontextnode = xml.xpath.Evaluate('@fbup:showcontext', context=sctx)
            if debug:
              logging.info(" " + artype)
              logging.info("   test=" + artest)
              if len(showcontextnode) != 0:
                logging.info("   showcontext=" + showcontextnode[0].nodeValue)
            try:
              retval = xml.xpath.Evaluate(artest, context=ctx)
            except xml.xpath.pyxpath.SyntaxError, e:
              logging.critical("SyntaxError \"" + e.msg + "\" in XPath expression:\n  " + e.str + "\n  Position:" + str(e.pos) + "\n")
              return -1, []
            success = 1
            if artype == 'assert':
              success = retval
            elif artype == 'report':
              success = not retval
            arstr = ''
            curnode = arnode.firstChild
            while curnode:
              if curnode.nodeType == xml.dom.Node.TEXT_NODE:
                arstr += curnode.nodeValue
              else:
                if curnode.nodeName == 'value-of':
                  selectnode = xml.xpath.Evaluate('@select', curnode)
                  if len(selectnode) != 1:
                    logging.info("Can't find 'select' attribute in 'value-of' element:\n " + xml2string(curnode))
                    return -1, []
                  valueretval = xml.xpath.Evaluate('string(' + selectnode[0].nodeValue + ')', context=ctx)
                  if valueretval:
                    arstr += valueretval
              curnode = curnode.nextSibling
            phasestr = ''
            if phase != None:
              phasestr = phase
            if debug:
              logging.debug("  Tested: PATH=\"" + path.replace('"', '""') + "\" PHASE=\"" + phasestr.replace('"', '""') + "\" PATTERN=\"" + fullpatternnamestr.replace('"', '""') + "\" MESSAGE=\"" + arstr.replace('"', '""') + "\"")
            if success:
              if debug:
                logging.debug("  Test PASSED")
            else:
              if debug:
                logging.debug("  Test FAILED")
              errMsg = ''
              if artype == 'assert':
                errMsg = errMsg + "Assertion failed: " + arstr + "\n"
              elif artype == 'report':
                errMsg = errMsg + "Error reported: " + arstr + "\n"
              errMsg = errMsg + " xpath test: " + artest + "\n"
              contextstr = ''
              retshowcontext = None
              if len(showcontextnode) != 0:
                try:
                  retshowcontext = xml.xpath.Evaluate(showcontextnode[0].nodeValue, context=ctx)
                except xml.xpath.pyxpath.SyntaxError, e:
                  logging.critical("SyntaxError \"" + e.msg + "\" in XPath expression:\n  " + e.str + "\n  Position:" + str(e.pos) + "\n")
                  return -1, []
                if type(retshowcontext) == types.UnicodeType:
                  contextstr = " detail: " + retshowcontext
                elif type(retshowcontext) == types.ListType:
                  contextstr = " detail:"
                  for node in retshowcontext:
                    contextstr += " " + xml2string(node)
              else:
                contextstr = " in context node:\n  " + xml2string(contextnode)
              errMsg = errMsg + contextstr + "\n"
              #logging.info(errMsg)
              if type(retshowcontext) == types.ListType:
                errorMsgs.append((errMsg, retshowcontext))
              else:
                errorMsgs.append((errMsg, [contextnode]))
              errors = errors + 1
  
    return errors, errorMsgs

