#!/bin/bash

# ===PROLOG START===
echo "This script won't run as is -- it must be installed into another"
echo "directory using Install.sh."
exit 1
# ===PROLOG END===

rev='$LastChangedRevision: 621 $'
revnum=`echo $rev | awk '{print $2}'`

BASEPROJECTS=/home/Projects

if [ $# -le 0 ] ; then
  echo "Usage: $0 PROJECTNAME..."
  echo "PROJECTNAME is the name of a subdirectory of ${BASEPROJECTS}."
fi

# This script will attempt to run (or re-run, if out-of-date) QA on
# uploaded PhaseIII data, and put it under fBIRNPhaseIII__0090/QA_Data .
# Change the following paths to match your system.
UPLOADSCRIPTINSTALL="${ScriptInstallDir}"

# If you want links to the QA to be put into the following directory (say,
# to make it accessible by HTTP) make sure that
# ${BASEHTML}/fBIRNPhaseIII__0090_QA exists and is writeable.  Otherwise
# links will not be created.
BASEHTML=/var/www/html

for project in "$@" ; do
  cd "${BASEPROJECTS}/${project}/Data"
  for studydir in */*/* ; do
    cd "${BASEPROJECTS}/${project}/Data/${studydir}"
    if [ ! -f Upload-orig.xml ] ; then
      continue
    fi
    baselinkdir="${BASEHTML}/${project}_QA/${studydir}"
    baseQAdir="${BASEPROJECTS}/${project}/QA_Data/${studydir}/Analysis"
    qaversionfile="${baseQAdir}/RAWQAVERSION"
    updateqaversionfile=0
    if [ ! -d "${baseQAdir}" ] ; then
      mkdir -p "${baseQAdir}"
    fi
    linkQAdirfull="${baselinkdir}/QA-all"
    linkQAdirpartial="${baselinkdir}/QA-noaslrest10"
    QAdirfull="${baseQAdir}/QAFull__0001"
    QAdirpartial="${baseQAdir}/QAPartial__0001"
    outofdatefull=0
    outofdatepartial=0
    if [ ! -d "${QAdirfull}" ] ; then
      outofdatefull=1
    fi
    if [ ! -d "${QAdirpartial}" ] ; then
      outofdatepartial=1
    fi
    if [ -f "${qaversionfile}" ] ; then
      oldrevnum=`cat "${qaversionfile}" | awk '{print $2}'`
      if (( oldrevnum < 590 )) ; then
	outofdatefull=1
	outofdatepartial=1
      fi
    else
      outofdatefull=1
      outofdatepartial=1
    fi
    inputsfull=()
    inputspartial=()
    for seriesdir in ot{1,2,3,4,5,6,7} audodd{1,2} restFA77 ; do
      wrapper="${seriesdir}/Native/Original__0001/NIFTI4D/ImageWrapper.xml"
      if [ -f "${wrapper}" ] ; then
        if [ "${wrapper}" -nt "${QAdirfull}" ] ; then
          outofdatefull=1
        fi
        inputsfull=("${inputsfull[@]}" "${wrapper}")
        if [ "${wrapper}" -nt "${QAdirpartial}" ] ; then
          outofdatepartial=1
        fi
        inputspartial=("${inputspartial[@]}" "${wrapper}")
      fi
    done
    for seriesdir in restFA10 asl_fairest ; do
      wrapper="${seriesdir}/Native/Original__0001/NIFTI4D/ImageWrapper.xml"
      if [ -f "${wrapper}" ] ; then
        if [ "${wrapper}" -nt "${QAdirfull}" ] ; then
          outofdatefull=1
        fi
        inputsfull=("${inputsfull[@]}" "${wrapper}")
      fi
    done
    if [ ${outofdatefull} -ne 0 -a ${#inputsfull[@]} -gt 0 ] ; then
      updateqaversionfile=1
      echo "${UPLOADSCRIPTINSTALL}/bin/fmriqa_generate.pl" --qalabel "${BASEPROJECTS}/${project}/Data/${studydir}" --overwrite --verbose "${inputsfull[@]}" "${QAdirfull}"
      "${UPLOADSCRIPTINSTALL}/bin/fmriqa_generate.pl" --qalabel "${BASEPROJECTS}/${project}/Data/${studydir}" --overwrite --verbose "${inputsfull[@]}" "${QAdirfull}"
      if [ $? -ne 0 ] ; then
	echo 'ERROR running fmriqa_generate.pl!' 1>&2
	continue
      fi
    fi
    if [ ${outofdatepartial} -ne 0 -a ${#inputspartial[@]} -gt 0 ] ; then
      updateqaversionfile=1
      echo "${UPLOADSCRIPTINSTALL}/bin/fmriqa_generate.pl" --qalabel "${BASEPROJECTS}/${project}/Data/${studydir}" --overwrite --verbose "${inputspartial[@]}" "${QAdirpartial}"
      "${UPLOADSCRIPTINSTALL}/bin/fmriqa_generate.pl" --qalabel "${BASEPROJECTS}/${project}/Data/${studydir}" --overwrite --verbose "${inputspartial[@]}" "${QAdirpartial}"
      if [ $? -ne 0 ] ; then
	echo 'ERROR running fmriqa_generate.pl!' 1>&2
	continue
      fi
    fi
    if [ -d "${BASEHTML}/${project}_QA" ] ; then
      if [ ! -d "${baselinkdir}" ] ; then
        mkdir -p "${baselinkdir}"
      fi
      if [ ! -e "${linkQAdirfull}" ] ; then
        ln -s "${QAdirfull}" "${linkQAdirfull}"
      fi
      if [ ! -e "${linkQAdirpartial}" ] ; then
        ln -s "${QAdirpartial}" "${linkQAdirpartial}"
      fi
    fi
    if [ "${updateqaversionfile}" != 0 -a "${rev}" != "${oldrev}" ] ; then
      echo "${rev}" > "${qaversionfile}"
    fi
  done
done
