/*
   JDBC "oracle" batching: 10-row at a time with a single commit at the end of job
   Auto-commit is switched off for better performance
   Bind variables are used for the insert statements to reduce parsing effort and
   are a prequisite for using oracle batching
*/

import java.io.*;
import java.sql.*;
import java.util.*;
import java.text.*;
import oracle.jdbc.driver.*;

public class BatchInsertData {
   static int    BatchSize        = 10;
   static int    nLine            = 0;
   static String delimiter = "|";

public static void usage() {
   System.err.println("Usage: BatchInsertData <db-url> <user> <pwd> <fileName> [-d delimiter] [-s n] [-R fileNameR] [-D fileNameD]");
   System.err.println("       db-url is the database URL: Server IP address or hostname");
   System.err.println("       <user> <pwd>: username and password to connect to the database");
   System.err.println("       <fileName>: the researchData file for inserting to nc_researchData"); 
   System.err.println("       [-d delimiter]: to specify delimiter character (default is '|'");
   System.err.println("       [-R fileNameR]: the rawData file for inserting to nc_rawData");
   System.err.println("       [-D fileNameD]: the derivedData file for inserting to nc_derivedData");
   System.exit(1);
}

public static void main (String[] args) {
   Connection conn = null;
   String connect_string;
   String Login;
   String Password;
   int    i = 0;
   int    exitCode = 0;
   String fileName = args[3];
   String fileNameR = new String();
   String fileNameD = new String();
    
   if (args.length < 4) {
      usage();
   }  
   i = 4 ;
   do {
      if ( args[i].trim().equals( "-d" )) {
         delimiter = args[i+1].trim();
         i += 2;
      } else if ( args[i].trim().equals( "-s" )) {
         nLine = Integer.parseInt( args[i+1].trim() );
         i += 2;
      } else if ( args[i].trim().equals( "-R" )) {
         fileNameR = args[i+1];
         i += 2;
      } else if ( args[i].trim().equals( "-D" )) {
         fileNameD = args[i+1];
         i += 2;
      } 
   } while ( i < args.length );
 
   connect_string   = "jdbc:oracle:thin:@" + args[0];
   Login = args[1].toUpperCase();
   Password = args[2];

   try {
      Class.forName("oracle.jdbc.driver.OracleDriver");
      conn = DriverManager.getConnection (connect_string, Login, Password );
      conn.setAutoCommit (false);  // Disable auto-commit 
      if (!fileNameR.equals("")) insertRaw(conn, fileNameR);
      if (!fileNameD.equals("")) insertDerived(conn, fileNameD);
      if (!fileName.equals("")) insertResearch(conn, fileName, Login);
      conn.commit();
   } catch (Exception e) {
      e.printStackTrace();
      exitCode = 2;
      if (conn != null)
         try { conn.rollback(); } catch(Exception x) {}
   } finally {
     if (conn != null)
       try { conn.close(); } catch(Exception x) {}
   }
   System.exit( exitCode );
} 
   
private static void insertRaw(Connection conn, String fileName) throws Exception
{
   int recCount = 0; 
   int returnCode = 0; 
   int    i = 0;
   String record = new String();
   PreparedStatement pstmt = null;
      pstmt = conn.prepareStatement ("insert into nc_rawdata "
         + "select uid_seq.nextval, ?, OWNER, sysdate, OWNER, 'nc_rawdata', SEGMENTID, "
         + "COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID, ?,  1, "
         + "PROTOCOLVERSION, PROTOCOLID, ?, 'UNKNOWN', '9999', ?  "
         + "from nc_expSegment where SEGMENTID = ? and COMPONENTID = ? "
         + "and NC_EXPERIMENT_UNIQUEID = ? and SUBJECTID = ?");

      ((OraclePreparedStatement)pstmt).setExecuteBatch (BatchSize);
	 FileReader fr = new FileReader(fileName);
         BufferedReader br = new BufferedReader(fr);
         for (i = 0; i < nLine; i++) {
            br.readLine();
         }
         while ((record = br.readLine()) != null)
         {
            recCount++;
   //System.out.println("-----"+  fileName + "------"+recCount); 
            StringTokenizer st = new StringTokenizer(record, delimiter); 
            String[] c = new String[9];
            for (i=0; i<9; i++) {
               c[i] = st.nextToken();
            }
            
/*
            pstmt.setInt(1,Integer.parseInt( c[0].trim() )); //dataID
*/
            pstmt.setInt(1,Integer.parseInt( c[1].trim() )); //TABLE_ID
            pstmt.setString(2, c[2].trim() );               //dataURI
            pstmt.setInt(3,Integer.parseInt( c[3].trim() )); //EquipID
            pstmt.setInt(4,Integer.parseInt( c[4].trim() )); //isBad
            pstmt.setInt(5,Integer.parseInt( c[5].trim() )); //segmentID
            pstmt.setInt(6,Integer.parseInt( c[6].trim() )); //VisitID
            pstmt.setInt(7,Integer.parseInt( c[7].trim() )); //ProjectID
            pstmt.setString(8,c[8].trim() );                //SubjectID
            pstmt.executeUpdate ();     // Do the update
         } 
      ((OraclePreparedStatement)pstmt).sendBatch();
     if (pstmt != null)
       try { pstmt.close(); } catch(Exception x) {}
}
   
private static void insertDerived(Connection conn, String fileName) throws Exception
{
   int recCount = 0; 
   int returnCode = 0; 
   int    i = 0;
   String record = new String();
   PreparedStatement pstmt = null;
   Statement stmt = null;
      pstmt = conn.prepareStatement ("insert into nc_derivedData "
         + "select uid_seq.nextval, ?, OWNER, sysdate, OWNER, 'nc_deriveddata', ?, 0, "
         + "'UNKNOWN', '9999', SEGMENTID, COMPONENTID, NC_EXPERIMENT_UNIQUEID, "
         + "SUBJECTID, ? from nc_expSegment where SEGMENTID = ? "
         + "and COMPONENTID = ? and NC_EXPERIMENT_UNIQUEID = ? and SUBJECTID = ?");

      // use oracle batching 
      ((OraclePreparedStatement)pstmt).setExecuteBatch (BatchSize);
	 FileReader fr = new FileReader(fileName);
         BufferedReader br = new BufferedReader(fr);
         for (i = 0; i < nLine; i++) {
            br.readLine();
         }
         while ((record = br.readLine()) != null)
         {
            recCount++;
   //System.out.println("-----"+  fileName + "------"+recCount); 
            StringTokenizer st = new StringTokenizer(record, delimiter); 
            String[] c = new String[9];
            for (i=0; i<8; i++) {
               c[i] = st.nextToken();
            }
            
/*
            pstmt.setInt(1,Integer.parseInt( c[0].trim() )); //dataID
*/
            pstmt.setInt(1,Integer.parseInt( c[1].trim() )); //TABLE_ID
            pstmt.setString(2, c[2].trim() );               //dataURI
            pstmt.setInt(3,(Integer.parseInt( c[3].trim() ) + 7 )); //isBad
            pstmt.setInt(4,Integer.parseInt( c[4].trim() )); //segmentID
            pstmt.setInt(5,Integer.parseInt( c[5].trim() )); //VisitID
            pstmt.setInt(6,Integer.parseInt( c[6].trim() )); //ProjectID
            pstmt.setString(7,c[7].trim() );                //SubjectID
            pstmt.executeUpdate ();     // Do the update
         } 
      ((OraclePreparedStatement)pstmt).sendBatch();
      stmt = conn.createStatement ();
      String st = "insert into nc_dataobject "
         + "select uniqueid, tableid, owner, modtime, moduser, 'nc_deriveddata', "
         + "uniqueid, substr(datauri, length(datauri) - 3, 4), "
         + "'human upload script, version 1.0' from nc_deriveddata where isBad > 1";
      stmt.executeQuery (st);
      st = "update nc_deriveddata set isBad = isBad - 7 where isBad > 1";
      stmt.executeQuery (st);
     if (pstmt != null)
       try { pstmt.close(); } catch(Exception x) {}
     if (stmt != null)
       try { stmt.close(); } catch(Exception x) {}
}
   
private static void insertResearch(Connection conn, String fileName, String user) throws Exception
{
   int recCount = 0; 
   int returnCode = 0; 
   int    i = 0;
   String record = new String();
   PreparedStatement pstmt = null;
   Statement stmt = null;
      pstmt = conn.prepareStatement ("insert into nc_researchData "
         + "select uid_seq.nextval, ?, get_database_user_id('" + user + "'), sysdate, "
         + "get_database_user_id('" + user + "'), 'na', ?, 3, "
         + "'UNKNOWN', '9999', ? from dual");

      ((OraclePreparedStatement)pstmt).setExecuteBatch (BatchSize);
	 FileReader fr = new FileReader(fileName);
         BufferedReader br = new BufferedReader(fr);
         for (i = 0; i < nLine; i++) {
            br.readLine();
         }
         while ((record = br.readLine()) != null)
         {
            recCount++;
            StringTokenizer st = new StringTokenizer(record, delimiter); 
            String[] c = new String[9];
            for (i=0; i<4; i++) {
               c[i] = st.nextToken();
            }
            
/*
            pstmt.setInt(1,Integer.parseInt( c[0].trim() )); //dataID
*/
            pstmt.setInt(1,Integer.parseInt( c[1].trim() )); //TABLE_ID
            pstmt.setString(2, c[2].trim() );               //dataURI
            pstmt.setInt(3,(Integer.parseInt( c[3].trim() ) + 7 )); //isBad
            pstmt.executeUpdate ();     // Do the update
         } 
      ((OraclePreparedStatement)pstmt).sendBatch();
     if (pstmt != null)
       try { pstmt.close(); } catch(Exception x) {}
     if (stmt != null)
       try { stmt.close(); } catch(Exception x) {}
}

}
