#!/bin/bash

PACKAGENAME=fBIRNUploadScripts
OUTPUTDIR=/home/gadde/net/www/web\$/wwwroot/home/gadde
FILELIST=(
  AddExperiment2HID.sh
  AddVisit2HID.sh
  COPYRIGHTS-fmriqa
  dbtest.py
  dlgCalendar.py
  FBIRNSubject2007TE_ProjectSetup.xml
  FBIRNSubject2007TE_Template.xml
  FBIRNSubject2007TW_ProjectSetup.xml
  FBIRNSubject2007TW_Template.xml
  Install.sh
  list_scanners.py
  makerelease.sh
  Ped_ProjectSetup.xml
  Ped_SubjectVisit.xml
  Phantom2007.xml
  Phantom2007Distortion.xml
  PhaseIIGeometric.xml
  PhaseIIStability.xml
  PhaseII_Template.xml
  PhaseI_Template_SIRP.xml
  README-fmriqa
  README.htm
  README_AddExperiment2HID.htm
  README_AddVisit2HID.htm
  README_DirectoryOrganization.htm
  README_XMLTemplate.htm
  ReInstall.sh
  ScannerInfo.sh
  SeriesDataDirectory.py
  Upload.py
  UploadClasses.py
  UploadFunctions.py
  XMLUploadGUI.py
  bin/GloverQAWrapper.tcsh
  bin/composite
  bin/convert
  bin/montage
  bin/gnuplot
  bin/xpathcmd.pl
  java/BatchInsertD.class
  java/BatchInsertData.class
  java/BatchInsertData.java
  java/BatchInsertR.class
  java/Configure2HID.class
  java/Configure2HID.java
  java/DataOutput.class
  java/GridFTPCommand$GridFTPCommandException.class
  java/GridFTPCommand.class
  java/GridFTPCommand.java
  java/SetProject.class
  java/SetProject.java
  java/SqlRunner.class
  java/SqlRunner.java
  java/SubjectVisit.class
  java/SubjectVisit.java
  java/Validator.class
  java/Validator.java
  java/classes12.jar
  java/cog-jglobus-1.2-060802.jar
  java/commons-logging-1.1.jar
  java/cryptix-asn1.jar
  java/cryptix32.jar
  java/jce-jdk13-131.jar
  java/postgresql-8.3-603.jdbc3.jar
  java/puretls.jar
  java/runConf.sh
  protocols/FBIRNSubject2007TE.schematron
  protocols/FBIRNSubject2007TW.schematron
  protocols/FBIRNSubject2007TW-test.schematron
)
AFNILIST=(
  3dAutomask
  3dcalc
  3dDetrend
  3dFWHMx
  3dTstat
  3dvolreg
)
XCEDETOOLSLIST=(
  bxh2analyze
  bxh2ppm
  bxhabsorb
  bxhreorient
  ffile2bxh
  File
  fmriqa_count
  fmriqa_generate.pl
  fmriqa_ghostiness
  fmriqa_mean
  fmriqa_minmax
  fmriqa_oediff
  fmriqa_phantomqa
  fmriqa_phantomqa.pl
  fmriqa_spikiness
  fmriqa_stddev
  fmriqa_utils.pm
  fmriqa_volmeasures
  XML
)
BXHABSORBLINKLIST=(
  afni2bxh
  analyze2bxh
  bxh2bxh
  bxh2xcede
  dicom2bxh
  iowa-signafive2bxh
  minc2bxh
  pfile2bxh
  signafive2bxh
  ximg2bxh
)
ADDITIONALEXCLUDES=(
  afni2xcede
  analyze2xcede
  dicom2xcede
  iowa-signafive2xcede
  mgh2bxh
  mgh2xcede
  pfile2xcede
  signafive2xcede
  xcede2bxh
  ximg2xcede
)

skipsvn=0
dorerelease=0
domajor=0
doalpha=0
dobeta=0
architectures=()
platforms=()
while [ $# -gt 0 ] ; do
  case $1 in
    --skipsvn) shift; skipsvn=1 ;;
    --rerelease) shift; dorerelease=1 ;;
    --major) shift; domajor=1 ;;
    --alpha) shift; doalpha=1 ;;
    --beta) shift; dobeta=1 ;;
    --arch)
      shift
      case $1 in
        i386 | x86_64 ) architectures=("${architectures[@]}" $1) ; shift ;;
        *) echo "ERROR: Unsupported architecture '$1'"; exit 1 ;;
      esac
      ;;
    --platform)
      shift
      case $1 in
        centos3 | lsb13 | lsb31 ) platforms=("${platforms[@]}" $1) ; shift ;;
        *) echo "ERROR: Unsupported platform '$1'"; exit 1 ;;
      esac
      ;;
    *) echo "ERROR: Unexpected argument '$1'"; exit 1 ;;
  esac
done
if [ ${doalpha} -eq 1 -a ${dobeta} -eq 1 ] ; then
  echo "ERROR: only one of --alpha, or --beta can be specified"
  exit 1
fi
if [ ${dorerelease} -eq 1 -a \( ${domajor} -eq 1 -o ${doalpha} -eq 1 -o ${dobeta} -eq 1 \) ] ; then
  echo "ERROR: you cannot specify --major, --alpha, or --beta with --rerelease"
  exit 1
fi

if [ ! -f VERSION ] ; then
  echo -e "Can't find VERSION file.  This script must be run from the root of the\nDataUpload SVN working directory."
  exit 1
fi
if [ ! -f RELEASELIST ] ; then
  echo -e "Can't find RELEASELIST file.  This script must be run from the root of the\nDataUpload SVN working directory."
  exit 1
fi
if [ ! -f RELEASEMAP ] ; then
  echo -e "Can't find RELEASEMAP file.  This script must be run from the root of the\nDataUpload SVN working directory."
  exit 1
fi

if [ ! -d .svn ] ; then
  echo -e "Can't find '.svn' directory.  This script must be run from the root of the\nDataUpload SVN working directory."
fi

if [ "${skipsvn}" -eq 0 ] ; then
  svn update
fi

relversions=(DUMMY `cat RELEASELIST | grep tgz | sed -e 's/'"${PACKAGENAME}"'-\([0-9.]\+\)\(-\([0-9]\+\)\)\?-\([^.]\+\)\.\([^.]\+\)\.tgz/\1/'`)
relreleases=(DUMMY `cat RELEASELIST | grep tgz | sed -e 's/'"${PACKAGENAME}"'-\([0-9.]\+\)\(-\([0-9]\+\)\)\?-\([^.]\+\)\.\([^.]\+\)\.tgz/x\3/'`) # add 'x' because most releases will not have a "release" number
relplatforms=(DUMMY `cat RELEASELIST | grep tgz | sed -e 's/'"${PACKAGENAME}"'-\([0-9.]\+\)\(-\([0-9]\+\)\)\?-\([^.]\+\)\.\([^.]\+\)\.tgz/\4/'`)
relarchitectures=(DUMMY `cat RELEASELIST | grep tgz | sed -e 's/'"${PACKAGENAME}"'-\([0-9.]\+\)\(-\([0-9]\+\)\)\?-\([^.]\+\)\.\([^.]\+\)\.tgz/\5/'`)

for (( i = 0 ; i < ${#relreleases[@]} ; i ++)) ; do
  relreleases[${i}]=`echo ${relreleases[${i}]} | sed -e 's/^x//'`
done

vermapverrelease=(`cat RELEASEMAP | cut -d' ' -f 1`)
vermapxcedetools=(`cat RELEASEMAP | cut -d' ' -f 2`)

lastversion=`cat VERSION`
lastmajor=`echo ${lastversion} | sed -e 's/[^0-9]*\([0-9]\+\)\.\([0-9]\+\)\(\([ab]\)\([0-9]\+\)\)\?.*/\1/'`
lastminor=`echo ${lastversion} | sed -e 's/[^0-9]*\([0-9]\+\)\.\([0-9]\+\)\(\([ab]\)\([0-9]\+\)\)\?.*/\2/'`
lastalphabeta=`echo ${lastversion} | sed -e 's/[^0-9]*\([0-9]\+\)\.\([0-9]\+\)\(\([ab]\)\([0-9]\+\)\)\?.*/\4/'`
lastalphabetanum=`echo ${lastversion} | sed -e 's/[^0-9]*\([0-9]\+\)\.\([0-9]\+\)\(\([ab]\)\([0-9]\+\)\)\?.*/\5/'`

# figure out new version number (release number will be set later)
if [ ${dorerelease} -eq 1 ] ; then
  major=${lastmajor}
  minor=${lastminor}
  alphabeta=${lastalphabeta}
  alphabetanum=${lastalphabetanum}
else
  bumpminor=1
  if [ ${domajor} -eq 1 ] ; then
    major=$(( lastmajor + 1 ))
    bumpminor=0
  else
    major=${lastmajor}
  fi
  if [ ${doalpha} -eq 1 ] ; then
    alphabeta=a
    if [ "${lastalphabeta}" = a -a ${domajor} -eq 0 ] ; then
      alphabetanum=$(( lastalphabetanum + 1 ))
      bumpminor=0
    else
      alphabetanum=1
    fi
  elif [ ${dobeta} -eq 1 ] ; then
    alphabeta=b
    if [ "${lastalphabeta}" = b -a ${domajor} -eq 0 ] ; then
      alphabetanum=$(( lastalphabetanum + 1 ))
      bumpminor=0
    elif [ "${lastalphabeta}" = a ] ; then
      alphabetanum=1
      bumpminor=0
    else
      alphabetanum=1
    fi
  else
    alphabeta=
    alphabetanum=
  fi
  if [ ${bumpminor} -eq 1 ] ; then
    minor=$(( lastminor + 1 ))
  else
    minor=${lastminor}
  fi
fi
version="${major}.${minor}${alphabeta}${alphabetanum}"

if [ ${#architectures[*]} -eq 0 ] ; then
  architectures=(i386 x86_64)
fi
if [ ${#platforms[*]} -eq 0 ] ; then
  platforms=(centos3 lsb13 lsb31)
fi

supported=(centos3.x86_64 lsb13.i386 lsb31.i386 lsb31.x86_64)
platarchs=()
for platarch in ${supported[@]} ; do
  for arch in ${architectures[@]} ; do
    for plat in ${platforms[@]} ; do
      if [ "${plat}.${arch}" = "${platarch}" ] ; then
	platarchs[${#platarchs[@]}]="${plat} ${arch}"
      fi
    done
  done
done

for platarch in "${platarchs[@]}" ; do
  mkdir -p "_working"

  platarch=(${platarch})
  platform=${platarch[0]}
  architecture=${platarch[1]}
  numentries=${#relversions[@]}
  lastrelease=
  for (( i = 0 ; i < ${numentries} ; i++ )) ; do
    if [ ${relversions[${i}]} = $version -a ${relplatforms[${i}]} = ${platform} -a ${relarchitectures[${i}]} = ${architecture} ] ; then
      if [ x"${relreleases[${i}]}" = x ] ; then
        # found a release with no release number
        lastrelease=1
      else
        # found a release with a release number
        if [ x"${lastrelease}" = x ] ; then
          # this is the first release we found
          lastrelease=${relreleases[${i}]}
        elif (( ${relreleases[${i}]} > lastrelease  )) ; then
          # this release is later than a previously found release
          lastrelease=${relreleases[${i}]}
        fi
      fi
    fi
  done
  release=
  verrel=
  if [ x"${lastrelease}" = x ] ; then
    release=1
    verrel="${version}"
  else
    release=$(( lastrelease + 1 ))
    verrel="${version}-${release}"
  fi

  foundverrelease=
  xcededist=
  numentries=${#vermapverrelease[@]}
  for (( i = 0 ; i < ${numentries} ; i++ )) ; do
    if [ ${vermapverrelease[${i}]} = ${verrel} ] ; then
      xcededist=${vermapxcedetools[${i}]}
      foundverrelease=1
    fi
  done

  echo "Creating version ${version} release ${release} for ${platform}.${architecture}"
  if [ ${release} -eq 1 ] ; then
    dirname="${PACKAGENAME}-${version}-${platform}.${architecture}"
    filename="${dirname}.tgz"
  else
    dirname="${PACKAGENAME}-${version}-${release}-${platform}.${architecture}"
    filename="${dirname}.tgz"
  fi
  rm -rf "_working/${dirname}"
  mkdir -p "_working/${dirname}"
  mkdir -p "_working/${dirname}/bin"

  # Download and copy relevant BXH/XCEDE Tools files
  xcededir=
  verregexp=
  if [ x"${xcededist}" != x ] ; then
    verregexp="${xcededist}"
  fi
  xcededirs=(`wget --quiet -O - http://fourier.biac.duke.edu/wiki/doku.php/biac:xmlheader | grep 'href="http://www.biac.duke.edu/home/gadde/bxh_xcede_tools-'"${verregexp}"'[^"]*-'"${platform}\.${architecture}"'.tgz"' | sed -e 's%.*href="http://www.biac.duke.edu/home/gadde/\(bxh_xcede_tools-'"${verregexp}"'[^"]*-'"${platform}.${architecture}"'\)\.tgz".*%\1%'`)
  xcedemajor=
  xcedeminor=
  xcedesubminor=
  xcederelease=
  for xcededir in "${xcededirs[@]}" ; do
    tmpmajor=`echo ${xcededir} | sed -e 's/bxh_xcede_tools-\([0-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\)\(-\([0-9]\+\)\)\?.*/\1/'`
    tmpminor=`echo ${xcededir} | sed -e 's/bxh_xcede_tools-\([0-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\)\(-\([0-9]\+\)\)\?.*/\2/'`
    tmpsubminor=`echo ${xcededir} | sed -e 's/bxh_xcede_tools-\([0-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\)\(-\([0-9]\+\)\)\?.*/\3/'`
    tmprelease=`echo ${xcededir} | sed -e 's/bxh_xcede_tools-\([0-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\)\(-\([0-9]\+\)\)\?.*/\5/'`
    if [ x"${xcedemajor}" = x ] || \
          ( [ "${tmpmajor}" -ge "${xcedemajor}" ] && \
            [ "${tmpminor}" -ge "${xcedeminor}" ] && \
            [ "${tmpsubminor}" -ge "${xcedesubminor}" ] && \
            ( [ x"${xcederelease}" = x ] || \
              ( [ x"${tmprelease}" != x ] && \
                [ "${tmprelease}" -ge "${xcederelease}" ] ) ) ) ; then
      xcedemajor=${tmpmajor}
      xcedeminor=${tmpminor}
      xcedesubminor=${tmpsubminor}
      xcederelease=${tmprelease}
    fi
    xcededist="${xcedemajor}.${xcedeminor}.${xcedesubminor}"
  done
  if [ x"${xcederelease}" != x ] ; then
    xcededist="${xcededist}-${xcederelease}"
  fi
  xcededir="bxh_xcede_tools-${xcededist}-${platform}.${architecture}"
  xcedeurl="http://www.biac.duke.edu/home/gadde/${xcededir}.tgz"
  exclude=
  for i in "${BXHABSORBLINKLIST[@]}" "${ADDITIONALEXCLUDES[@]}" ; do
    exclude="${exclude} --exclude ${i}"
  done
  if ! ( wget --quiet -O "_working/${xcededir}.tgz" "${xcedeurl}" && cd "_working" && tar ${exclude} --exclude 'xcede2analyze' -xzf "${xcededir}.tgz" ) ; then
    echo "ERROR: Can't download and/or extract ${xcedeurl}.  Skipping this release..."
    rm -rf "_working"
    continue
  fi
  # remove release number from dir
  xcededir2=`echo ${xcededir} | sed -e 's/-[0-9]\+\(-'"${platform}\\.${architecture}"'\)$/\1/'`
  for file in "${XCEDETOOLSLIST[@]}" ; do
    if cp -r "_working/${xcededir2}/bin/${file}" "_working/${dirname}/bin" ; then
      echo -n -e "Copied ${file}                        \r"
    else
      echo "ERROR copying ${file}.  Fatal error!"
      rm -rf "_working"
      exit 1
    fi
  done
  for file in "${BXHABSORBLINKLIST[@]}" ; do
    cp "_working/${xcededir2}/bin/bxhabsorb" "_working/${dirname}/bin"
  done
  rm -rf "_working/${xcededir2}"

  # Download and copy relevant AFNI files
  afnimap1=(lsb13.i386 centos3.x86_64 lsb31.i386 lsb31.x86_64)
  afnimap2=(linux_gcc32 linux_gcc32 linux_gcc32 linux_gcc33_64)
  numentries=${#afnimap1[@]}
  afnidir=
  for (( i = 0 ; i < ${numentries} ; i++ )) ; do
    if [ ${afnimap1[${i}]} = "${platform}.${architecture}" ] ; then
      afnidir=${afnimap2[${i}]}
    fi
  done
  if [ x"${afnidir}" = x ] ; then
    echo "ERROR: Can't find a relevant AFNI release for '${platform}.${architecture}'.  Skipping this release..."
    rm -rf "_working"
    continue
  fi
  afniurl="http://afni.nimh.nih.gov/pub/dist/tgz/${afnidir}.tgz"
  extract=()
  for file in "${AFNILIST[@]}" ; do
    extract=("${extract[@]}" "${afnidir}/${file}")
  done
  if ! ( wget --quiet -O "_working/${afnidir}.tgz" "${afniurl}" && cd "_working" && tar xzf "${afnidir}.tgz" "${extract[@]}" ) ; then
    echo "ERROR: Can't download and/or extract ${afniurl}.  Skipping this release..."
    rm -rf "_working"
    continue
  fi
  for file in "${AFNILIST[@]}" ; do
    if cp -r "_working/${afnidir}/${file}" "_working/${dirname}/bin" ; then
      echo -n -e "Copied ${file}                         \r"
    else
      echo "ERROR copying ${file}.  Fatal error!"
      rm -rf "_working"
      exit 1
    fi
  done
  rm -rf "_working/${afnidir}"

  # Copy stuff from base DataUpload directory
  for file in "${FILELIST[@]}" ; do
    if cp ${file} "_working/${dirname}" ; then
      echo -n -e "Copied ${file}                         \r"
    else
      echo "ERROR copying ${file}.  Fatal error!"
      rm -rf "_working"
      exit 1
    fi
  done

  echo "${version}" > "_working/${dirname}/VERSION"

  # tar it up
  ( cd "_working" ; tar czf ${dirname}.tgz ${dirname} )

  # put it where it can be accessed
  cp "_working/${dirname}.tgz" "${OUTPUTDIR}"

  rm -rf "_working"

  echo "${version}" > VERSION
  echo "${dirname}.tgz" >> RELEASELIST
  if [ x"${foundverrelease}" = x ] ; then
    echo "${verrel} ${xcededist}" >> RELEASEMAP
    vermapverrelease=("${vermapverrelease[@]}" "${verrel}")
    vermapxcedetools=("${vermapxcedetools[@]}" "${xcededist}")
  fi

  if [ "${skipsvn}" -eq 0 ] ; then
    svn commit -m "Update to version ${version} for ${platform}.${architecture}" VERSION RELEASELIST RELEASEMAP
  fi
done

