/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MainFrame.java
 *
 * Created on Dec 21, 2010, 12:36:53 PM
 */
package org.nbirn.fbirndownloader;

import java.util.concurrent.ExecutionException;
import org.nbirn.fbirn.utilities.download.ProgressBarListener;
import org.nbirn.fbirn.utilities.download.DownloaderCatalogEntry;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromCatalog;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromURL;
import org.nbirn.fbirn.utilities.download.DownloaderCatalog;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.AppPropertyChangerCombo;
import org.nbirn.fbirn.utilities.AppPropertyChangerCheckbox;
import java.awt.Component;
import java.awt.Cursor;

import java.io.File;

import java.net.URI;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import java.net.URISyntaxException;

import java.util.Properties;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirn.utilities.ExceptionDialog;

import org.w3c.dom.Document;

/**
 *
 * @author gadde
 */
public class MainFrame extends javax.swing.JFrame {

    final String XCEDE2NS = "http://www.xcede.org/xcede-2";
    private Main _main = null;
    private DownloaderCatalog _catalog = null;
    Properties _properties = null;
    CredentialManager _credman = null;
    WorkerDownloadFromCatalog _downloadworker = null;
    WorkerDownloadFromURL _catalogworker = null;
    private static Log _logger = LogFactory.getLog(MainFrame.class.getName());
    //private static Logger logger = Logger.getLogger(Main.class.getName());
    private final int _numsavedprops = 10;

    /** Creates new form MainFrame */
    public MainFrame(Main main) {

        initComponents();
        _main = main;
        Vector<String> outputDirSet = _main.getPropertySet("outputDir");
        _OutputDirTextField.removeAllItems();
        for (int i = 0; i < outputDirSet.size(); i++) {
            _OutputDirTextField.addItem(makeObj(outputDirSet.get(i)));
        }
        Vector<String> sourceURLSet = _main.getPropertySet("sourceURL");
        _SourceURLTextField.removeAllItems();
        for (int i = 0; i < sourceURLSet.size(); i++) {
            _SourceURLTextField.addItem(makeObj(sourceURLSet.get(i)));
        }
        String propDryRun = _main.getProperty("dryRun");
        if (propDryRun != null) {
            _DryRunCheckBox.setSelected(Boolean.valueOf(propDryRun));
        }
        String propUpdate = _main.getProperty("update");
        if (propUpdate != null) {
            _UpdateQuestionCheckBox.setSelected(Boolean.valueOf(propUpdate));
        }
        String propDoCatalog = _main.getProperty("doCatalog");
        if (propDoCatalog != null) {
            _DoCatalogCheckBox.setSelected(Boolean.valueOf(propDoCatalog));
        }
        AppPropertyChangerCombo catchanger = new AppPropertyChangerCombo(_main, "sourceURL", _SourceURLTextField);
        AppPropertyChangerCombo outputchanger = new AppPropertyChangerCombo(_main, "outputDir", _OutputDirTextField);
        _SourceURLTextField.addActionListener(catchanger);
        _OutputDirTextField.addActionListener(outputchanger);
        AppPropertyChangerCheckbox dryrunchanger = new AppPropertyChangerCheckbox(_main, "dryRun", _DryRunCheckBox);
        AppPropertyChangerCheckbox updatechanger = new AppPropertyChangerCheckbox(_main, "update", _UpdateQuestionCheckBox);
        AppPropertyChangerCheckbox docatalogchanger = new AppPropertyChangerCheckbox(_main, "doCatalog", _DoCatalogCheckBox);
        _DryRunCheckBox.addItemListener(dryrunchanger);
        _UpdateQuestionCheckBox.addItemListener(updatechanger);
        _DoCatalogCheckBox.addItemListener(docatalogchanger);
        this.pack();
        _credman = new CredentialManager(_main, this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        _OutputDirFileChooser = new javax.swing.JFileChooser();
        _TopScrollPane = new javax.swing.JScrollPane();
        _TopPanel = new javax.swing.JPanel();
        _OutputDirPanel = new javax.swing.JPanel();
        _OutputDirLabel = new javax.swing.JLabel();
        _OutputDirTextField = new javax.swing.JComboBox();
        _OutputDirButton = new javax.swing.JButton();
        _SourcePanel = new javax.swing.JPanel();
        _SourceURLLabel = new javax.swing.JLabel();
        _SourceURLTextField = new javax.swing.JComboBox();
        _DoCatalogCheckBox = new javax.swing.JCheckBox();
        _SourceSpacer = new javax.swing.JPanel();
        _DownloadPanel = new javax.swing.JPanel();
        _DownloadButton = new javax.swing.JButton();
        _UpdateQuestionPanel = new javax.swing.JPanel();
        _UpdateQuestionCheckBox = new javax.swing.JCheckBox();
        _CheckboxPanelSpacer = new javax.swing.JPanel();
        _DryRunCheckBox = new javax.swing.JCheckBox();
        _DownloadProgressBar = new javax.swing.JProgressBar();
        _DownloadProgressPanel = new javax.swing.JPanel();
        _DownloadSpacerPanel = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("FBIRN Downloader");
        getContentPane().setLayout(new java.awt.GridBagLayout());

        _TopPanel.setLayout(new java.awt.GridBagLayout());

        _OutputDirPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        _OutputDirPanel.setLayout(new java.awt.GridBagLayout());

        _OutputDirLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _OutputDirLabel.setText("Output dir:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _OutputDirPanel.add(_OutputDirLabel, gridBagConstraints);

        _OutputDirTextField.setEditable(true);
        _OutputDirTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _OutputDirPanel.add(_OutputDirTextField, gridBagConstraints);

        _OutputDirButton.setFont(new java.awt.Font("Dialog", 0, 12));
        _OutputDirButton.setText("Browse...");
        _OutputDirButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _OutputDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        _OutputDirPanel.add(_OutputDirButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_OutputDirPanel, gridBagConstraints);

        _SourcePanel.setLayout(new java.awt.GridBagLayout());

        _SourceURLLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _SourceURLLabel.setText("Source URL");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        _SourcePanel.add(_SourceURLLabel, gridBagConstraints);

        _SourceURLTextField.setEditable(true);
        _SourceURLTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourcePanel.add(_SourceURLTextField, gridBagConstraints);

        _DoCatalogCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        _DoCatalogCheckBox.setSelected(true);
        _DoCatalogCheckBox.setText("Source is an XCEDE2 download catalog");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourcePanel.add(_DoCatalogCheckBox, gridBagConstraints);

        _SourceSpacer.setPreferredSize(new java.awt.Dimension(1, 10));
        _SourceSpacer.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        _SourcePanel.add(_SourceSpacer, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        _TopPanel.add(_SourcePanel, gridBagConstraints);

        _DownloadPanel.setLayout(new java.awt.GridBagLayout());

        _DownloadButton.setText("Download");
        _DownloadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _DownloadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        _DownloadPanel.add(_DownloadButton, gridBagConstraints);

        _UpdateQuestionPanel.setLayout(new java.awt.GridBagLayout());

        _UpdateQuestionCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        _UpdateQuestionCheckBox.setSelected(true);
        _UpdateQuestionCheckBox.setText("Update local files only if remote files are newer");
        _UpdateQuestionPanel.add(_UpdateQuestionCheckBox, new java.awt.GridBagConstraints());

        _CheckboxPanelSpacer.setMinimumSize(new java.awt.Dimension(20, 0));
        _CheckboxPanelSpacer.setPreferredSize(new java.awt.Dimension(20, 20));

        javax.swing.GroupLayout _CheckboxPanelSpacerLayout = new javax.swing.GroupLayout(_CheckboxPanelSpacer);
        _CheckboxPanelSpacer.setLayout(_CheckboxPanelSpacerLayout);
        _CheckboxPanelSpacerLayout.setHorizontalGroup(
            _CheckboxPanelSpacerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        _CheckboxPanelSpacerLayout.setVerticalGroup(
            _CheckboxPanelSpacerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        _UpdateQuestionPanel.add(_CheckboxPanelSpacer, new java.awt.GridBagConstraints());

        _DryRunCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        _DryRunCheckBox.setText("Dry run (don't actually download anything)");
        _UpdateQuestionPanel.add(_DryRunCheckBox, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        _DownloadPanel.add(_UpdateQuestionPanel, gridBagConstraints);

        _DownloadProgressBar.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        _DownloadPanel.add(_DownloadProgressBar, gridBagConstraints);

        _DownloadProgressPanel.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        _DownloadProgressPanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        _DownloadPanel.add(_DownloadProgressPanel, gridBagConstraints);

        _DownloadSpacerPanel.setPreferredSize(new java.awt.Dimension(0, 0));

        javax.swing.GroupLayout _DownloadSpacerPanelLayout = new javax.swing.GroupLayout(_DownloadSpacerPanel);
        _DownloadSpacerPanel.setLayout(_DownloadSpacerPanelLayout);
        _DownloadSpacerPanelLayout.setHorizontalGroup(
            _DownloadSpacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        _DownloadSpacerPanelLayout.setVerticalGroup(
            _DownloadSpacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        _DownloadPanel.add(_DownloadSpacerPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        _TopPanel.add(_DownloadPanel, gridBagConstraints);

        _TopScrollPane.setViewportView(_TopPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(_TopScrollPane, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private Object makeObj(final String item) {
        return new Object() {

            @Override
            public String toString() {
                return item;
            }
        };
    }

    private void _OutputDirButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__OutputDirButtonActionPerformed
        while (true) {
            _OutputDirFileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            Object selected = _OutputDirTextField.getSelectedItem();
            if (selected != null) {
                File initdir = new File(selected.toString());
                _OutputDirFileChooser.setCurrentDirectory(initdir);
            }
            int returnVal = _OutputDirFileChooser.showOpenDialog(this);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = _OutputDirFileChooser.getSelectedFile();
                String outputDir = file.getAbsolutePath();
                if (!file.exists()) {
                    Object[] options = {"Yes", "No"};
                    returnVal = JOptionPane.showOptionDialog(this, "Directory '" + outputDir + "' doesn't exist.\nWould you like to create it?", "Create Directory?", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[1]);
                    if (returnVal == 1) {
                        continue;
                    }
                    if (!file.mkdirs()) {
                        JOptionPane.showMessageDialog(this, "Error creating directory.", "Error", JOptionPane.ERROR_MESSAGE);
                        continue;
                    }
                }
                boolean found = false;
                for (int i = 0; i < _OutputDirTextField.getItemCount(); i++) {
                    if (outputDir.equals(_OutputDirTextField.getItemAt(i))) {
                        found = true;
                        _OutputDirTextField.setSelectedIndex(i);
                    }
                }
                if (!found) {
                    _OutputDirTextField.insertItemAt(makeObj(outputDir), 0);
                    _OutputDirTextField.setSelectedIndex(0);
                }
                break;
            } else if (returnVal == JFileChooser.CANCEL_OPTION) {
                break;
            }
        }
    }//GEN-LAST:event__OutputDirButtonActionPerformed

    class DownloadCatalogListener implements PropertyChangeListener {

        MainFrame _main;
        WorkerDownloadFromURL _worker;
        File _catalogFile;

        DownloadCatalogListener(MainFrame main, WorkerDownloadFromURL worker, File catalogFile) {

            _main = main;
            _worker = worker;
            _catalogFile = catalogFile;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                _main.doCatalogDownloadFinished(_worker, _catalogFile);
            }
        }
    }

    private void doCatalogDownloadStart() {
        URI url = null;
        try {
            url = new URI(_SourceURLTextField.getSelectedItem().toString());
        } catch (URISyntaxException e) {
            _logger.error("Catalog URL is not a valid URL", e);
            JOptionPane.showMessageDialog(this, "Catalog URL is not a valid URL", "Error", JOptionPane.ERROR_MESSAGE);
            doCatalogDownloadFinished(null, null);
            return;
        }
        Document doc = null;
        File tempfile = null;
        try {
            tempfile = File.createTempFile("fbirndownload.", ".xml");
            _catalogworker = new WorkerDownloadFromURL(url, tempfile, _credman);
            setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
            DownloadCatalogListener dclistener = new DownloadCatalogListener(this, _catalogworker, tempfile);
            _catalogworker.addPropertyChangeListener(dclistener);
            _catalogworker.execute();
        } catch (Exception e) {
            exceptionDialog(new Exception("Error downloading catalog document.", e));
            doCatalogDownloadFinished(_catalogworker, tempfile);
        }
    }

    private void doCatalogDownloadFinished(WorkerDownloadFromURL worker, File catalogFile) {
        setCursor(null);
        try {
            worker.get();
            if (worker != null) {
                _catalog = new DownloaderCatalog();
                try {
                    _catalog.parseCatalogFile(catalogFile);
                    _DownloadButton.setEnabled(true);
                } catch (Exception e) {
                    exceptionDialog(new Exception("Error parsing catalog document", e));
                }
            }
        } catch (InterruptedException e) {
            exceptionDialog(new Exception("Error downloading catalog document", e));
        } catch (ExecutionException e) {
            exceptionDialog(new Exception("Error downloading catalog document", e));
        }
        if (catalogFile != null) {
            catalogFile.delete();
        }
        doDataDownloadStart();
    }

    class DownloadListener implements PropertyChangeListener {

        MainFrame _main;
        WorkerDownloadFromCatalog _worker;

        DownloadListener(MainFrame main, WorkerDownloadFromCatalog worker) {
            _main = main;
            _worker = worker;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                _main.doDataDownloadFinished(_worker);
            }
        }
    }

    private void _DownloadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__DownloadButtonActionPerformed
        _DownloadButton.setEnabled(false);

        if ("Cancel download".equals(_DownloadButton.getText())) {
            if (_downloadworker != null) {
                _downloadworker.cancel(true);
            }
            doDataDownloadFinished(_downloadworker);
            return;
        }
        Component[] progpanelchildren = _DownloadProgressPanel.getComponents();
        for (int i = 0; i < progpanelchildren.length; i++) {
            _DownloadProgressPanel.remove(i);
        }
        _credman.resetCanceled();

        if (_DoCatalogCheckBox.isSelected()) {
            doCatalogDownloadStart();
        } else {
            _catalog = new DownloaderCatalog();
            URI url = null;
            try {
                url = new URI(_SourceURLTextField.getSelectedItem().toString());
            } catch (URISyntaxException e) {
                _logger.error("Source URL is not a valid URL", e);
                JOptionPane.showMessageDialog(this, "Source URL is not a valid URL", "Error", JOptionPane.ERROR_MESSAGE);
                doCatalogDownloadFinished(null, null);
                return;
            }
            DownloaderCatalogEntry entry = new DownloaderCatalogEntry();
            entry.setURI(url);
            if (_UpdateQuestionCheckBox.isSelected()) {
                entry.setTimeStampCheckDepth(Integer.MAX_VALUE);
            }
            _catalog.addEntry(entry);
            doDataDownloadStart();
        }
    }

    private void doDataDownloadStart() {
        if (_catalog == null) {
            doDataDownloadFinished(null);
            return;
        }
        File outputDirFile = new File(_OutputDirTextField.getSelectedItem().toString());
        if (!outputDirFile.exists()) {
            int option = JOptionPane.showOptionDialog(this, "Specified output directory '" + outputDirFile.getPath() + "' does not exist.  Do you wish to create this directory?", "Create directory?", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null, null, null);
            if (option == JOptionPane.NO_OPTION) {
                doDataDownloadFinished(null);
                return;
            }
            if (outputDirFile.mkdirs() != true) {
                JOptionPane.showMessageDialog(this, "Error creating output directory!", "Error", JOptionPane.ERROR_MESSAGE);
                doDataDownloadFinished(null);
                return;
            }
        } else if (!outputDirFile.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Specified output target exists but is not a directory!", "Error", JOptionPane.ERROR_MESSAGE);
            doDataDownloadFinished(null);
            return;
        }
        _catalog.setParentPanel(_DownloadProgressPanel);
        _downloadworker = new WorkerDownloadFromCatalog(_catalog, outputDirFile, null, _credman, (_UpdateQuestionCheckBox.getSelectedObjects() == null) ? false : true, (_DryRunCheckBox.getSelectedObjects() == null) ? false : true, null, 100);
        _DownloadProgressBar.setEnabled(true);
        _DownloadProgressBar.setString("Downloading...");
        _DownloadProgressBar.setStringPainted(true);
        _DownloadProgressBar.setIndeterminate(true);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        DownloadListener dlistener = new DownloadListener(this, _downloadworker);
        _downloadworker.addPropertyChangeListener(dlistener);
        ProgressBarListener pblistener = new ProgressBarListener(_DownloadProgressBar);
        _downloadworker.addPropertyChangeListener(pblistener);
        _downloadworker.execute();
        _DownloadButton.setText("Cancel download");
        _DownloadButton.setEnabled(true);
    }//GEN-LAST:event__DownloadButtonActionPerformed

    private void doDataDownloadFinished(WorkerDownloadFromCatalog worker) {
        _downloadworker = null;
        _DownloadProgressBar.setIndeterminate(false);
        _DownloadProgressBar.setString("");
        setCursor(null);
        boolean succeeded = false;
        try {
            if (worker != null && worker.get() == null) {
                succeeded = true;
            }
        } catch (Exception e) {
            // do nothing
        }
        if (succeeded) {
            _DownloadProgressBar.setString("Success!");
        } else {
            _DownloadProgressBar.setString("Error");
        }
        _DownloadButton.setText("Download");
        _DownloadButton.setEnabled(true);
        _DownloadProgressBar.setEnabled(false);
    }

    private void exceptionDialog(Throwable e) {
        _logger.error("Encountered an execption", e);
        ExceptionDialog.show(this, e);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel _CheckboxPanelSpacer;
    private javax.swing.JCheckBox _DoCatalogCheckBox;
    private javax.swing.JButton _DownloadButton;
    private javax.swing.JPanel _DownloadPanel;
    private javax.swing.JProgressBar _DownloadProgressBar;
    private javax.swing.JPanel _DownloadProgressPanel;
    private javax.swing.JPanel _DownloadSpacerPanel;
    private javax.swing.JCheckBox _DryRunCheckBox;
    private javax.swing.JButton _OutputDirButton;
    private javax.swing.JFileChooser _OutputDirFileChooser;
    private javax.swing.JLabel _OutputDirLabel;
    private javax.swing.JPanel _OutputDirPanel;
    private javax.swing.JComboBox _OutputDirTextField;
    private javax.swing.JPanel _SourcePanel;
    private javax.swing.JPanel _SourceSpacer;
    private javax.swing.JLabel _SourceURLLabel;
    private javax.swing.JComboBox _SourceURLTextField;
    private javax.swing.JPanel _TopPanel;
    private javax.swing.JScrollPane _TopScrollPane;
    private javax.swing.JCheckBox _UpdateQuestionCheckBox;
    private javax.swing.JPanel _UpdateQuestionPanel;
    // End of variables declaration//GEN-END:variables
}
