/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.MutableDateTime;
import org.springframework.util.AntPathMatcher;

/**
 *
 * @author gadde
 */
public class NoteSourceCIGAL extends NoteSource {

    AntPathMatcher _matcher = null;
    String _antglob = null;
    File _base = null;
    URI _baseURI = null;

    public NoteSourceCIGAL(String antglob) throws NoteException {
        this(antglob, new File("/"));
    }

    public NoteSourceCIGAL(String antglob, File base) throws NoteException {
        this(antglob, base, null);
    }

    public NoteSourceCIGAL(String antglob, File base, URI baseURI) throws NoteException {
        _matcher = new AntPathMatcher();
        _antglob = antglob;
        _base = base;
        if (baseURI == null) {
            _baseURI = baseURI;
        } else {
            try {
                _baseURI = new URI("file", InetAddress.getLocalHost().getHostName(), "/", null);
            } catch (URISyntaxException e) {
                throw new NoteException("Error creating URI", e);
            } catch (UnknownHostException e) {
                throw new NoteException("Error getting hostname", e);
            }
        }
    }

    private void addNotesFromFile(List<Note> noteList, File file) throws FileNotFoundException, NoteException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = null;
        try {
            StringBuilder value = new StringBuilder("");
            StringBuilder comment = new StringBuilder("");
            MutableDateTime modTime = new MutableDateTime();
            int noteNum = 0;
            boolean noteEmpty = true;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0) {
                    // do nothing
                } else if (Character.isWhitespace(line.charAt(0))) {
                    for (int i = 1; i < line.length(); i++) {
                        if (Character.isWhitespace(line.charAt(i))) {
                            continue;
                        }
                        final String commentHeader = "Comment: ";
                        if (line.startsWith(commentHeader, i)) {
                            comment.append(line.substring(i + commentHeader.length())).append("\n");
                            noteEmpty = false;
                        } else {
                            value.append(line).append("\n");
                        }
                        break;
                    }
                } else {
                    // new note
                    if (!noteEmpty) {
                        try {
                            noteList.add(new Note(new URI(null, null, file.getPath(), String.valueOf(noteNum)).toString(), "cigal", "note", value.toString(), comment.toString(), "_cigal_", modTime.toDateTime(), new URIWithType(URIWithType.TYPE_FILE, file.getPath())));
                        } catch (URISyntaxException e) {
                            throw new NoteException("Error creating URI", e);
                        }
                        value = new StringBuilder("");
                        comment = new StringBuilder("");
                        noteEmpty = true;
                    }
                    value.append(line).append("\n");
                    modTime = new MutableDateTime();
                    MutableDateTime newModTime = modTime;
                    int curind = 0;
                    int sepind = -1;
                    if ((sepind = line.indexOf('/', curind)) == -1) {
                        continue;
                    }
                    newModTime.setMonthOfYear(Integer.valueOf(line.substring(curind, sepind)));
                    curind = sepind + 1;
                    if ((sepind = line.indexOf('/', curind)) == -1) {
                        continue;
                    }
                    newModTime.setDayOfMonth(Integer.valueOf(line.substring(curind, sepind)));
                    curind = sepind + 1;
                    if ((sepind = line.indexOf(' ', curind)) == -1) {
                        continue;
                    }
                    newModTime.setYear(Integer.valueOf(line.substring(curind, sepind)));
                    curind = sepind + 1;
                    while (Character.isWhitespace(line.charAt(curind))) {
                        curind++;
                    }
                    if ((sepind = line.indexOf(':', curind)) == -1) {
                        continue;
                    }
                    newModTime.setHourOfDay(Integer.valueOf(line.substring(curind, sepind)));
                    curind = sepind + 1;
                    if ((sepind = line.indexOf(':', curind)) == -1) {
                        continue;
                    }
                    newModTime.setMinuteOfHour(Integer.valueOf(line.substring(curind, sepind)));
                    curind = sepind + 1;
                    if ((sepind = line.indexOf(' ', curind)) == -1) {
                        continue;
                    }
                    newModTime.setSecondOfMinute(Integer.valueOf(line.substring(curind, sepind)));
                    modTime = newModTime;
                }
            }
            if (!noteEmpty) {
                try {
                    noteList.add(new Note(_baseURI.resolve(new URI(null, null, file.getPath(), file.lastModified() + "-" + String.valueOf(noteNum))).toString(), "cigal", "note", value.toString(), comment.toString(), "_cigal_", modTime.toDateTime(), new URIWithType(URIWithType.TYPE_FILE, file.getPath())));
                } catch (URISyntaxException e) {
                    //shouldn't happen (!)
                }
            }
        } catch (IOException e) {
            throw new NoteException("Error reading CIGAL note file", e);
        }
    }

    @Override
    protected List<Note> getNoteListInternal() throws NoteException {
        setProgressStart("Finding and reading CIGAL files...");
        double progress = 0;
        NoteList noteList = new NoteList();
        Deque<String> relstack = new ArrayDeque<String>();
        Deque<File> absstack = new ArrayDeque<File>();
        Deque<Double> progressstack = new ArrayDeque<Double>();
        absstack.push(_base);
        relstack.push("");
        progressstack.push(1.0);
        while (!relstack.isEmpty()) {
            // precondition: stack entries are directories
            checkInterrupts();
            File absFile = absstack.removeFirst();
            String relFile = relstack.removeFirst();
            double progIncrement = progressstack.removeFirst();
            File[] childList = absFile.listFiles();
            int numChildren = childList.length;
            double childIncrement = progIncrement / (numChildren + 1);
            for (File file : childList) {
                if (file.isFile()) {
                    if (file.exists() && _matcher.match(_antglob, relFile + file.getName())) {
                        setProgress(progress, "Reading notes from " + relFile + file.getName());
                        try {
                            addNotesFromFile(noteList, file);
                        } catch (FileNotFoundException e) {
                            // shouldn't happen (!)
                        }
                    }
                    progress += childIncrement;
                } else if (file.isDirectory() && _matcher.matchStart(_antglob, relFile + file.getName() + "/")) {
                    setProgress(progress, null);
                    absstack.push(file);
                    relstack.push(relFile + file.getName() + "/");
                    progressstack.push(childIncrement);
                }
            }
            progress += childIncrement;
        }
        setProgress(1.0, null);
        setProgressFinish("Complete.");
        return noteList;
    }
}
