/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class NoteSourceFile extends NoteSource {

    private static final Logger _logger = Logger.getLogger(NoteSourceFile.class.getName());
    private File _file = null;
    private URI _baseURI = null;

    public NoteSourceFile(File file, URI baseURI) {
        _file = file;
        _baseURI = baseURI;
    }

    @Override
    protected List<Note> getNoteListInternal() throws NoteException {
        setProgressStart("Reading notes file...");
        List<Note> retval = new NoteList();
        FileInputStream fis = null;
        try {
            long fileLen = _file.length();
            fis = new FileInputStream(_file);
            Note.NoteIterator iter = Note.getIteratorFromReader(new InputStreamReader(fis, "UTF-8"), _baseURI);
            long numConsumedBytes = 0;
            while (iter.hasNext()) {
                retval.add(iter.next());
                setProgress(numConsumedBytes * 1.0 / fileLen, null);
                numConsumedBytes = fis.getChannel().position();
            }
        } catch (UnsupportedEncodingException e) {
            return null;
        } catch (IOException e) {
            throw new NoteException("Error reading notes", e);
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    // oh well
                }
            }
        }
        setProgress(1.0, null);
        setProgressFinish("Complete.");
        return retval;
    }
}
