/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.util.List;
import java.util.logging.Logger;
import org.joda.time.DateTime;

/**
 *
 * @author gadde
 */
public class NoteSourceHIDDesc extends NoteSource {

    private static final Logger _logger = Logger.getLogger(NoteSourceHIDDesc.class.getName());
    private ExperimentHierarchyModel _model = null;
    private String _ns = null;
    private HID _hid = null;
    private static final String _siteIDMarker = "__SITEID__=";
    private static final int _siteIDMarkerLen = _siteIDMarker.length();
    private static final String _expNotesSuffix = "-notes";
    private static final int _expNotesSuffixLen = _expNotesSuffix.length();

    /**
     * @param namespace namespace to be used for any returned {@link Note}s
     * @param hid {@link HID} object
     */
    public NoteSourceHIDDesc(ExperimentHierarchyModel model, String namespace, HID hid) {
        _model = model;
        _ns = namespace;
        _hid = hid;
    }

    /**
     * 
     * @return a list of notes from this HID.
     * @throws NoteException if any errors occur reading items from the database.
     */
    @Override
    protected NoteList getNoteListInternal() throws NoteException {
        setProgressStart("Starting read from " + _hid.getURL() + "...");
        List<ExperimentHierarchyItem> itemlist = _hid.getItems();
        NoteList retval = new NoteList();
        int numNotes = itemlist.size();
        for (int i = 0; i < numNotes; i++) {
            checkInterrupts();
            setProgress(i * 1.0 / numNotes, null);
            ExperimentHierarchyItem item = itemlist.get(i);
            String noteName = null;
            StringBuilder noteComment = null;
            DateTime noteModTime = null;
            if (item.seriesDesc != null) {
                noteComment = new StringBuilder(item.seriesDesc);
                noteName = "seriesDesc";
                noteModTime = item.seriesModTime;
            } else if (item.studyDesc != null) {
                noteComment = new StringBuilder(item.studyDesc);
                noteName = "studyDesc";
                noteModTime = item.studyModTime;
            } else if (item.visitDesc != null) {
                noteComment = new StringBuilder(item.visitDesc);
                noteName = "visitDesc";
                noteModTime = item.visitModTime;
            } else {
                continue;
            }
            if (item.expName.endsWith(_expNotesSuffix)) {
                item.expName = item.expName.substring(0, item.expName.length() - _expNotesSuffixLen);
            }
            int noteNum = 0;
            if (noteComment == null || noteComment.length() == 0) {
                URIWithType path = _model.itemToPath(item);
                if (path != null) {
                    retval.add(new Note(item.ID + "#" + noteNum, null, null, null, null, null, noteModTime, path));
                }
            }
            while (noteComment != null && noteComment.length() != 0) {
                Note note = null;
                URIWithType path = _model.itemToPath(item);
                if (noteComment.length() >= _siteIDMarkerLen && noteComment.substring(0, _siteIDMarkerLen).equals(_siteIDMarker)) {
                    int nlind = noteComment.indexOf("\n", _siteIDMarker.length());
                    if (nlind != -1) {
                        item.visitSiteID = Integer.valueOf(noteComment.substring(_siteIDMarker.length(), nlind));
                        noteComment.delete(0, nlind + 1);
                    }
                    note = Note.consumeFromString(noteComment, path.getURI());
                }
                if (note == null) {
                    if (path == null) {
                        noteComment = null;
                        continue;
                    }
                    note = new Note(item.ID + "#" + noteNum, _ns, noteName, null, noteComment.toString(), "_HID_", noteModTime, path);
                    noteNum++;
                    noteComment = null;
                } else {
                    if (note.getPaths().isEmpty()) {
                        if (path == null) {
                            continue;
                        }
                        note.addPath(path);
                    }
                    if (note.getNamespace() == null) {
                        note.setNamespace(_ns);
                    }
                    if (note.getName() == null) {
                        note.setName(noteName);
                    }
                    if (note.getAuthor() == null) {
                        note.setAuthor("_HID_");
                    }
                    if (note.getTimeStamp() == null) {
                        note.setTimeStamp(noteModTime);
                    }
                }
                /*
                if (item.seriesDesc != null && !item.seriesDesc.isEmpty()) {
                item.seriesDesc = note.getComment();
                } else if (item.studyDesc != null && !item.studyDesc.isEmpty()) {
                item.studyDesc = note.getComment();
                } else if (item.visitDesc != null && !item.visitDesc.isEmpty()) {
                item.visitDesc = note.getComment();
                }
                 */
                retval.add(note);
            }
        }
        setProgressFinish("Finished read from " + _hid.getURL() + ".");
        return retval;
    }
}
