/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class NoteSourceHIDExtendedTuple extends NoteSource {

    private static final Logger _logger = Logger.getLogger(NoteSourceHIDExtendedTuple.class.getName());
    private String _ns = null;
    private HID _hid = null;
    private ExperimentHierarchyModel _model = null;
    private static final String _siteIDMarker = "__SITEID__=";
    private static final int _siteIDMarkerLen = _siteIDMarker.length();
    private static final String _expNotesSuffix = "-notes";
    private static final int _expNotesSuffixLen = _expNotesSuffix.length();

    /**
     * @param namespace namespace to be used for any returned {@link Note}s
     * @param hid {@link HID} object
     */
    public NoteSourceHIDExtendedTuple(ExperimentHierarchyModel model, String namespace, HID hid) {
        _ns = namespace;
        _hid = hid;
        _model = model;
    }

    /**
     * 
     * @return a list of notes from this HID.
     * @throws NoteException if any errors occur reading items from the database.
     */
    @Override
    protected List<Note> getNoteListInternal() throws NoteException {
        Connection conn = _hid.connect();
        try {
            List<Note> noteList = _model.getNotes(_hid.getDBID(), conn, this);
            return noteList;
        } finally {
            try {
                conn.close();
            } catch (SQLException e) {
                // ignore
            }
        }
    }
}
