/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class NoteTargetFileHierarchy extends NoteTarget {

    private static final Logger _logger = Logger.getLogger(NoteTargetFileHierarchy.class.getName());
    String _noteFileName = "NOTES";
    File _outputRoot = null;

    public NoteTargetFileHierarchy(ExperimentHierarchyModel model, File outputRoot) {
        this(model, outputRoot, null);
    }

    public NoteTargetFileHierarchy(ExperimentHierarchyModel model, File outputRoot, String noteFileName) {
        super(model);
        _outputRoot = outputRoot;
        if (noteFileName != null) {
            _noteFileName = noteFileName;
        }
    }

    @Override
    public void putNoteListInternal(List<? extends Note> noteList) throws NoteException {
        HashMap<File, NoteList> map = new HashMap<File, NoteList>();
        for (Note note : noteList) {
            for (URIWithType path : note.getPaths()) {
                int type = path.getType();
                URI uri = path.getURI();
                if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
                    // skip
                    continue;
                }
                File dirPath = new File(uri.getPath());
                if (dirPath.isAbsolute()) {
                    File prefixFile = dirPath;
                    File curFile = prefixFile;
                    while (curFile != null) {
                        prefixFile = curFile;
                        curFile = curFile.getParentFile();
                    }
                    String dirPathStr = dirPath.getPath();
                    String prefixPathStr = prefixFile.getPath();
                    if (dirPathStr.startsWith(prefixPathStr)) {
                        dirPathStr = dirPathStr.substring(prefixPathStr.length());
                        dirPath = new File(_outputRoot, dirPathStr);
                    }
                }
                Note newNote = note.clone();
                newNote.getPaths().clear();
                if (type == URIWithType.TYPE_FILE) {
                    try {
                        newNote.addPath(new URIWithType(URIWithType.TYPE_FILE, dirPath.getName()));
                    } catch (URISyntaxException e) {
                        _logger.log(Level.SEVERE, "Error parsing path '" + dirPath.getName() + "' as URI", e);
                        continue;
                    }
                    dirPath = dirPath.getParentFile();
                }
                NoteList perFileNoteList = null;
                if (map.containsKey(dirPath)) {
                    perFileNoteList = map.get(dirPath);
                } else {
                    perFileNoteList = new NoteList();
                    map.put(dirPath, perFileNoteList);
                }
                perFileNoteList.add(newNote);
            }
        }
        for (File dirPath : map.keySet()) {
            NoteList perFileNoteList = map.get(dirPath);
            if (dirPath.exists()) {
                if (!dirPath.isDirectory()) {
                    throw new NoteException("ERROR: The following path is not a directory: " + dirPath.toString());
                }
            } else {
                if (!dirPath.mkdirs()) {
                    throw new NoteException("Error creating the directory: " + dirPath.toString());
                }
            }
            NoteTargetFile target = new NoteTargetFile(getModel(), new File(dirPath, _noteFileName));
            target.putNoteList(perFileNoteList);
        }
    }
}
