/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

/**
 * An extension of {@link File} to add explicit file type (file or directory)
 * @author gadde
 */
public class URIWithType implements Comparable<URIWithType> {

    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_DIR = 1;
    public static final int TYPE_FILE = 2;
    private int _type = TYPE_UNKNOWN;
    private URI _uri = null;

    public URIWithType(int type, String uristr) throws URISyntaxException {
        this(type, (String) null, uristr);
    }

    public URIWithType(int type, String parenturistr, String childuristr) throws URISyntaxException {
        if (parenturistr != null) {
            _uri = (new URI(parenturistr)).resolve(childuristr);
        } else {
            _uri = new URI(childuristr);
        }
        _type = type;
    }

    public URIWithType(int type, URI uri) {
        this(type, null, uri);
    }

    public URIWithType(int type, URI baseuri, URI childuri) {
        if (baseuri != null) {
            _uri = baseuri.resolve(childuri);
        } else {
            _uri = childuri;
        }
        _type = type;
    }

    public URIWithType(int type, URI baseuri, String childuristr) throws URISyntaxException {
        this(type, baseuri, new URI(childuristr));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final URIWithType other = (URIWithType) obj;
        if (this._type != other._type) {
            return false;
        }
        if (this._uri != other._uri && (this._uri == null || !this._uri.equals(other._uri))) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this._type;
        hash = 47 * hash + (this._uri != null ? this._uri.hashCode() : 0);
        return hash;
    }

    public int getType() {
        return _type;
    }

    public void setType(int type) {
        _type = type;
    }

    public URI getURI() {
        return _uri;
    }

    public void setURI(URI uri) {
        _uri = uri;
    }

    @Override
    public String toString() {
        String typestr = "?:";
        if (_type == TYPE_FILE) {
            typestr = "file:";
        } else if (_type == TYPE_DIR) {
            typestr = "dir:";
        }
        return typestr + " " + _uri.toString();
    }

    public int compareTo(URIWithType comp) {
        if (_type < comp._type) {
            return -1;
        } else if (_type > comp._type) {
            return 1;
        }
        return _uri.compareTo(comp._uri);
    }
}
