/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author gadde
 */
public class NotePrivilegesTest {

    NotePrivileges _np = null;

    public NotePrivilegesTest() {
    }

    @Before
    public void setUp() {
	_np = new NotePrivileges();
	_np.addPrivilege("ns1", "name1", "user1", NotePrivileges.PRIV_ALLOW_MANY);
	_np.addPrivilege("ns1", null, null, NotePrivileges.PRIV_REJECT);
	_np.addPrivilege("ns2", "name2", "user1", NotePrivileges.PRIV_REJECT);
	_np.addPrivilege("ns1", "name1", "user2", NotePrivileges.PRIV_ALLOW_MANY);
	_np.addPrivilege("ns1", "name1", "user1", NotePrivileges.PRIV_ALLOW_ONE);
	_np.addPrivilege("ns2", "name1", "user2", NotePrivileges.PRIV_ALLOW_ONE);
	_np.addPrivilege("nämespace_umlaut", "näme_umlaut", "üser_umlaut", NotePrivileges.PRIV_ALLOW_MANY);
    }

    @After
    public void tearDown() {
	_np = null;
    }

    /**
     * Test of getPrivilege method, of class NotePrivileges.
     */
    @Test
    public void testGetPrivilege() {
	System.out.println("getPrivilege");
	{
	    NotePrivileges instance = _np;
	    int expResult = NotePrivileges.PRIV_ALLOW_MANY;
	    int result = instance.getPrivilege("ns1", "name1", "user1");
	    assertEquals(expResult, result);
	}
	{
	    NotePrivileges instance = _np;
	    int expResult = NotePrivileges.PRIV_REJECT;
	    int result = instance.getPrivilege("ns2", "name2", "user1");
	    assertEquals(expResult, result);
	}
	{
	    NotePrivileges instance = _np;
	    int expResult = NotePrivileges.PRIV_REJECT;
	    int result = instance.getPrivilege("ns1", "name1", "user2");
	    assertEquals(expResult, result);
	}
	{
	    NotePrivileges instance = _np;
	    int expResult = NotePrivileges.PRIV_REJECT;
	    int result = instance.getPrivilege("ns1", "dummyname", "dummyuser");
	    assertEquals(expResult, result);
	}
	{
	    NotePrivileges instance = _np;
	    int expResult = NotePrivileges.PRIV_ALLOW_ONE;
	    int result = instance.getPrivilege("ns2", "name1", "user2");
	    assertEquals(expResult, result);
	}
	{
	    NotePrivileges instance = _np;
	    int expResult = NotePrivileges.PRIV_ALLOW_MANY;
	    int result = instance.getPrivilege("nämespace_umlaut", "näme_umlaut", "üser_umlaut");
	    assertEquals(expResult, result);
	}

    }

    /**
     * Test of read method, of class NotePrivileges.
     */
    @Test
    public void testRead_File() throws Exception {
	System.out.println("read");
	File file = new File(this.getClass().getResource("testPrivs.txt").toURI());
	NotePrivileges expResult = _np;
	NotePrivileges result = NotePrivileges.read(file);
	assertEquals(expResult, result);
    }

    /**
     * Test of write method, of class NotePrivileges.
     */
    @Test
    public void testWrite_File() throws Exception {
	System.out.println("write");
	File tempfile = File.createTempFile("__noteprivtest.", null);
	NotePrivileges instance = _np;
	instance.write(tempfile);
	FileReader tempfr = new FileReader(tempfile);
	BufferedReader tempbr = new BufferedReader(tempfr);
	FileReader expfr = new FileReader(new File(this.getClass().getResource("testPrivs.txt").toURI()));
	BufferedReader expbr = new BufferedReader(expfr);
	while (true) {
	    String expline = expbr.readLine();
	    while (expline != null && expline.startsWith("#")) {
		expline = expbr.readLine();
	    }
	    String templine = tempbr.readLine();
	    while (templine != null && templine.startsWith("#")) {
		templine = tempbr.readLine();
	    }
	    if (expline == null && templine == null) {
		break;
	    }
	    if (expline == null || templine == null) {
		fail("privileges files differ (one file has fewer lines than the other)");
	    }
	    if (!expline.equals(templine)) {
		fail("privileges files differ at lines:\n(expected) " + expline + "\n(written)  " + templine);
	    }
	}
    }
}
