/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.util.List;
import java.net.URI;
import java.net.URISyntaxException;
import org.joda.time.DateTimeZone;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author gadde
 */
public class NoteTest {

    private Note _testFieldNote0 = null;
    private Note _testFieldNote1 = null;
    private Note _testFieldNote1wf = null;
    private Note _testFieldNote2 = null;

    public NoteTest() {
    }

    @Before
    public void setUp() throws URISyntaxException {
        DateTime dt = new DateTime(2011, 1, 31, 8, 30, 45, 100, DateTimeZone.forID("America/New_York"));
        _testFieldNote0 = new Note("testFieldNote0", "testns", "testname", "testvalue", "testcomment", "testauthor", dt, new URIWithType(URIWithType.TYPE_FILE, "/my/tmp/file"));
        _testFieldNote1 = new Note("testFieldNote1", "test|ns", "testna|#me", "test|val\\ue", "testcomment", "testauthor", dt, new URIWithType(URIWithType.TYPE_FILE, "/my/tmp/file"));
        _testFieldNote1wf = new Note("testFieldNote1", "test|ns", "testna|#me", "test|val\\ue", "testcomment", "testauthor", dt, (URIWithType) null);
        ArrayList<URIWithType> filearray = new ArrayList<URIWithType>();
        filearray.add(new URIWithType(URIWithType.TYPE_DIR, "/my/tmp/dir"));
        filearray.add(new URIWithType(URIWithType.TYPE_FILE, "/my/tmp/file"));
        _testFieldNote2 = new Note("testFieldNote2", "test|ns", "testna|#me", "test|val\\ue", "testcomment", "testauthor", dt, filearray);
    }

    @After
    public void tearDown() {
        _testFieldNote0 = null;
        _testFieldNote1 = null;
        _testFieldNote1wf = null;
        _testFieldNote2 = null;
    }

    /**
     * Test of clone method, of class Note.
     */
    @Test
    public void testClone() {
        System.out.println("clone");
        Note instance = _testFieldNote1;
        Note expResult = _testFieldNote1;
        Note result = instance.clone();
        assertEquals(expResult, result);
    }

    /**
     * Test of cloneWithoutFiles method, of class Note.
     */
    @Test
    public void testCloneWithoutFiles() {
        System.out.println("cloneWithoutFiles");
        Note instance = _testFieldNote1;
        Note expResult = _testFieldNote1wf;
        Note result = instance.cloneWithoutFiles();
        assertEquals(expResult, result);
    }

    /**
     * Test of getNamespace method, of class Note.
     */
    @Test
    public void testGetNamespace() {
        System.out.println("getNamespace");
        Note instance = _testFieldNote1;
        String expResult = "test|ns";
        String result = instance.getNamespace();
        assertEquals(expResult, result);
    }

    /**
     * Test of getName method, of class Note.
     */
    @Test
    public void testGetName() {
        System.out.println("getName");
        Note instance = _testFieldNote1;
        String expResult = "testna|#me";
        String result = instance.getName();
        assertEquals(expResult, result);
    }

    /**
     * Test of getValue method, of class Note.
     */
    @Test
    public void testGetValue() {
        System.out.println("getValue");
        Note instance = _testFieldNote1;
        String expResult = "test|val\\ue";
        String result = instance.getValue();
        assertEquals(expResult, result);
    }

    /**
     * Test of getAuthor method, of class Note.
     */
    @Test
    public void testGetAuthor() {
        System.out.println("getAuthor");
        Note instance = _testFieldNote1;
        String expResult = "testauthor";
        String result = instance.getAuthor();
        assertEquals(expResult, result);
    }

    /**
     * Test of getTimeStamp method, of class Note.
     */
    @Test
    public void testGetTimeStamp() {
        System.out.println("getTimeStamp");
        Note instance = _testFieldNote1;
        DateTime expResult = new DateTime(2011, 1, 31, 8, 30, 45, 100);
        DateTime result = instance.getTimeStamp();
        assertEquals(expResult, result);
    }

    /**
     * Test of getPaths method, of class Note.
     */
    @Test
    public void testGetPaths() throws URISyntaxException {
        System.out.println("getPaths");
        {
            Note instance = _testFieldNote1;
            List<URIWithType> expResult = new ArrayList<URIWithType>();
            expResult.add(new URIWithType(URIWithType.TYPE_FILE, "/my/tmp/file"));
            List<URIWithType> result = instance.getPaths();
            assertEquals(expResult, result);
        }
        {
            Note instance = _testFieldNote1wf;
            List<URIWithType> expResult = new ArrayList<URIWithType>();
            List<URIWithType> result = instance.getPaths();
            assertEquals(expResult, result);
        }
        {
            Note instance = _testFieldNote2;
            List<URIWithType> expResult = new ArrayList<URIWithType>();
            expResult.add(new URIWithType(URIWithType.TYPE_DIR, "/my/tmp/dir"));
            expResult.add(new URIWithType(URIWithType.TYPE_FILE, "/my/tmp/file"));
            List<URIWithType> result = instance.getPaths();
            assertEquals(expResult, result);
        }
    }

    /**
     * Test of consumeFromString method, of class Note.
     */
    @Test
    public void testConsumeFromString() throws URISyntaxException {
        // "test:ns", "testna:|me", "test|val\\ue", "testauthor", new DateTime(2011, 1, 31, 8, 30, 45, 100), new URIWithType(URIWithType.TYPE_FILE, "/my/tmp/file")
        // "NOTE: " + esc_timeStamp + "|" + esc_ns + ":" + esc_name + "|" + esc_author + "|" + esc_value;
        System.out.println("consumeFromString");
        StringBuilder input = new StringBuilder(
                ""
                /* _testFieldNote0 */
                + "NOTE: testFieldNote0|2011-01-31T08:30:45.100-05:00|testns|testname|testauthor|testvalue|testcomment|\n"
                + "F /my/tmp/file\n"
                + "||\n"
                /* _testFieldNote1 */
                + "NOTE: testFieldNote1|2011-01-31T08:30:45.100-05:00|test%7cns|testna%7c#me|testauthor|test%7cval\\ue|testcomment|\n"
                + "F /my/tmp/file\n"
                + "||\n"
                /* _testFieldNote1wf */
                + "NOTE: testFieldNote1|2011-01-31T08:30:45.100-05:00|test%7cns|testna%7c#me|testauthor|test%7cval\\ue|testcomment||\n"
                /* _testFieldNote2 (note no newline at end of note) */
                + "NOTE: testFieldNote2|2011-01-31T08:30:45.100-05:00|test%7cns|testna%7c#me|testauthor|test%7cval\\ue|testcomment|\n"
                + "D /my/tmp/dir\n"
                + "F /my/tmp/file\n"
                + "||"
                /* _testFieldNote2 (with relative paths, no newline at end of note) */
                + "NOTE: testFieldNote2|2011-01-31T08:30:45.100-05:00|test%7cns|testna%7c#me|testauthor|test%7cval\\ue|testcomment|\n"
                + "D dir\n"
                + "F file\n"
                + "||"
                + "GARBAGE AT END OF STRING");
        URI basePath = new URI("/my/tmp/");
        {
            Note expResult = _testFieldNote0;
            Note result = Note.consumeFromString(input, basePath);
            assertEquals(expResult, result);
        }
        {
            Note expResult = _testFieldNote1;
            Note result = Note.consumeFromString(input, basePath);
            assertEquals(expResult, result);
        }
        {
            Note expResult = _testFieldNote1wf;
            Note result = Note.consumeFromString(input, null);
            assertEquals(expResult, result);
        }
        {
            Note expResult = _testFieldNote2;
            Note result = Note.consumeFromString(input, basePath);
            assertEquals(expResult, result);
        }
        {
            Note expResult = _testFieldNote2;
            Note result = Note.consumeFromString(input, basePath);
            assertEquals(expResult, result);
        }
        assertEquals("GARBAGE AT END OF STRING", input.toString());
    }

    /**
     * Test of exportToString method, of class Note.
     */
    @Test
    public void testExportToString() {
        System.out.println("exportToString");
        String expResult =
                ""
                /* _testFieldNote0 */
                + "NOTE: testFieldNote0|2011-01-31T08:30:45.100-05:00|testns|testname|testauthor|testvalue|testcomment|\n"
                + "F /my/tmp/file\n"
                + "||\n"
                /* _testFieldNote1 */
                + "NOTE: testFieldNote1|2011-01-31T08:30:45.100-05:00|test%7cns|testna%7c#me|testauthor|test%7cval\\ue|testcomment|\n"
                + "F /my/tmp/file\n"
                + "||\n"
                /* _testFieldNote1wf */
                + "NOTE: testFieldNote1|2011-01-31T08:30:45.100-05:00|test%7cns|testna%7c#me|testauthor|test%7cval\\ue|testcomment||\n"
                /* _testFieldNote2 */
                + "NOTE: testFieldNote2|2011-01-31T08:30:45.100-05:00|test%7cns|testna%7c#me|testauthor|test%7cval\\ue|testcomment|\n"
                + "D /my/tmp/dir\n"
                + "F /my/tmp/file\n"
                + "||\n";
        String result = _testFieldNote0.exportToString() + _testFieldNote1.exportToString() + _testFieldNote1wf.exportToString() + _testFieldNote2.exportToString();
        assertEquals(expResult, result);
    }
}
