package org.nbirn.fbirn.utilities;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;

public class AppPropertyChangerCombo implements ActionListener, FocusListener {
    JComboBox _combobox = null;
    String _propname = null;
    PropertySetManager _propset = null;

    public AppPropertyChangerCombo(PropertySetManager propset, String propname, JComboBox combobox) {
	_propset = propset;
	_propname = propname;
	_combobox = combobox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
	Object selected = _combobox.getSelectedItem();
	if (selected != null) {
	    _propset.changeProperty(_propname, selected.toString());
	}
        if (_combobox instanceof SteppedComboBox) {
            SteppedComboBox scb = (SteppedComboBox) _combobox;
            scb.setPreferredSize(null);
            Dimension d = scb.getPreferredSize();
            scb.setPreferredSize(new Dimension(200, d.height));
            scb.setPopupWidth(d.width);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        // do nothing
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object selected = _combobox.getSelectedItem();
        if (selected != null) {
            _propset.changeProperty(_propname, selected.toString());
        }
    }
}
