/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentEvent.ElementChange;
import javax.swing.event.DocumentEvent.EventType;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

/**
 *
 * @author gadde
 */
public class AppendOnlyStyledDocument implements StyledDocument {

    private final static int FRAGMENTSIZE = 8192;
    private final static AttributeSet NULLATTRS = new SimpleAttributeSet();
    private AbstractDocument.Content _content;
    private StyleContext _styles;
    private RootElement _rootElement;
    private List<DocumentListener> _listeners;

    public AppendOnlyStyledDocument(AbstractDocument.Content content) {
        _content = content;
        _styles = new StyleContext();
        _rootElement = new RootElement();
        _listeners = new ArrayList<DocumentListener>();
    }

    public Style addStyle(String nm, Style parent) {
        return _styles.addStyle(nm, parent);
    }

    public void removeStyle(String nm) {
        _styles.removeStyle(nm);
    }

    public Style getStyle(String nm) {
        return _styles.getStyle(nm);
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        return;
    }

    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        return;
    }

    public void setLogicalStyle(int pos, Style s) {
        return;
    }

    public Style getLogicalStyle(int p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Element getParagraphElement(int pos) {
        return getCharacterElement(pos);
    }

    public Element getCharacterElement(int pos) {
        int ind = _rootElement.getElementIndex(pos);
        if (ind != -1) {
            return _rootElement.getElement(ind);
        }
        return null;
    }

    public Color getForeground(AttributeSet attr) {
        return Color.BLACK;
    }

    public Color getBackground(AttributeSet attr) {
        return Color.WHITE;
    }

    public Font getFont(AttributeSet attr) {
        return _styles.getFont(attr);
    }

    public int getLength() {
        return _content.length() - 1;
    }

    public void addDocumentListener(DocumentListener listener) {
        _listeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        _listeners.remove(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        return;
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        return;
    }

    public Object getProperty(Object key) {
        return null;
    }

    public void putProperty(Object key, Object value) {
        return;
    }

    public void remove(int offs, int len) throws BadLocationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        _content.insertString(offset, str);
        int strlen = str.length();
        _rootElement.insert(offset, strlen);
    }

    public String getText(int offset, int length) throws BadLocationException {
        return _content.getString(offset, length);
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        _content.getChars(offset, length, txt);
    }

    public Position getStartPosition() {
        try {
            return _content.createPosition(0);
        } catch (BadLocationException ex) {
            Logger.getLogger(AppendOnlyStyledDocument.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Position getEndPosition() {
        try {
            return _content.createPosition(_content.length());
        } catch (BadLocationException ex) {
            Logger.getLogger(AppendOnlyStyledDocument.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Position createPosition(int offs) throws BadLocationException {
        return _content.createPosition(offs);
    }

    public Element[] getRootElements() {
        return new Element[]{
                    getDefaultRootElement()
                };
    }

    public Element getDefaultRootElement() {
        return _rootElement;
    }

    public void render(Runnable r) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void notifyListeners(DocumentEvent e) {
        for (DocumentListener listener : _listeners) {
            DocumentEvent.EventType type = e.getType();
            if (type == DocumentEvent.EventType.CHANGE) {
                listener.changedUpdate(e);
            } else if (type == DocumentEvent.EventType.INSERT) {
                listener.insertUpdate(e);
            } else if (type == DocumentEvent.EventType.REMOVE) {
                listener.removeUpdate(e);
            }
        }
    }

    private class RootElement implements Element {

        private List<FragmentElement> _children;

        public RootElement() {
            _children = new ArrayList<FragmentElement>();
            _children.add(new FragmentElement(this, 0, 1));
        }

        public void insert(int offset, int strlen) {
            int childcount = getElementCount();
            int childind = getElementIndex(offset);
            FragmentElement child = _children.get(childind);
            int elemStart = child.getStartOffset();
            int elemEnd = child.getEndOffset();
            if (elemEnd + 1 - elemStart + strlen <= FRAGMENTSIZE) {
                // just add to current element
                child.setEndOffset(elemEnd + strlen);
                notifyListeners(new MyDocumentEvent(offset, strlen, DocumentEvent.EventType.INSERT, null));
                childind++;
            } else {
                int newstrlen = strlen;
                if (elemStart != offset) {
                    // split the fragment
                    // "remove" the content from the end of this fragment (we will "insert" it back)
                    child.setEndOffset(offset - 1);
                    notifyListeners(new MyDocumentEvent(offset, elemEnd + 1 - offset, DocumentEvent.EventType.REMOVE, null));
                    newstrlen += elemEnd + 1 - offset;
                    childind++;
                    elemStart = offset;
                }
                int insertStart = elemStart;
                int insertLen = newstrlen;
                final int insertInd = childind;
                final Element[] inserted = new Element[(newstrlen + FRAGMENTSIZE - 1) / FRAGMENTSIZE];
                int curind = 0;
                while (newstrlen > 0) {
                    int fragsize = FRAGMENTSIZE;
                    if (newstrlen < fragsize) {
                        fragsize = newstrlen;
                    }
                    FragmentElement newelem = new FragmentElement(this, elemStart, elemStart + fragsize);
                    _children.add(childind, newelem);
                    childind++;
                    inserted[curind] = newelem;
                    curind++;
                    elemStart += fragsize;
                }
                Map<Element, ElementChange> changes = new HashMap<Element, ElementChange>();
                changes.put(this, new ElementChange() {

                    public Element getElement() {
                        return RootElement.this;
                    }

                    public int getIndex() {
                        return insertInd;
                    }

                    public Element[] getChildrenRemoved() {
                        return null;
                    }

                    public Element[] getChildrenAdded() {
                        return inserted;
                    }
                });
                notifyListeners(new MyDocumentEvent(insertStart, insertStart + insertLen - 1, DocumentEvent.EventType.CHANGE, changes));
            }
            // now every child starting from childind has out-of-date offsets
            while (childind < childcount) {
                FragmentElement curchild = _children.get(childind);
                curchild.setStartOffset(curchild.getStartOffset() + strlen);
                curchild.setEndOffset(curchild.getEndOffset() + strlen);
                childind++;
            }

        }

        public Document getDocument() {
            return AppendOnlyStyledDocument.this;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "root";
        }

        public AttributeSet getAttributes() {
            return NULLATTRS;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return _children.get(_children.size() - 1).getEndOffset();
        }

        public int getElementIndex(int offset) {
            int n = _children.size();
            for (int i = 0; i < n; i++) {
                Element child = _children.get(i);
                if (offset >= child.getStartOffset() && offset <= child.getEndOffset()) {
                    return i;
                }
            }
            return -1;
        }

        public int getElementCount() {
            return _children.size();
        }

        public Element getElement(int index) {
            return _children.get(index);
        }

        public boolean isLeaf() {
            return false;
        }

        private class MyDocumentEvent implements DocumentEvent {

            private final int _offset;
            private final int _length;
            private final DocumentEvent.EventType _type;
            private final Map<Element, ElementChange> _changes;

            public MyDocumentEvent(int offset, int length, DocumentEvent.EventType type, Map<Element, ElementChange> changes) {
                _offset = offset;
                _length = length;
                _type = type;
                _changes = changes;
            }

            public int getOffset() {
                return _offset;
            }

            public int getLength() {
                return _length;
            }

            public Document getDocument() {
                return AppendOnlyStyledDocument.this;
            }

            public EventType getType() {
                return _type;
            }

            public ElementChange getChange(Element elem) {
                if (_changes.containsKey(elem)) {
                    return _changes.get(elem);
                }
                return null;
            }
        }
    }

    private class FragmentElement implements Element {

        private RootElement _root;
        private int _startOffset;
        private int _endOffset;

        public FragmentElement(RootElement root, int startOffset, int endOffset) {
            _root = root;
            _startOffset = startOffset;
            _endOffset = endOffset;
        }

        public void setStartOffset(int startOffset) {
            _startOffset = startOffset;
        }

        public void setEndOffset(int endOffset) {
            _endOffset = endOffset;
        }

        public Document getDocument() {
            return AppendOnlyStyledDocument.this;
        }

        public Element getParentElement() {
            return _root;
        }

        public String getName() {
            return "fragment";
        }

        public AttributeSet getAttributes() {
            return NULLATTRS;
        }

        public int getStartOffset() {
            return _startOffset;
        }

        public int getEndOffset() {
            return _endOffset;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public int getElementCount() {
            return 0;
        }

        public Element getElement(int index) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }
}
