/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class LogStatement implements Statement {

    private Statement _stmt;
    private String _ID;
    private Logger _logger;
    private List<String> _batches = new ArrayList<String>();

    public LogStatement(Statement stmt, String ID, Logger logger) {
        _stmt = stmt;
        _ID = ID;
        _logger = logger;
    }

    private void logStatement(String methodName, String sql) {
        _logger.log(Level.FINE, "[{0}] {1}: {2}", new Object[]{_ID, methodName, sql});
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        logStatement("executeQuery", sql);
        return _stmt.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        logStatement("executeUpdate", sql);
        return _stmt.executeUpdate(sql);
    }

    public void close() throws SQLException {
        _stmt.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return _stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        _stmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return _stmt.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        _stmt.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        _stmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return _stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        _stmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        _stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return _stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        _stmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        _stmt.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        logStatement("execute", sql);
        return _stmt.execute(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        return _stmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return _stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return _stmt.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        _stmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return _stmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        _stmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return _stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return _stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return _stmt.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        _batches.add(sql);
        _stmt.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        _batches.clear();
        _stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        for (String sql : _batches) {
            logStatement("execute", sql);
        }
        return _stmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return _stmt.getConnection();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return _stmt.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return _stmt.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logStatement("executeUpdate", sql);
        return _stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logStatement("executeUpdate", sql);
        return _stmt.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        logStatement("executeUpdate", sql);
        return _stmt.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        logStatement("execute", sql);
        return _stmt.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        logStatement("execute", sql);
        return _stmt.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        logStatement("execute", sql);
        return _stmt.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        return _stmt.getResultSetHoldability();
    }

    public boolean isClosed() throws SQLException {
        return _stmt.isClosed();
    }

    public void setPoolable(boolean poolable) throws SQLException {
        _stmt.setPoolable(poolable);
    }

    public boolean isPoolable() throws SQLException {
        return _stmt.isPoolable();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return _stmt.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return _stmt.isWrapperFor(iface);
    }
}
