/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.explorer;

import org.nbirn.fbirn.notecollector.nodes.NoteTreePanel;
import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.swing.event.ChangeEvent;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.nbirn.fbirn.notecollector.gui.shared.GlobalContainer;
import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import org.nbirn.fbirn.notecollector.nodes.hierarchy.HierarchyLevelNode;
import org.nbirn.fbirn.notecollector.nodes.hierarchy.HierarchyNoteLevel;
import org.nbirn.fbirn.notecollector.nodes.LevelNode;
import org.nbirn.fbirn.notecollector.nodes.NodeByTypeStickyLookup;
import org.nbirn.fbirn.notecollector.nodes.NoteCollectorNode;
import org.nbirn.fbirn.notecollector.nodes.lists.NoteCollectorNodeList;
import org.nbirn.fbirn.notecollector.nodes.NoteLevel;
import org.nbirn.fbirn.notecollector.nodes.NoteNode;
import org.nbirn.fbirn.notecollector.nodes.hierarchy.HierarchyNodeFactories;
import org.nbirn.fbirn.notecollector.nodes.lists.ForceSelectionNodeList;
import org.nbirn.fbirn.notecollector.nodes.namebased.NameBasedNodeFactories;
import org.nbirn.fbirn.notes.ExperimentHierarchyItem;
import org.nbirn.fbirn.notes.ExperimentHierarchyModel;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
//import org.openide.util.ImageUtilities;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.ServiceProvider;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(dtd = "-//org.nbirn.fbirn.notecollector.gui.explorer//NoteExplorer//EN",
autostore = false)
@ServiceProvider(service = NoteExplorerTopComponent.class)
public final class NoteExplorerTopComponent extends TopComponent implements LookupListener {

    private static NoteExplorerTopComponent instance;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    private static final String PREFERRED_ID = "NoteExplorerTopComponent";
    private GlobalContainer _gcont = null;
    private ExperimentHierarchyModel _model = null;
    private Lookup.Result<EditorNoteList> _noteListResult = null;
    private Lookup.Result<ForceSelectionNodeList> _forceSelectFromEditorResult = null;
    private NoteTreePanel _hierarchyTreePanel = null;
    private NoteTreePanel _nameBasedTreePanel = null;
    private ExplorerManager _hierarchyExplorerManager = null;
    private ExplorerManager _nameBasedExplorerManager = null;

    public NoteExplorerTopComponent() {
	initComponents();
	setName(NbBundle.getMessage(NoteExplorerTopComponent.class, "CTL_NoteExplorerTopComponent"));
	setToolTipText(NbBundle.getMessage(NoteExplorerTopComponent.class, "HINT_NoteExplorerTopComponent"));
//        setIcon(ImageUtilities.loadImage(ICON_PATH, true));
        
        _model = Lookup.getDefault().lookup(ExperimentHierarchyModel.class);

	_hierarchyTreePanel = (NoteTreePanel) _hierarchyPanel;
	_nameBasedTreePanel = (NoteTreePanel) _nameBasedPanel;
	_hierarchyTreePanel.setNodeType(NodeByTypeStickyLookup.LEVELTYPE_HIER);
	_nameBasedTreePanel.setNodeType(NodeByTypeStickyLookup.LEVELTYPE_NAME);
	_hierarchyExplorerManager = _hierarchyTreePanel.getExplorerManager();
	_nameBasedExplorerManager = _nameBasedTreePanel.getExplorerManager();
	_hierarchyExplorerManager.setRootContext(new AbstractNode(Children.LEAF));
	_hierarchyExplorerManager.getRootContext().setDisplayName("Empty");
	_nameBasedExplorerManager.setRootContext(new AbstractNode(Children.LEAF));
	_nameBasedExplorerManager.getRootContext().setDisplayName("Empty");
	associateLookup(new ProxyLookup(
		ExplorerUtils.createLookup(_hierarchyExplorerManager, _hierarchyTreePanel.getActionMap()),
		ExplorerUtils.createLookup(_nameBasedExplorerManager, _nameBasedTreePanel.getActionMap())));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        _tabbedPane = new javax.swing.JTabbedPane();
        _hierarchyPanel = new NoteTreePanel();
        _nameBasedPanel = new NoteTreePanel();

        setLayout(new java.awt.GridBagLayout());

        _tabbedPane.addTab(org.openide.util.NbBundle.getMessage(NoteExplorerTopComponent.class, "NoteExplorerTopComponent._hierarchyPanel.TabConstraints.tabTitle"), _hierarchyPanel); // NOI18N
        _tabbedPane.addTab(org.openide.util.NbBundle.getMessage(NoteExplorerTopComponent.class, "NoteExplorerTopComponent._nameBasedPanel.TabConstraints.tabTitle"), _nameBasedPanel); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(_tabbedPane, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel _hierarchyPanel;
    private javax.swing.JPanel _nameBasedPanel;
    private javax.swing.JTabbedPane _tabbedPane;
    // End of variables declaration//GEN-END:variables

    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link #findInstance}.
     */
    public static synchronized NoteExplorerTopComponent getDefault() {
	if (instance == null) {
	    instance = new NoteExplorerTopComponent();
	}
	return instance;
    }

    /**
     * Obtain the NoteExplorerTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized NoteExplorerTopComponent findInstance() {
	TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
	if (win == null) {
	    Logger.getLogger(NoteExplorerTopComponent.class.getName()).warning(
		    "Cannot find " + PREFERRED_ID + " component. It will not be located properly in the window system.");
	    return getDefault();
	}
	if (win instanceof NoteExplorerTopComponent) {
	    return (NoteExplorerTopComponent) win;
	}
	Logger.getLogger(NoteExplorerTopComponent.class.getName()).warning(
		"There seem to be multiple components with the '" + PREFERRED_ID
		+ "' ID. That is a potential source of errors and unexpected behavior.");
	return getDefault();
    }

    @Override
    public int getPersistenceType() {
	return TopComponent.PERSISTENCE_ALWAYS;
    }

    @Override
    public void componentOpened() {
	_gcont = Lookup.getDefault().lookup(GlobalContainer.class);
	_noteListResult = _gcont.getLookup().lookupResult(EditorNoteList.class);
	_noteListResult.addLookupListener(this);
	_forceSelectFromEditorResult = _gcont.getLookup().lookupResult(ForceSelectionNodeList.class);
	_forceSelectFromEditorResult.addLookupListener(this);
	reportSelectedPane();
	_tabbedPane.addChangeListener(new ChangeListener() {

	    public void stateChanged(ChangeEvent e) {
		Object source = e.getSource();
		if (source == _tabbedPane) {
		    reportSelectedPane();
		}
	    }
	});
    }

    private void reportSelectedPane() {
	Component c = _tabbedPane.getSelectedComponent();
	NoteTreePanel selected = null;
	if (c == _hierarchyTreePanel) {
	    selected = _hierarchyTreePanel;
	} else if (c == _nameBasedTreePanel) {
	    selected = _nameBasedTreePanel;
	}
	if (selected != null) {
	    NoteTreePanel oldpanel = _gcont.getLookup().lookup(NoteTreePanel.class);
	    if (oldpanel != null) {
		_gcont.getContent().remove(oldpanel);
	    }
	    _gcont.getContent().add(selected);
	}
    }

    @Override
    public void componentClosed() {
	if (_noteListResult != null) {
	    _noteListResult.removeLookupListener(this);
	    _noteListResult = null;
	}
    }

    void writeProperties(java.util.Properties p) {
	// better to version settings since initial version as advocated at
	// http://wiki.apidesign.org/wiki/PropertyFiles
	p.setProperty("version", "1.0");
	// TODO store your settings
    }

    Object readProperties(java.util.Properties p) {
	if (instance == null) {
	    instance = this;
	}
	instance.readPropertiesImpl(p);
	return instance;
    }

    private void readPropertiesImpl(java.util.Properties p) {
	String version = p.getProperty("version");
	// TODO read your settings according to their version
    }

    @Override
    protected String preferredID() {
	return PREFERRED_ID;
    }

    public void resultChanged(LookupEvent le) {
	Lookup.Result r = (Lookup.Result) le.getSource();
	if (r == _noteListResult) {
	    Collection<? extends EditorNoteList> c = _noteListResult.allInstances();
	    if (!c.isEmpty()) {
		EditorNoteList notelist = c.iterator().next();
		_hierarchyExplorerManager.setRootContext(new AbstractNode(HierarchyNodeFactories.createHierarchyRootChildren(notelist, _model)));
		_hierarchyExplorerManager.getRootContext().setDisplayName("ROOT");
		_nameBasedExplorerManager.setRootContext(new AbstractNode(NameBasedNodeFactories.createNameBasedRootChildren(notelist)));
		_nameBasedExplorerManager.getRootContext().setDisplayName("ROOT");
	    } else {
		_hierarchyExplorerManager.setRootContext(new AbstractNode(Children.LEAF));
		_hierarchyExplorerManager.getRootContext().setDisplayName("Empty");
		_nameBasedExplorerManager.setRootContext(new AbstractNode(Children.LEAF));
		_nameBasedExplorerManager.getRootContext().setDisplayName("Empty");
	    }
	} else if (r == _forceSelectFromEditorResult) {
	    Collection<? extends ForceSelectionNodeList> c = _forceSelectFromEditorResult.allInstances();
	    if (!c.isEmpty()) {
		NoteCollectorNodeList nodeList = c.iterator().next();
		try {
		    NoteCollectorNodeList hierNodeList = new NoteCollectorNodeList();
		    NoteCollectorNodeList nameNodeList = new NoteCollectorNodeList();
		    for (NoteCollectorNode node : nodeList) {
			if (node instanceof NoteNode) {
			    NoteLevel level = ((NoteNode) node).getLevel();
			    if (level instanceof HierarchyNoteLevel) {
				hierNodeList.add(node);
			    } else {
				nameNodeList.add(node);
			    }
			} else if (node instanceof HierarchyLevelNode) {
			    hierNodeList.add(node);
			} else if (node instanceof LevelNode) {
			    nameNodeList.add(node);
			}
		    }
		    _hierarchyExplorerManager.setSelectedNodes(hierNodeList.toArray(new Node[hierNodeList.size()]));
		    _nameBasedExplorerManager.setSelectedNodes(nameNodeList.toArray(new Node[nameNodeList.size()]));
		} catch (PropertyVetoException e) {
		    // oh well
		}
	    }
	}
    }
}
