/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.io;

import java.awt.CardLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.nbirn.fbirn.notecollector.gui.shared.GlobalContainer;
import org.nbirn.fbirn.notecollector.nodes.EditorNote;
import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import org.nbirn.fbirn.notes.BIRNHIDHierarchyModel;
import org.nbirn.fbirn.notes.ExperimentHierarchyModel;
import org.nbirn.fbirn.notes.HID;
import org.nbirn.fbirn.notes.Note;
import org.nbirn.fbirn.notes.NoteException;
import org.nbirn.fbirn.utilities.ProgressUpdater;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
//import org.openide.util.ImageUtilities;
import org.netbeans.api.settings.ConvertAsProperties;
import org.nbirn.fbirn.notes.NoteList;
import org.nbirn.fbirn.notes.NotePrivileges;
import org.nbirn.fbirn.notes.NoteSource;
import org.nbirn.fbirn.notes.NoteSourceCIGAL;
import org.nbirn.fbirn.notes.NoteSourceCatalog;
import org.nbirn.fbirn.notes.NoteSourceFile;
import org.nbirn.fbirn.notes.NoteSourceFileHierarchy;
import org.nbirn.fbirn.notes.NoteSourceHID;
import org.nbirn.fbirn.notes.NoteTarget;
import org.nbirn.fbirn.notes.NoteTarget.NotePathIndex;
import org.nbirn.fbirn.notes.NoteTargetCatalog;
import org.nbirn.fbirn.notes.NoteTargetFile;
import org.nbirn.fbirn.notes.NoteTargetFileHierarchy;
import org.nbirn.fbirn.notes.NoteTargetHID;
import org.nbirn.fbirn.notes.URIWithType;
import org.nbirn.fbirn.utilities.AppPropertyChangerCombo;
import org.nbirn.fbirn.utilities.AppPropertyChangerTextField;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.ExceptionCollection;
import org.nbirn.fbirn.utilities.ExceptionDialog;
import org.nbirn.fbirn.utilities.ProxyProgressUpdater;
import org.nbirn.fbirn.utilities.ProgressListener;
import org.nbirn.fbirn.utilities.PropertySetManager;
import org.nbirn.fbirn.utilities.SteppedComboBox;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromURL;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ServiceProvider;
import org.openide.windows.WindowManager;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(dtd = "-//org.nbirn.fbirn.notecollector.gui.io//IO//EN", autostore = false)
@ServiceProvider(service = IOTopComponent.class)
public final class IOTopComponent extends TopComponent {

    private static IOTopComponent instance;
    private GlobalContainer _gcont = null;
    private ExperimentHierarchyModel _model = null;
    private PropertySetManager _propset = null;
    private EditorNoteList _noteList = null;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    private static final String PREFERRED_ID = "IOTopComponent";
    private static final String IOTYPE_XCEDE2_SOURCE_CATALOG = "XCEDE 2.0 Source Catalog (XML)";
    private static final String IOTYPE_XCEDE2_NOTES_CATALOG = "XCEDE 2.0 Notes Catalog (XML)";
    private static final String IOTYPE_XCEDE2_EXPERIMENT_DATA = "XCEDE 2.0 Experiment Data (XML)";
    private static final String IOTYPE_RAW_HIERARCHY = "Raw notes (ASCII text) - file hierarchy";
    private static final String IOTYPE_RAW_SINGLE = "Raw notes (ASCII text) - single file";
    private static final String IOTYPE_CIGAL = "CIGAL Notes file(s)";
    private static final String IOTYPE_HID = "HID";
    private static String[] _sourceTypeModel = {
        IOTYPE_HID,
        IOTYPE_RAW_SINGLE,
        IOTYPE_RAW_HIERARCHY,
        IOTYPE_CIGAL,
        IOTYPE_XCEDE2_SOURCE_CATALOG,
        IOTYPE_XCEDE2_NOTES_CATALOG,
        IOTYPE_XCEDE2_EXPERIMENT_DATA,};
    private static String[] _targetTypeModel = {
        IOTYPE_HID,
        IOTYPE_RAW_SINGLE,
        IOTYPE_RAW_HIERARCHY,
        IOTYPE_XCEDE2_NOTES_CATALOG,};
    private Lookup.Result _credResult = null;
    private CredentialManager _credMan = null;
    private JLabel _upMessage = null;
    private JTextField _upUsername = null;
    private JPasswordField _upPassword = null;
    private JOptionPane _upPane = null;
    private JDialog _upDialog = null;
    private final Integer _upLock = new Integer(0);
    private SwingWorker<EditorNoteList, Void> _readWorker = null;
    private final String _sourceReadText = "Read from Source";
    private final String _sourceReadCancelText = "Cancel read";
    private ProxyProgressUpdater _sourceProgressUpdater = null;
    private ProxyProgressUpdater _targetProgressUpdater = null;

    private class CredListener implements LookupListener {

        public void resultChanged(LookupEvent le) {
            _credMan = null;
            Lookup.Result r = (Lookup.Result) le.getSource();
            Collection c = r.allInstances();
            if (!c.isEmpty()) {
                _credMan = (CredentialManager) c.iterator().next();
            }
        }
    }

    public IOTopComponent() {
        initComponents();
        IOTypeStateChanged(_SourceCards, _SourceTypeCombo.getSelectedItem());
        IOTypeStateChanged(_TargetCards, _TargetTypeCombo.getSelectedItem());
        setName(NbBundle.getMessage(IOTopComponent.class, "CTL_IOTopComponent"));
        setToolTipText(NbBundle.getMessage(IOTopComponent.class, "HINT_IOTopComponent"));
//        setIcon(ImageUtilities.loadImage(ICON_PATH, true));

        _propset = new PropertySetManager(this.getClass(), "NoteCollector");

        initPropertyLinkedFixedCombo("sourceType", _SourceTypeCombo);
        initPropertyLinkedEditableCombo("sourceHIDURL", _SourceHIDURL);
        initPropertyLinkedEditableCombo("sourceURL", _SourceURL);
        initPropertyLinkedEditableCombo("sourceBaseURL", _SourceBaseURL);
        initPropertyLinkedEditableCombo("sourceReplaceRoot", _SourceReplaceRoot);
        initPropertyLinkedEditableCombo("sourceNoteFileName", _SourceNoteFileName);
        initPropertyLinkedFixedCombo("targetType", _TargetTypeCombo);
        initPropertyLinkedEditableCombo("targetHIDURL", _TargetHIDURL);
        initPropertyLinkedEditableCombo("targetURL", _TargetURL);
        initPropertyLinkedEditableCombo("targetBaseURL", _TargetBaseURL);
        initPropertyLinkedEditableCombo("targetNoteFileName", _TargetNoteFileName);
        initPropertyLinkedTextField("sourceHIDUsername", _SourceHIDUsername);
        initPropertyLinkedTextField("targetHIDUsername", _TargetHIDUsername);

        _SourceTypeCombo.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                Object selectedItem = _SourceTypeCombo.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem.equals(IOTYPE_CIGAL) || selectedItem.equals(IOTYPE_RAW_HIERARCHY)) {
                    setComboBoxEnabled(_SourceNoteFileName, true);
                } else {
                    setComboBoxEnabled(_SourceNoteFileName, false);
                }
                if (selectedItem.equals(IOTYPE_CIGAL)) {
                    setComboBoxEnabled(_SourceReplaceRoot, true);
                } else {
                    setComboBoxEnabled(_SourceReplaceRoot, false);
                }
            }
        });
        _TargetTypeCombo.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                Object selectedItem = _TargetTypeCombo.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem.equals(IOTYPE_XCEDE2_NOTES_CATALOG) || selectedItem.equals(IOTYPE_RAW_HIERARCHY) || selectedItem.equals(IOTYPE_RAW_SINGLE)) {
                    setComboBoxEnabled(_TargetBaseURL, true);
                } else {
                    setComboBoxEnabled(_TargetBaseURL, false);
                }
                if (selectedItem.equals(IOTYPE_RAW_HIERARCHY)) {
                    setComboBoxEnabled(_TargetNoteFileName, true);
                } else {
                    setComboBoxEnabled(_TargetNoteFileName, false);
                }
            }
        });

        String propval = null;
        Collection<String> propvalset = null;
        if ((propval = _propset.getProperty("sourceType")) != null) {
            for (int i = 0; i < _SourceTypeCombo.getItemCount(); i++) {
                Object obj = _SourceTypeCombo.getItemAt(i);
                if (obj.equals(propval)) {
                    _SourceTypeCombo.setSelectedItem(obj);
                }
            }
        }
        if ((propval = _propset.getProperty("targetType")) != null) {
            for (int i = 0; i < _TargetTypeCombo.getItemCount(); i++) {
                Object obj = _TargetTypeCombo.getItemAt(i);
                if (obj.equals(propval)) {
                    _TargetTypeCombo.setSelectedItem(obj);
                }
            }
        }

        _gcont = Lookup.getDefault().lookup(GlobalContainer.class);
        Lookup gclookup = _gcont.getLookup();

        _noteList = new EditorNoteList();

        _model = Lookup.getDefault().lookup(ExperimentHierarchyModel.class);

        _credResult = Lookup.getDefault().lookupResult(CredentialManager.class);
        _credResult.addLookupListener(new CredListener());

        _upMessage = new JLabel("");
        JLabel userlabel = new JLabel("Username: ");
        JLabel pwdlabel = new JLabel("Password: ");
        _upUsername = new JTextField();
        _upPassword = new JPasswordField();
        _upUsername.setMinimumSize(new Dimension(80, 10));
        _upPassword.setMinimumSize(new Dimension(80, 10));
        JPanel upFieldPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        upFieldPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();

        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.gridx = 0;
        constraints.gridy = 0;
        upFieldPanel.add(_upMessage, constraints);

        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        upFieldPanel.add(userlabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        upFieldPanel.add(pwdlabel, constraints);

        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        constraints.gridy = 1;
        upFieldPanel.add(_upUsername, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        upFieldPanel.add(_upPassword, constraints);

        _upPane = new JOptionPane(upFieldPanel,
                JOptionPane.QUESTION_MESSAGE,
                JOptionPane.OK_CANCEL_OPTION);
        _upDialog = _upPane.createDialog("Credentials:");
        _upDialog.addComponentListener(new ComponentAdapter() {

            @Override
            public void componentShown(ComponentEvent e) {
                SwingUtilities.invokeLater(new Runnable() {

                    @Override
                    public void run() {
                        _upPassword.requestFocusInWindow();
                    }
                });
            }
        });

        _sourceProgressUpdater = new ProxyProgressUpdater("All");
        _sourceProgressUpdater.addProgressListener(new ProgressListener() {

            @Override
            public void progressStart(ProgressUpdater updater, String msg) {
                _SourceProgressBar.setIndeterminate(true);
                if (msg != null) {
                    _SourceProgressMessage.setText(msg);
                }
            }

            @Override
            public void progressUpdate(ProgressUpdater updater, double progress, String msg) {
                _SourceProgressBar.setIndeterminate(false);
                _SourceProgressBar.setValue((int) ((progress * 100) + 0.0000001));
                if (msg != null) {
                    _SourceProgressMessage.setText(msg);
                }
            }

            @Override
            public void progressFinish(ProgressUpdater updater, String msg) {
                _SourceProgressBar.setIndeterminate(false);
                if (msg != null) {
                    _SourceProgressMessage.setText(msg);
                }
            }
        });
        _targetProgressUpdater = new ProxyProgressUpdater("All");
        _targetProgressUpdater.addProgressListener(new ProgressListener() {

            @Override
            public void progressStart(ProgressUpdater updater, String msg) {
                _TargetProgressBar.setIndeterminate(true);
                _TargetProgressMessage.setText((msg == null) ? "" : msg);
            }

            @Override
            public void progressUpdate(ProgressUpdater updater, double progress, String msg) {
                _TargetProgressBar.setIndeterminate(false);
                _TargetProgressBar.setValue((int) ((progress * 100) + 0.0000001));
                if (msg != null) {
                    _TargetProgressMessage.setText(msg);
                }
            }

            @Override
            public void progressFinish(ProgressUpdater updater, String msg) {
                _TargetProgressBar.setIndeterminate(false);
                _TargetProgressMessage.setText((msg == null) ? "" : msg);
            }
        });
    }

    private void initPropertyLinkedFixedCombo(String propName, JComboBox combo) {
        initPropertyLinkedCombo(propName, combo, false);
    }

    private void initPropertyLinkedEditableCombo(String propName, JComboBox combo) {
        initPropertyLinkedCombo(propName, combo, true);
    }

    private void initPropertyLinkedCombo(String propName, JComboBox combo, boolean editable) {
        AppPropertyChangerCombo changer = new AppPropertyChangerCombo(_propset, propName, combo);
        combo.addFocusListener(changer);
        combo.addActionListener(changer);
        if (editable) {
            Collection<String> propvalset = null;
            if ((propvalset = _propset.getPropertySet(propName)) != null) {
                for (String s : propvalset) {
                    combo.addItem(s);
                }
                if (!propvalset.isEmpty()) {
                    combo.setSelectedIndex(0);
                }
            }
        } else {
            String propval = null;
            if ((propval = _propset.getProperty(propName)) != null) {
                for (int i = 0; i < combo.getItemCount(); i++) {
                    Object obj = combo.getItemAt(i);
                    if (obj.equals(propval)) {
                        combo.setSelectedItem(obj);
                    }
                }
            }
        }
    }

    private void initPropertyLinkedTextField(String propName, JTextField textField) {
        AppPropertyChangerTextField changer = new AppPropertyChangerTextField(_propset, propName, textField);
        textField.addFocusListener(changer);
        Collection<String> propvalset = null;
        String propVal = _propset.getProperty(propName);
        if (propVal != null) {
            textField.setText(propVal);
        }
    }

    private void setComboBoxEnabled(JComboBox combo, boolean enabled) {
        combo.setEnabled(enabled);
        combo.setEditable(enabled);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        _FileChooser = new javax.swing.JFileChooser();
        _TopPanel = new javax.swing.JPanel();
        _TopScrollPane = new javax.swing.JScrollPane();
        _IOPanel = new javax.swing.JPanel();
        _SourcePanel = new javax.swing.JPanel();
        _SourceLabel = new javax.swing.JLabel();
        _SourceTypeCombo = new javax.swing.JComboBox();
        _SourceCards = new javax.swing.JPanel();
        _SourceHIDCard = new javax.swing.JPanel();
        _SourceHIDURLLabel = new javax.swing.JLabel();
        _SourceHIDURL = new SteppedComboBox();
        _SourceHIDUsernameLabel = new javax.swing.JLabel();
        _SourceHIDUsername = new javax.swing.JTextField();
        _SourceHIDPasswordLabel = new javax.swing.JLabel();
        _SourceHIDPassword = new javax.swing.JPasswordField();
        _SourceFileCard = new javax.swing.JPanel();
        _SourceURLLabel = new javax.swing.JLabel();
        _SourceURL = new SteppedComboBox();
        _SourceURLButton = new javax.swing.JButton();
        _SourceBaseURLLabel = new javax.swing.JLabel();
        _SourceBaseURL = new SteppedComboBox();
        _SourceReplaceRootLabel = new javax.swing.JLabel();
        _SourceReplaceRoot = new SteppedComboBox();
        _SourceNoteFileNameLabel = new javax.swing.JLabel();
        _SourceNoteFileName = new SteppedComboBox();
        _SourceButtonPanel = new javax.swing.JPanel();
        _SourceReadButton = new javax.swing.JButton();
        _SourceProgressBar = new javax.swing.JProgressBar();
        _SourceProgressPanel = new javax.swing.JPanel();
        _SourceProgressMessage = new javax.swing.JTextArea();
        _SourceProgressMessage2 = new javax.swing.JTextArea();
        _SourceMsgLabel = new javax.swing.JLabel();
        _TargetPanel = new javax.swing.JPanel();
        _TargetLabel = new javax.swing.JLabel();
        _TargetTypeCombo = new javax.swing.JComboBox();
        _TargetCards = new javax.swing.JPanel();
        _TargetHIDCard = new javax.swing.JPanel();
        _TargetHIDURLLabel = new javax.swing.JLabel();
        _TargetHIDURL = new SteppedComboBox();
        _TargetHIDUsernameLabel = new javax.swing.JLabel();
        _TargetHIDUsername = new javax.swing.JTextField();
        _TargetHIDPasswordLabel = new javax.swing.JLabel();
        _TargetHIDPassword = new javax.swing.JPasswordField();
        _CreateItemsCheckBox = new javax.swing.JCheckBox();
        _TargetFileCard = new javax.swing.JPanel();
        _TargetFileLabel = new javax.swing.JLabel();
        _TargetURL = new SteppedComboBox();
        _TargetFileButton = new javax.swing.JButton();
        _TargetBasePathLabel = new javax.swing.JLabel();
        _TargetBaseURL = new SteppedComboBox();
        _TargetNoteFileNameLabel = new javax.swing.JLabel();
        _TargetNoteFileName = new SteppedComboBox();
        _TargetButtonPanel = new javax.swing.JPanel();
        _TargetWriteChangesButton = new javax.swing.JButton();
        _TargetWriteAllButton = new javax.swing.JButton();
        _TargetProgressBar = new javax.swing.JProgressBar();
        _TargetProgressPanel = new javax.swing.JPanel();
        _TargetProgressMessage = new javax.swing.JTextArea();
        _TargetProgressMessage2 = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        _TargetMsgLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        _TopPanel.setPreferredSize(new java.awt.Dimension(500, 297));
        _TopPanel.setLayout(new java.awt.GridBagLayout());

        _TopScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);

        _IOPanel.setLayout(new java.awt.GridBagLayout());

        _SourcePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourcePanel.border.title"))); // NOI18N
        _SourcePanel.setLayout(new java.awt.GridBagLayout());

        _SourceLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceLabel.text")); // NOI18N
        _SourceLabel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _SourcePanel.add(_SourceLabel, gridBagConstraints);

        _SourceTypeCombo.setModel(new DefaultComboBoxModel(_sourceTypeModel));
        _SourceTypeCombo.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                _SourceTypeComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _SourcePanel.add(_SourceTypeCombo, gridBagConstraints);

        _SourceCards.setLayout(new java.awt.CardLayout());

        _SourceHIDCard.setLayout(new java.awt.GridBagLayout());

        _SourceHIDURLLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceHIDURLLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceHIDURLLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _SourceHIDCard.add(_SourceHIDURLLabel, gridBagConstraints);

        _SourceHIDURL.setEditable(true);
        _SourceHIDURL.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        _SourceHIDCard.add(_SourceHIDURL, gridBagConstraints);

        _SourceHIDUsernameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceHIDUsernameLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceHIDUsernameLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _SourceHIDCard.add(_SourceHIDUsernameLabel, gridBagConstraints);

        _SourceHIDUsername.setColumns(20);
        _SourceHIDUsername.setText(org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceHIDUsername.text")); // NOI18N
        _SourceHIDUsername.setMinimumSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _SourceHIDCard.add(_SourceHIDUsername, gridBagConstraints);

        _SourceHIDPasswordLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceHIDPasswordLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceHIDPasswordLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _SourceHIDCard.add(_SourceHIDPasswordLabel, gridBagConstraints);

        _SourceHIDPassword.setColumns(20);
        _SourceHIDPassword.setText(org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceHIDPassword.text")); // NOI18N
        _SourceHIDPassword.setMinimumSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _SourceHIDCard.add(_SourceHIDPassword, gridBagConstraints);

        _SourceCards.add(_SourceHIDCard, "HID");

        _SourceFileCard.setLayout(new java.awt.GridBagLayout());

        _SourceURLLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceURLLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceURLLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _SourceFileCard.add(_SourceURLLabel, gridBagConstraints);

        _SourceURL.setEditable(true);
        _SourceURL.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourceFileCard.add(_SourceURL, gridBagConstraints);

        _SourceURLButton.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceURLButton, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceURLButton.text")); // NOI18N
        _SourceURLButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _SourceURLButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        _SourceFileCard.add(_SourceURLButton, gridBagConstraints);

        _SourceBaseURLLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceBaseURLLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceBaseURLLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _SourceFileCard.add(_SourceBaseURLLabel, gridBagConstraints);

        _SourceBaseURL.setEditable(true);
        _SourceBaseURL.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourceFileCard.add(_SourceBaseURL, gridBagConstraints);

        _SourceReplaceRootLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceReplaceRootLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceReplaceRootLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _SourceFileCard.add(_SourceReplaceRootLabel, gridBagConstraints);

        _SourceReplaceRoot.setEditable(true);
        _SourceReplaceRoot.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourceFileCard.add(_SourceReplaceRoot, gridBagConstraints);

        _SourceNoteFileNameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceNoteFileNameLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceNoteFileNameLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _SourceFileCard.add(_SourceNoteFileNameLabel, gridBagConstraints);

        _SourceNoteFileName.setEditable(true);
        _SourceNoteFileName.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourceFileCard.add(_SourceNoteFileName, gridBagConstraints);

        _SourceCards.add(_SourceFileCard, "File");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourcePanel.add(_SourceCards, gridBagConstraints);

        _SourceButtonPanel.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(_SourceReadButton, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceReadButton.text")); // NOI18N
        _SourceReadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _SourceReadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        _SourceButtonPanel.add(_SourceReadButton, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourceButtonPanel.add(_SourceProgressBar, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourcePanel.add(_SourceButtonPanel, gridBagConstraints);

        _SourceProgressPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 0, 0));
        _SourceProgressPanel.setLayout(new java.awt.GridBagLayout());

        _SourceProgressMessage.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        _SourceProgressMessage.setEditable(false);
        _SourceProgressMessage.setFont(new java.awt.Font("Dialog", 0, 8));
        _SourceProgressMessage.setLineWrap(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        _SourceProgressPanel.add(_SourceProgressMessage, gridBagConstraints);

        _SourceProgressMessage2.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        _SourceProgressMessage2.setEditable(false);
        _SourceProgressMessage2.setFont(new java.awt.Font("Dialog", 0, 8));
        _SourceProgressMessage2.setLineWrap(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        _SourceProgressPanel.add(_SourceProgressMessage2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _SourcePanel.add(_SourceProgressPanel, gridBagConstraints);

        _SourceMsgLabel.setFont(new java.awt.Font("Dialog", 0, 8));
        org.openide.awt.Mnemonics.setLocalizedText(_SourceMsgLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceMsgLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        _SourcePanel.add(_SourceMsgLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _IOPanel.add(_SourcePanel, gridBagConstraints);

        _TargetPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetPanel.border.title"))); // NOI18N
        _TargetPanel.setLayout(new java.awt.GridBagLayout());

        _TargetLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetLabel.text")); // NOI18N
        _TargetLabel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _TargetPanel.add(_TargetLabel, gridBagConstraints);

        _TargetTypeCombo.setModel(new DefaultComboBoxModel(_targetTypeModel));
        _TargetTypeCombo.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                _TargetTypeComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _TargetPanel.add(_TargetTypeCombo, gridBagConstraints);

        _TargetCards.setLayout(new java.awt.CardLayout());

        _TargetHIDCard.setLayout(new java.awt.GridBagLayout());

        _TargetHIDURLLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetHIDURLLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetHIDURLLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TargetHIDCard.add(_TargetHIDURLLabel, gridBagConstraints);

        _TargetHIDURL.setEditable(true);
        _TargetHIDURL.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        _TargetHIDCard.add(_TargetHIDURL, gridBagConstraints);

        _TargetHIDUsernameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetHIDUsernameLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetHIDUsernameLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TargetHIDCard.add(_TargetHIDUsernameLabel, gridBagConstraints);

        _TargetHIDUsername.setColumns(20);
        _TargetHIDUsername.setText(org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetHIDUsername.text")); // NOI18N
        _TargetHIDUsername.setMinimumSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _TargetHIDCard.add(_TargetHIDUsername, gridBagConstraints);

        _TargetHIDPasswordLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetHIDPasswordLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetHIDPasswordLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TargetHIDCard.add(_TargetHIDPasswordLabel, gridBagConstraints);

        _TargetHIDPassword.setColumns(20);
        _TargetHIDPassword.setText(org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetHIDPassword.text")); // NOI18N
        _TargetHIDPassword.setMinimumSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _TargetHIDCard.add(_TargetHIDPassword, gridBagConstraints);

        _CreateItemsCheckBox.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(_CreateItemsCheckBox, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._CreateItemsCheckBox.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        _TargetHIDCard.add(_CreateItemsCheckBox, gridBagConstraints);

        _TargetCards.add(_TargetHIDCard, "HID");

        _TargetFileCard.setLayout(new java.awt.GridBagLayout());

        _TargetFileLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetFileLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetFileLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TargetFileCard.add(_TargetFileLabel, gridBagConstraints);

        _TargetURL.setEditable(true);
        _TargetURL.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetFileCard.add(_TargetURL, gridBagConstraints);

        _TargetFileButton.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetFileButton, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetFileButton.text")); // NOI18N
        _TargetFileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _TargetFileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        _TargetFileCard.add(_TargetFileButton, gridBagConstraints);

        _TargetBasePathLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetBasePathLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetBasePathLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TargetFileCard.add(_TargetBasePathLabel, gridBagConstraints);

        _TargetBaseURL.setEditable(true);
        _TargetBaseURL.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetFileCard.add(_TargetBaseURL, gridBagConstraints);

        _TargetNoteFileNameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetNoteFileNameLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetNoteFileNameLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TargetFileCard.add(_TargetNoteFileNameLabel, gridBagConstraints);

        _TargetNoteFileName.setEditable(true);
        _TargetNoteFileName.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetFileCard.add(_TargetNoteFileName, gridBagConstraints);

        _TargetCards.add(_TargetFileCard, "File");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetPanel.add(_TargetCards, gridBagConstraints);

        _TargetButtonPanel.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(_TargetWriteChangesButton, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetWriteChangesButton.text")); // NOI18N
        _TargetWriteChangesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _TargetWriteChangesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        _TargetButtonPanel.add(_TargetWriteChangesButton, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(_TargetWriteAllButton, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetWriteAllButton.text")); // NOI18N
        _TargetWriteAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _TargetWriteAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        _TargetButtonPanel.add(_TargetWriteAllButton, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetButtonPanel.add(_TargetProgressBar, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetPanel.add(_TargetButtonPanel, gridBagConstraints);

        _TargetProgressPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 0, 0));
        _TargetProgressPanel.setLayout(new java.awt.GridBagLayout());

        _TargetProgressMessage.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        _TargetProgressMessage.setEditable(false);
        _TargetProgressMessage.setFont(new java.awt.Font("Dialog", 0, 8));
        _TargetProgressMessage.setLineWrap(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        _TargetProgressPanel.add(_TargetProgressMessage, gridBagConstraints);

        _TargetProgressMessage2.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        _TargetProgressMessage2.setEditable(false);
        _TargetProgressMessage2.setFont(new java.awt.Font("Dialog", 0, 8));
        _TargetProgressMessage2.setLineWrap(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        _TargetProgressPanel.add(_TargetProgressMessage2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetPanel.add(_TargetProgressPanel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TargetPanel.add(jPanel1, gridBagConstraints);

        _TargetMsgLabel.setFont(new java.awt.Font("Dialog", 0, 8));
        org.openide.awt.Mnemonics.setLocalizedText(_TargetMsgLabel, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._TargetMsgLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        _TargetPanel.add(_TargetMsgLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _IOPanel.add(_TargetPanel, gridBagConstraints);

        _TopScrollPane.setViewportView(_IOPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        _TopPanel.add(_TopScrollPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(_TopPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private Object makeObj(final String item) {
        return new Object() {

            @Override
            public String toString() {
                return item;
            }
        };
    }

    private File getURISync(URI uri, String tempPrefix, String tempSuffix) throws NoteException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(tempPrefix, tempSuffix);
        } catch (IOException e) {
            System.err.println("Error creating temporary file: " + e.getMessage());
            throw new NoteException("Error creating temporary file", e);
        }
        try {
            WorkerDownloadFromURL worker = new WorkerDownloadFromURL(uri, tempFile, _credMan);
            Executors.newCachedThreadPool().execute(worker);
            worker.get();
        } catch (Exception e) {
            throw new NoteException("Error downloading document '" + uri.toString() + "':\n", e);
        }
        return tempFile;
    }

    private void addNoteListFromSource(EditorNoteList noteList, List<String> errMsgs, String sourceName, String sourceType, URI uri, URI baseURI, URI replaceRoot, String noteFileName, String hidUser, ProxyProgressUpdater updater) throws NoteException {
        NoteSource source = null;
        File tempFile = null;
        if (IOTYPE_HID.equals(sourceType)) {
            synchronized (_upLock) {
                boolean firsttime = true;
                if (hidUser != null) {
                    _upUsername.setText(hidUser);
                }
                _upMessage.setText("Please enter credentials for '" + (uri == null ? "" : uri.toString()) + "':");
                while (true) {
                    int result = JOptionPane.OK_OPTION;
                    if (!firsttime) {
                        _upDialog.pack();
                        _upDialog.setVisible(true);
                        result = (Integer) _upPane.getValue();
                        _upDialog.setVisible(false);
                    }
                    firsttime = false;
                    char[] password = null;
                    if (result == JOptionPane.OK_OPTION) {
                        password = _upPassword.getPassword();
                        try {
                            HID hid = new HID(uri, _upUsername.getText(), password);
                            hid.connect();
                            source = new NoteSourceHID(_model, "hid", hid, NoteSourceHID.SOURCES_DESCTUPLE);
                            break;
                        } catch (Exception e) {
                            _upMessage.setText("Error connecting to '" + uri.toString() + "': " + e.toString());
                        } finally {
                            Arrays.fill(password, '0');
                        }
                    } else if (result == JOptionPane.CANCEL_OPTION) {
                        break;
                    }
                }
                if (source == null) {
                    ProxyProgressUpdater newUpdater = new ProxyProgressUpdater();
                    updater.addUpdater(newUpdater, sourceName);
                    newUpdater.progressUpdate(updater, 1.0);
                    return;
                }
            }
        } else {
            final URI resolvedURI;
            URI resolvedReplaceRoot = null;
            if (baseURI == null) {
                try {
                    URI workingDirURL = new URI("file", null, System.getProperty("user.dir"), null);
                    resolvedURI = workingDirURL.resolve(uri);
                    if (replaceRoot != null) {
                        resolvedReplaceRoot = workingDirURL.resolve(replaceRoot);
                    }
                } catch (URISyntaxException e) {
                    throw new NoteException("Error creating URI", e);
                }
            } else {
                resolvedURI = baseURI.resolve(uri);
            }
            if (IOTYPE_RAW_HIERARCHY.equals(sourceType) == !IOTYPE_CIGAL.equals(sourceType)) {
                if (resolvedURI.getScheme() != null && !"file".equals(resolvedURI.getScheme())) {
                    throw new NoteException("For raw hierarchy and CIGAL sources, source URI must be a local path (i.e. if it has a scheme, it must be 'file:'");
                }
            } else {
                tempFile = getURISync(resolvedURI, "notecollectorgui.", ".tmp");
            }
            if (IOTYPE_RAW_SINGLE.equals(sourceType)) {
                source = new NoteSourceFile(tempFile, resolvedURI);
            } else if (IOTYPE_RAW_HIERARCHY.equals(sourceType)) {
                source = new NoteSourceFileHierarchy(new File(uri.getPath()), baseURI, noteFileName);
            } else if (IOTYPE_XCEDE2_NOTES_CATALOG.equals(sourceType)) {
                Catalog cat = new Catalog();
                try {
                    cat.parseCatalogFile(tempFile);
                } catch (Exception e) {
                    throw new NoteException("Error parsing catalog file", e);
                }
                source = new NoteSourceCatalog(cat, resolvedURI);
            } else if (IOTYPE_XCEDE2_SOURCE_CATALOG.equals(sourceType)) {
                Catalog cat = new Catalog();
                try {
                    cat.parseCatalogFile(tempFile);
                } catch (Exception e) {
                    throw new NoteException("Error parsing catalog file", e);
                }
                Stack<Catalog> stack = new Stack<Catalog>();
                stack.add(cat);
                while (!stack.isEmpty()) {
                    Catalog curcat = stack.pop();
                    if (curcat.hasMetaField("notePrivileges")) {
                        URI privurl = resolvedURI.resolve(curcat.getMetaField("notePrivileges").toString());
                        File tempFileCat = getURISync(privurl, "notecollectorgui.", "privs");
                        NotePrivileges oldPrivs = _gcont.getLookup().lookup(NotePrivileges.class);
                        if (oldPrivs != null) {
                            _gcont.getContent().remove(oldPrivs);
                        }
                        NotePrivileges newPrivs = NotePrivileges.read(tempFileCat);
                        _gcont.getContent().add(newPrivs);
                        tempFileCat.delete();
                    }
                    for (int i = curcat.getNumCatalogs() - 1; i >= 0; i--) {
                        stack.add(curcat.getCatalog(i));
                    }
                    class NoteListAndErrorMessages {

                        EditorNoteList noteList;
                        List<String> errMsgs;

                        NoteListAndErrorMessages(EditorNoteList noteList_, List<String> errMsgs_) {
                            noteList = noteList_;
                            errMsgs = errMsgs_;
                        }
                    }
                    List<SwingWorker<NoteListAndErrorMessages, Void>> workerList = new ArrayList<SwingWorker<NoteListAndErrorMessages, Void>>();
                    List<ProxyProgressUpdater> updaterList = new ArrayList<ProxyProgressUpdater>();
                    for (int i = 0; i < curcat.getNumEntries(); i++) {
                        final CatalogEntry entry = curcat.getEntry(i);
                        if (entry.hasMetaField("noteSourceType")) {
                            final String hidUserCopy = hidUser;
                            final ProxyProgressUpdater subUpdater = new ProxyProgressUpdater();
                            updater.addUpdater(subUpdater, entry.getName());
                            final SwingWorker<NoteListAndErrorMessages, Void> worker = new SwingWorker<NoteListAndErrorMessages, Void>() {

                                @Override
                                protected NoteListAndErrorMessages doInBackground() throws Exception {
                                    String newType = (String) entry.getMetaField("noteSourceType");
                                    URI newURI = resolvedURI.resolve(entry.getURI());
                                    URI newBaseURI = null;
                                    if (entry.hasMetaField("noteBasePath")) {
                                        newBaseURI = resolvedURI.resolve(entry.getMetaField("noteBasePath").toString());
                                        newURI = newBaseURI.resolve(entry.getURI());
                                    }
                                    URI newReplaceRoot = null;
                                    if (entry.hasMetaField("noteReplaceRoot")) {
                                        try {
                                            newReplaceRoot = new URI(entry.getMetaField("noteReplaceRoot").toString());
                                        } catch (URISyntaxException e) {
                                            throw new NoteException("Error creating URI for noteReplaceRoot");
                                        }
                                    }
                                    String newNoteFileName = null;
                                    if (entry.hasMetaField("noteFileName")) {
                                        newNoteFileName = entry.getMetaField("noteFileName").toString();
                                    }
                                    String newHIDUser = hidUserCopy;
                                    if (entry.hasMetaField("noteUsername")) {
                                        newHIDUser = entry.getMetaField("noteUsername").toString();
                                    }
                                    EditorNoteList noteList = new EditorNoteList();
                                    ArrayList<String> errMsgs = new ArrayList<String>();
                                    addNoteListFromSource(noteList, errMsgs, null, newType, newURI, newBaseURI, newReplaceRoot, newNoteFileName, newHIDUser, subUpdater);
                                    return new NoteListAndErrorMessages(noteList, errMsgs);
                                }
                            };
                            Executors.newCachedThreadPool().execute(worker);
                            workerList.add(worker);
                            updaterList.add(subUpdater);
                        }
                    }
                    ExceptionCollection ec = new ExceptionCollection();
                    while (!workerList.isEmpty()) {
                        for (int i = 0; i < workerList.size(); i++) {
                            SwingWorker<NoteListAndErrorMessages, Void> worker = workerList.get(i);
                            if (worker.isDone()) {
                                try {
                                    NoteListAndErrorMessages result = worker.get();
                                    synchronized (noteList) {
                                        noteList.addAll(result.noteList);
                                    }
                                    synchronized (errMsgs) {
                                        errMsgs.addAll(result.errMsgs);
                                    }
                                } catch (InterruptedException e) {
                                    updater.removeAllUpdaters();
                                    throw new NoteException("Worker was interrupted", e);
                                } catch (ExecutionException e) {
                                    ec.add(new NoteException("Worker returned an error", e.getCause()));
                                }
                                workerList.remove(i);
                                updaterList.remove(i);
                                i--;
                            }
                        }
                        try {
                            Thread.sleep(500);
                        } catch (InterruptedException e) {
                            for (SwingWorker<NoteListAndErrorMessages, Void> worker : workerList) {
                                worker.cancel(true);
                            }
                            throw new NoteException("Operation interrupted.", e);
                        }
                    }
                    if (!ec.getList().isEmpty()) {
                        ExceptionDialog.show(null, ec);
                    }
                }
            } else if (IOTYPE_CIGAL.equals(sourceType)) {
                source = new NoteSourceCIGAL(noteFileName, new File(resolvedURI.getPath()));
            }
        }
        if (source != null) {
            updater.addUpdater(source, sourceName);
            List<Note> sourceNoteList = source.getNoteList();
            updater.removeUpdater(source);
            if (IOTYPE_CIGAL.equals(sourceType)) {
                if (!sourceNoteList.isEmpty()) {
                    String oldURIPath = uri.getPath();
                    int oldURIPathLen = oldURIPath.length();
                    String replaceRootStr = (replaceRoot == null) ? null : replaceRoot.toString();
                    int numPaths = 0;
                    StringBuilder samplePaths = new StringBuilder();
                    for (Note note : sourceNoteList) {
                        for (URIWithType path : note.getPaths()) {
                            if (numPaths < 5) {
                                String pathURIStr = path.getURI().toString();
                                if (replaceRootStr != null && pathURIStr.startsWith(oldURIPath)) {
                                    pathURIStr = "[" + replaceRootStr + "]" + pathURIStr.substring(oldURIPathLen);
                                } else {
                                    pathURIStr = "[" + pathURIStr.substring(0, oldURIPathLen) + "]" + pathURIStr.substring(oldURIPathLen);
                                }
                                samplePaths.append("  ").append(pathURIStr).append("\n");
                                numPaths++;
                            }
                        }
                    }
                    if (replaceRootStr == null) {
                        replaceRootStr = oldURIPath;
                    }
                    String msg = "Following are a sample list of paths in the extracted notes:\n" + samplePaths.toString() + "If you wish to change the prefix of the paths (will replace portion in brackets above), please change the value below.";
                    replaceRootStr = JOptionPane.showInputDialog(null, msg, replaceRootStr);
                    if (replaceRootStr == null) {
                        throw new NoteException("Operation canceled by user");
                    } else if (!replaceRootStr.equals(oldURIPath)) {
                        for (Note note : sourceNoteList) {
                            for (URIWithType path : note.getPaths()) {
                                String pathURIStr = path.getURI().toString();
                                if (pathURIStr.startsWith(oldURIPath)) {
                                    try {
                                        path.setURI(new URI(replaceRootStr + pathURIStr.substring(oldURIPathLen)));
                                    } catch (URISyntaxException e) {
                                        throw new NoteException("Error creating URI", e);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            synchronized (noteList) {
                for (Note note : sourceNoteList) {
                    noteList.add(new EditorNote(note));
                }
            }
        }
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    private EditorNoteList putNoteListToTarget(EditorNoteList noteList, String targetType, URI uri, URI baseURI, boolean writeChangesOnly, ProxyProgressUpdater updater) throws NoteException {
        NoteTarget target = null;
        if (IOTYPE_HID.equals(targetType)) {
            boolean firsttime = true;
            _upMessage.setText("Please enter credentials for '" + _TargetHIDURL.getSelectedItem().toString() + "':");
            while (true) {
                int result = JOptionPane.OK_OPTION;
                if (!firsttime) {
                    _upDialog.pack();
                    _upDialog.setVisible(true);
                    result = (Integer) _upPane.getValue();
                    _upDialog.setVisible(false);
                }
                firsttime = false;
                char[] password = null;
                if (result == JOptionPane.OK_OPTION) {
                    try {
                        password = _upPassword.getPassword();
                        HID hid = new HID(uri, _upUsername.getText(), password);
                        hid.connect();
                        NoteTargetHID targetHID = new NoteTargetHID(_model, hid, _credMan);
                        targetHID.setCreateItems(_CreateItemsCheckBox.isSelected());
                        target = targetHID;
                        break;
                    } catch (Exception e) {
                        _upMessage.setText("Error connecting: " + e.toString());
                    } finally {
                        Arrays.fill(password, '0');
                    }
                } else if (result == JOptionPane.CANCEL_OPTION) {
                    throw new NoteException("Operation canceled by user");
                }
            }
        } else {
            if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
                exceptionDialog(new NoteException("For non-HID targets, target URI must be a local path (i.e. if it has a scheme, it must be 'file:'"));
                return null;
            }
            File file = new File(uri.getPath());
            if (IOTYPE_RAW_SINGLE.equals(targetType)) {
                NoteTargetFile targetFile = new NoteTargetFile(_model, file);
                targetFile.setSorted(true);
                target = targetFile;
            } else if (IOTYPE_RAW_HIERARCHY.equals(targetType)) {
                if (!file.exists()) {
                    int retval = JOptionPane.showOptionDialog(this, "Directory " + file.toString() + " doesn't exist.\nDo you want to create it?", "Create directory?", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, null, null, 0);
                    if (retval == 0) {
                        file.mkdirs();
                    } else {
                        return null;
                    }
                }
                target = new NoteTargetFileHierarchy(_model, file);
            } else if (IOTYPE_XCEDE2_NOTES_CATALOG.equals(targetType)) {
                target = new NoteTargetCatalog(_model, file);
            } else {
                noteList = null;
            }
        }
        if (target != null) {
            try {
                List<NoteTarget.PrivilegeError> privErrs = target.checkPrivileges(noteList, _credMan);
                boolean[] deleteNotes = new boolean[noteList.size()];
                TreeSet<NotePathIndex> deletePaths = new TreeSet<NotePathIndex>();
                boolean skipAllErrors = false;
                for (NoteTarget.PrivilegeError privErr : privErrs) {
                    if (skipAllErrors) {
                        for (NotePathIndex npind : privErr.errInds) {
                            deleteNotes[npind.noteInd] = true;
                        }
                    } else {
                        if (privErr.priv == NotePrivileges.PRIV_REJECT) {
                            Object[] options = {"Skip this note",
                                "Skip this and all further notes with errors",
                                "Abort all"};
                            int n = JOptionPane.showOptionDialog(this,
                                    privErr.errMsg,
                                    "Note privilege error",
                                    JOptionPane.YES_NO_CANCEL_OPTION,
                                    JOptionPane.QUESTION_MESSAGE,
                                    null,
                                    options,
                                    options[0]);
                            if (n == 2) {
                                throw new NoteException("Operation canceled by user.");
                            }
                            if (n == 1) {
                                skipAllErrors = true;
                            }
                            for (NotePathIndex npind : privErr.errInds) {
                                deleteNotes[npind.noteInd] = true;
                            }
                        } else if (privErr.priv == NotePrivileges.PRIV_ALLOW_ONE) {
                            JPanel panel = new JPanel();
                            GridBagLayout layout = new GridBagLayout();
                            panel.setLayout(layout);
                            GridBagConstraints constraints = new GridBagConstraints();
                            JLabel errLabel = new JLabel(privErr.errMsg);
                            constraints.gridwidth = GridBagConstraints.REMAINDER;
                            constraints.gridx = 0;
                            constraints.gridy = 0;
                            panel.add(errLabel, constraints);
                            ButtonGroup group = new ButtonGroup();
                            constraints.gridy = GridBagConstraints.RELATIVE;
                            int numInds = privErr.errInds.length;
                            JRadioButton[] buttons = new JRadioButton[numInds];
                            for (int i = 0; i < numInds; i++) {
                                NotePathIndex errInd = privErr.errInds[i];
                                String path = noteList.get(errInd.noteInd).getPaths().get(errInd.pathInd).getURI().toString();
                                JRadioButton button = new JRadioButton(path);
                                panel.add(button, constraints);
                                group.add(button);
                                buttons[i] = button;
                            }
                            Object[] options = {"Keep the selected note",
                                "Skip this and all further notes with errors",
                                "Abort all"};
                            int n = JOptionPane.showOptionDialog(this,
                                    panel,
                                    "Note privilege error",
                                    JOptionPane.YES_NO_CANCEL_OPTION,
                                    JOptionPane.QUESTION_MESSAGE,
                                    null,
                                    options,
                                    options[0]);
                            if (n == 2) {
                                throw new NoteException("Operation canceled by user.");
                            }
                            if (n == 1) {
                                skipAllErrors = true;
                                for (NotePathIndex npind : privErr.errInds) {
                                    deleteNotes[npind.noteInd] = true;
                                }
                            }
                            if (n == 0 || n == 1) {
                                for (int i = 0; i < numInds; i++) {
                                    NotePathIndex errInd = privErr.errInds[i];
                                    if (buttons[i].isSelected()) {
                                        continue; // keeping, so nothing to do
                                    }
                                    deletePaths.add(errInd);
                                }
                            }
                        }
                    }
                }
                Iterator<NotePathIndex> npiter = deletePaths.descendingIterator();
                while (npiter.hasNext()) {
                    NotePathIndex npind = npiter.next();
                    List<URIWithType> pathList = noteList.get(npind.noteInd).getPaths();
                    pathList.remove(npind.pathInd);
                    if (pathList.isEmpty()) {
                        deleteNotes[npind.noteInd] = true;
                    }
                }
                int numNotes = noteList.size();
                for (int i = numNotes - 1; i >= 0; i--) {
                    if (deleteNotes[i]) {
                        noteList.remove(i);
                    }
                }
                NoteList newNoteList = new NoteList();
                for (EditorNote note : noteList) {
                    if (writeChangesOnly && !note.isEdited()) {
                        continue;
                    }
                    newNoteList.add(note);
                }
                updater.addUpdater(target, null);
                target.putNoteList(newNoteList);
                updater.removeUpdater(target);
            } catch (NoteException e) {
                exceptionDialog(e);
                noteList = null;
            }
        }
        return noteList;
    }

    private void IOTypeStateChanged(JComponent comp, Object itemin) {
        String item = (String) itemin;
        CardLayout cl = (CardLayout) comp.getLayout();
        if (IOTYPE_HID.equals(item)) {
            cl.show(comp, "HID");
        } else {
            cl.show(comp, "File");
        }
    }

    private void _SourceTypeComboItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event__SourceTypeComboItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            IOTypeStateChanged(_SourceCards, evt.getItem());
        }
}//GEN-LAST:event__SourceTypeComboItemStateChanged

    private void _SourceURLButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__SourceURLButtonActionPerformed
        while (true) {
            _FileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
            Object selected = _SourceURL.getSelectedItem();
            if (selected != null) {
                File initdir = new File(selected.toString());
                _FileChooser.setCurrentDirectory(initdir);
            }
            int returnVal = _FileChooser.showOpenDialog(this);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = _FileChooser.getSelectedFile();
                String outputDir = file.getAbsolutePath();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, "Error: file doesn't exist!.", "Error", JOptionPane.ERROR_MESSAGE);
                    continue;
                }
                boolean found = false;
                for (int i = 0; i < _SourceURL.getItemCount(); i++) {
                    if (outputDir.equals(_SourceURL.getItemAt(i))) {
                        found = true;
                        _SourceURL.setSelectedIndex(i);
                    }
                }
                if (!found) {
                    _SourceURL.insertItemAt(makeObj(outputDir), 0);
                    _SourceURL.setSelectedIndex(0);
                }
                break;
            } else if (returnVal == JFileChooser.CANCEL_OPTION) {
                break;
            }
        }
}//GEN-LAST:event__SourceURLButtonActionPerformed

    private void _TargetFileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__TargetFileButtonActionPerformed
        while (true) {
            _FileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
            Object selected = _TargetURL.getSelectedItem();
            if (selected != null) {
                File initdir = new File(selected.toString());
                _FileChooser.setCurrentDirectory(initdir);
            }
            int returnVal = _FileChooser.showOpenDialog(this);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = _FileChooser.getSelectedFile();
                String outputFile = file.getAbsolutePath();
                boolean found = false;
                for (int i = 0; i < _TargetURL.getItemCount(); i++) {
                    if (outputFile.equals(_TargetURL.getItemAt(i))) {
                        found = true;
                        _TargetURL.setSelectedIndex(i);
                    }
                }
                if (!found) {
                    _TargetURL.insertItemAt(makeObj(outputFile), 0);
                    _TargetURL.setSelectedIndex(0);
                }
                break;
            } else if (returnVal == JFileChooser.CANCEL_OPTION) {
                break;
            }
        }
}//GEN-LAST:event__TargetFileButtonActionPerformed

    private void _TargetTypeComboItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event__TargetTypeComboItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            IOTypeStateChanged(_TargetCards, evt.getItem());
        }
    }//GEN-LAST:event__TargetTypeComboItemStateChanged

    private void _SourceReadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__SourceReadButtonActionPerformed
        _SourceReadButton.setEnabled(false);
        _TargetWriteChangesButton.setEnabled(false);
        _TargetWriteAllButton.setEnabled(false);
        if (_SourceReadButton.getText().equals(org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceReadButton-cancel.text"))) {
            if (_readWorker != null) {
                _readWorker.cancel(true);
                _SourceProgressMessage.setText("Operation canceled by user.");
                _SourceProgressMessage2.setText("");
                _readWorker = null;
            }
            _SourceReadButtonActionFinished(null);
            return;
        }
        _SourceMsgLabel.setText("");
        final String type = (String) _SourceTypeCombo.getSelectedItem();
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        final SwingWorker<EditorNoteList, Void> worker = new SwingWorker<EditorNoteList, Void>() {

            @Override
            protected EditorNoteList doInBackground() throws Exception {
                EditorNoteList notelist = new EditorNoteList();
                String uristr = null;
                URI baseURI = null;
                String noteFileName = null;
                _upUsername.setText(_SourceHIDUsername.getText());
                _upPassword.setText(new String(_SourceHIDPassword.getPassword()));
                if (IOTYPE_HID.equals(type)) {
                    Object selectedURL = _SourceHIDURL.getSelectedItem();
                    if (selectedURL == null) {
                        exceptionDialog(new NoteException("Source file field is empty!"));
                    }
                    uristr = selectedURL.toString();
                } else {
                    Object selectedFile = _SourceURL.getSelectedItem();
                    if (selectedFile == null) {
                        exceptionDialog(new NoteException("Source file field is empty!"));
                    }
                    uristr = selectedFile.toString();
                    Object selectedBase = _SourceBaseURL.getSelectedItem();
                    if (selectedBase == null) {
                        baseURI = null;
                    } else {
                        baseURI = new URI(selectedBase.toString());
                    }
                    Object selectedNoteFileName = _SourceNoteFileName.getSelectedItem();
                    if (selectedNoteFileName == null) {
                        noteFileName = null;
                    } else {
                        noteFileName = selectedNoteFileName.toString();
                        if ("".equals(noteFileName)) {
                            noteFileName = null;
                        }
                    }
                }
                URI uri = new URI(uristr);
                if (IOTYPE_CIGAL.equals(type) || IOTYPE_RAW_HIERARCHY.equals(type)) {
                    if (uri.getScheme() != null && "file".equals(uri.getScheme())) {
                        ExceptionDialog.show(null, new NoteException("Source input path/URI field should be a local directory, but has scheme: " + uri.getScheme()));
                    }
                }
                if (IOTYPE_RAW_HIERARCHY.equals(type)) {
                    if (baseURI != null && baseURI.getScheme() != null && "file".equals(baseURI.getScheme())) {
                        ExceptionDialog.show(null, new NoteException("Source base path/URI field should be a local directory, but has scheme: " + uri.getScheme()));
                    }
                }
                URI replaceRoot = null;
                Object selectedReplaceRoot = _SourceReplaceRoot.getSelectedItem();
                if (selectedReplaceRoot != null) {
                    replaceRoot = new URI(selectedReplaceRoot.toString());
                }
                ArrayList<String> errMsgs = new ArrayList<String>();
                _sourceProgressUpdater.removeAllUpdaters();
                addNoteListFromSource(notelist, errMsgs, null, type, new URI(uristr), baseURI, replaceRoot, noteFileName, _SourceHIDUsername.getText(), _sourceProgressUpdater);
                if (!errMsgs.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (String errMsg : errMsgs) {
                        sb.append(errMsg).append("\n");
                    }
                    ExceptionDialog.show(null, new Exception("Errors reading notes:\n" + sb.toString()));
                }
                return notelist;
            }
        };
        worker.addPropertyChangeListener(new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    EditorNoteList noteList = null;
                    try {
                        noteList = worker.get();
                    } catch (CancellationException e) {
                        // don't pass to user
                    } catch (Exception e) {
                        ExceptionDialog.show(null, e);
                    }
                    _SourceReadButtonActionFinished(noteList);
                }
            }
        });
        _readWorker = worker;
        worker.execute();
        org.openide.awt.Mnemonics.setLocalizedText(_SourceReadButton, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceReadButton-cancel.text")); // NOI18N
        _SourceReadButton.setEnabled(true);
    }

    private void _SourceReadButtonActionFinished(EditorNoteList noteList) {
        setCursor(null);
        try {
            if (noteList != null) {
                if (_noteList != null) {
                    _gcont.getContent().remove(_noteList);
                }
                _noteList = noteList;
                _gcont.getContent().add(_noteList);
            }
        } catch (RuntimeException e) {
            throw e;
        } finally {
            org.openide.awt.Mnemonics.setLocalizedText(_SourceReadButton, org.openide.util.NbBundle.getMessage(IOTopComponent.class, "IOTopComponent._SourceReadButton.text")); // NOI18N
            _SourceReadButton.setEnabled(true);
            _TargetWriteChangesButton.setEnabled(true);
            _TargetWriteAllButton.setEnabled(true);
        }
    }//GEN-LAST:event__SourceReadButtonActionPerformed

    private void _TargetWriteAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__TargetWriteAllButtonActionPerformed
        writeToTarget(false);
    }

    private void writeToTarget(boolean writeChangesOnly_) {
        final boolean writeChangesOnly = writeChangesOnly_;
        final String type = (String) _TargetTypeCombo.getSelectedItem();
        _SourceReadButton.setEnabled(false);
        _TargetWriteAllButton.setEnabled(false);
        _TargetWriteChangesButton.setEnabled(false);
        _TargetMsgLabel.setText("");
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        final SwingWorker<EditorNoteList, Void> worker = new SwingWorker<EditorNoteList, Void>() {

            @Override
            protected EditorNoteList doInBackground() throws Exception {
                URI uri = null;
                URI basePath = null;
                if (IOTYPE_HID.equals(type)) {
                    _upUsername.setText(_TargetHIDUsername.getText());
                    _upPassword.setText(new String(_TargetHIDPassword.getPassword()));
                    Object obj = _TargetHIDURL.getSelectedItem();
                    if (obj == null) {
                        exceptionDialog(new NoteException("Target HID URL is empty!"));
                    }
                    uri = new URI(obj.toString());
                } else {
                    Object selectedFile = _TargetURL.getSelectedItem();
                    if (selectedFile == null) {
                        exceptionDialog(new NoteException("Target URI is empty!"));
                    }
                    uri = new URI(selectedFile.toString());
                    if (uri == null || (uri.getScheme() != null && !"file".contains(uri.getScheme()))) {
                        exceptionDialog(new NoteException("For non-HID targets, target URI must be a local path and/or have a 'file:' scheme!"));
                        return null;
                    }
                    File file = new File(uri.getPath());
                    if (!IOTYPE_RAW_HIERARCHY.equals(type) && file.exists()) {
                        Object[] options = {"Yes", "No"};
                        int returnVal = JOptionPane.showOptionDialog(IOTopComponent.this, "File '" + file.toString() + "' exists.\nWould you like to overwrite it?", "File exists", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[1]);
                        if (returnVal == 1) {
                            return null;
                        }
                    }
                    Object selectedBase = _TargetBaseURL.getSelectedItem();
                    if (selectedBase == null) {
                        basePath = null;
                    } else {
                        basePath = new URI(selectedBase.toString());
                    }
                }
                _targetProgressUpdater.removeAllUpdaters();
                return putNoteListToTarget(_noteList, type, uri, basePath, writeChangesOnly, _targetProgressUpdater);
            }
        };
        worker.addPropertyChangeListener(
                new PropertyChangeListener() {

                    public void propertyChange(PropertyChangeEvent evt) {
                        String propName = evt.getPropertyName();
                        if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                            EditorNoteList noteList = null;
                            try {
                                noteList = worker.get();
                            } catch (Exception e) {
                                exceptionDialog(e);
                            }
                            _TargetWriteButtonActionFinished(noteList);
                        }
                    }
                });

        worker.execute();
    }//GEN-LAST:event__TargetWriteAllButtonActionPerformed

    private void _TargetWriteButtonActionFinished(EditorNoteList noteList) {
        setCursor(null);
        _SourceReadButton.setEnabled(true);
        _TargetWriteAllButton.setEnabled(true);
        _TargetWriteChangesButton.setEnabled(true);
    }

    private void _TargetWriteChangesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__TargetWriteChangesButtonActionPerformed
        writeToTarget(true);
    }//GEN-LAST:event__TargetWriteChangesButtonActionPerformed

    private void exceptionDialog(Exception e) {
        ExceptionDialog.show(this, e);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox _CreateItemsCheckBox;
    private javax.swing.JFileChooser _FileChooser;
    private javax.swing.JPanel _IOPanel;
    private javax.swing.JComboBox _SourceBaseURL;
    private javax.swing.JLabel _SourceBaseURLLabel;
    private javax.swing.JPanel _SourceButtonPanel;
    private javax.swing.JPanel _SourceCards;
    private javax.swing.JPanel _SourceFileCard;
    private javax.swing.JPanel _SourceHIDCard;
    private javax.swing.JPasswordField _SourceHIDPassword;
    private javax.swing.JLabel _SourceHIDPasswordLabel;
    private javax.swing.JComboBox _SourceHIDURL;
    private javax.swing.JLabel _SourceHIDURLLabel;
    private javax.swing.JTextField _SourceHIDUsername;
    private javax.swing.JLabel _SourceHIDUsernameLabel;
    private javax.swing.JLabel _SourceLabel;
    private javax.swing.JLabel _SourceMsgLabel;
    private javax.swing.JComboBox _SourceNoteFileName;
    private javax.swing.JLabel _SourceNoteFileNameLabel;
    private javax.swing.JPanel _SourcePanel;
    private javax.swing.JProgressBar _SourceProgressBar;
    private javax.swing.JTextArea _SourceProgressMessage;
    private javax.swing.JTextArea _SourceProgressMessage2;
    private javax.swing.JPanel _SourceProgressPanel;
    private javax.swing.JButton _SourceReadButton;
    private javax.swing.JComboBox _SourceReplaceRoot;
    private javax.swing.JLabel _SourceReplaceRootLabel;
    private javax.swing.JComboBox _SourceTypeCombo;
    private javax.swing.JComboBox _SourceURL;
    private javax.swing.JButton _SourceURLButton;
    private javax.swing.JLabel _SourceURLLabel;
    private javax.swing.JLabel _TargetBasePathLabel;
    private javax.swing.JComboBox _TargetBaseURL;
    private javax.swing.JPanel _TargetButtonPanel;
    private javax.swing.JPanel _TargetCards;
    private javax.swing.JButton _TargetFileButton;
    private javax.swing.JPanel _TargetFileCard;
    private javax.swing.JLabel _TargetFileLabel;
    private javax.swing.JPanel _TargetHIDCard;
    private javax.swing.JPasswordField _TargetHIDPassword;
    private javax.swing.JLabel _TargetHIDPasswordLabel;
    private javax.swing.JComboBox _TargetHIDURL;
    private javax.swing.JLabel _TargetHIDURLLabel;
    private javax.swing.JTextField _TargetHIDUsername;
    private javax.swing.JLabel _TargetHIDUsernameLabel;
    private javax.swing.JLabel _TargetLabel;
    private javax.swing.JLabel _TargetMsgLabel;
    private javax.swing.JComboBox _TargetNoteFileName;
    private javax.swing.JLabel _TargetNoteFileNameLabel;
    private javax.swing.JPanel _TargetPanel;
    private javax.swing.JProgressBar _TargetProgressBar;
    private javax.swing.JTextArea _TargetProgressMessage;
    private javax.swing.JTextArea _TargetProgressMessage2;
    private javax.swing.JPanel _TargetProgressPanel;
    private javax.swing.JComboBox _TargetTypeCombo;
    private javax.swing.JComboBox _TargetURL;
    private javax.swing.JButton _TargetWriteAllButton;
    private javax.swing.JButton _TargetWriteChangesButton;
    private javax.swing.JPanel _TopPanel;
    private javax.swing.JScrollPane _TopScrollPane;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link #findInstance}.
     */
    public static synchronized IOTopComponent getDefault() {
        if (instance == null) {
            instance = new IOTopComponent();
        }
        return instance;
    }

    /**
     * Obtain the IOTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized IOTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(IOTopComponent.class.getName()).warning(
                    "Cannot find " + PREFERRED_ID + " component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof IOTopComponent) {
            return (IOTopComponent) win;
        }
        Logger.getLogger(IOTopComponent.class.getName()).warning(
                "There seem to be multiple components with the '" + PREFERRED_ID
                + "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }

    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }

    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    Object readProperties(java.util.Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    @Override
    protected String preferredID() {
        return PREFERRED_ID;
    }
}
