/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.io;

import java.io.File;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.nbirn.fbirn.utilities.AppendOnlyDocument;
import org.nbirn.fbirn.utilities.AppendOnlyFileContent;
import org.nbirn.fbirn.utilities.AppendOnlyStyledEditorKit;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.util.lookup.ServiceProvider;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(dtd = "-//org.nbirn.fbirn.notecollector.gui.io//LogOutput//EN",
autostore = false)
@TopComponent.Description(preferredID = "LogOutputTopComponent",
//iconBase="SET/PATH/TO/ICON/HERE", 
persistenceType = TopComponent.PERSISTENCE_ALWAYS)
@TopComponent.Registration(mode = "output", openAtStartup = true)
@ActionID(category = "Window", id = "org.nbirn.fbirn.notecollector.gui.io.LogOutputTopComponent")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(displayName = "#CTL_LogOutputAction",
preferredID = "LogOutputTopComponent")
@ServiceProvider(service = LogOutputTopComponent.class)
public final class LogOutputTopComponent extends TopComponent {

    Handler _handler = null;
    Level _defaultLevel = null;
    AppendOnlyStyledEditorKit _editorKit = null;

    public LogOutputTopComponent() {
        initComponents();
        File logFile = new File(new File(System.getProperty("user.dir")).getParentFile(), "_noteCollectorLogOutput.txt");
        logFile.delete();
        //_editorKit = new AppendOnlyFileEditorKit(logFile);
        //_LogOutputTextPane.setEditorKit(_editorKit);
        //_LogOutputTextPane.setDocument(_editorKit.createDefaultDocument());
        _LogOutputTextArea.setDocument(new AppendOnlyDocument(new AppendOnlyFileContent(logFile)));
        //_LogOutputTextPane.setDocument(new DefaultStyledDocument(new AppendOnlyFileContent(logFile), new StyleContext()));
        setName(NbBundle.getMessage(LogOutputTopComponent.class, "CTL_LogOutputTopComponent"));
        setToolTipText(NbBundle.getMessage(LogOutputTopComponent.class, "HINT_LogOutputTopComponent"));
        try {
            setDebugLevel();
        } catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    void setDebugLevel() throws IOException {
        LogManager logManager = LogManager.getLogManager();
        String levelStr = _DebugLevelComboBox.getSelectedItem().toString();
        System.clearProperty("java.util.logging.config.class");
        System.setProperty("org.nbirn.fbirn.notes.level", levelStr);
        System.setProperty("org.nbirn.fbirn.notecollector.level", levelStr);
        //System.setProperty("org.nbirn.fbirn.notes.handlers", "org.nbirn.fbirn.notecollector.gui.io.TextAreaHandler");
        //System.setProperty("org.nbirn.fbirn.notecollector.handlers", "org.nbirn.fbirn.notecollector.gui.io.TextAreaHandler");
        System.setProperty("java.util.logging.config.class", "org.nbirn.fbirn.notecollector.gui.io.LogConfig");
        logManager.readConfiguration();
        //Logger.getLogger("").addHandler(new EditorKitHandler(_editorKit, new SimpleFormatter()));
        //Logger.getLogger("").addHandler(new TextPaneHandler(_LogOutputTextPane, new SimpleFormatter()));
        Logger.getLogger("").addHandler(new TextAreaHandler(_LogOutputTextArea, new SimpleFormatter()));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        _LogOutputScrollPane = new javax.swing.JScrollPane();
        _LogOutputTextArea = new javax.swing.JTextArea();
        _SpacerPanel = new javax.swing.JPanel();
        _DebugLevelLabel = new javax.swing.JLabel();
        _DebugLevelComboBox = new javax.swing.JComboBox();
        _ClearButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        _LogOutputTextArea.setColumns(20);
        _LogOutputTextArea.setEditable(false);
        _LogOutputTextArea.setRows(5);
        _LogOutputScrollPane.setViewportView(_LogOutputTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(_LogOutputScrollPane, gridBagConstraints);

        _SpacerPanel.setLayout(new java.awt.GridBagLayout());

        _DebugLevelLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_DebugLevelLabel, org.openide.util.NbBundle.getMessage(LogOutputTopComponent.class, "LogOutputTopComponent._DebugLevelLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        _SpacerPanel.add(_DebugLevelLabel, gridBagConstraints);

        _DebugLevelComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        _DebugLevelComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "SEVERE", "WARNING", "INFO", "FINE", "FINER", "FINEST" }));
        _DebugLevelComboBox.setSelectedIndex(3);
        _DebugLevelComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _DebugLevelComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 20);
        _SpacerPanel.add(_DebugLevelComboBox, gridBagConstraints);

        _ClearButton.setFont(new java.awt.Font("Dialog", 0, 12));
        org.openide.awt.Mnemonics.setLocalizedText(_ClearButton, org.openide.util.NbBundle.getMessage(LogOutputTopComponent.class, "LogOutputTopComponent._ClearButton.text")); // NOI18N
        _ClearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _ClearButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        _SpacerPanel.add(_ClearButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(_SpacerPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void _ClearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__ClearButtonActionPerformed
        _LogOutputTextArea.setText("");
    }//GEN-LAST:event__ClearButtonActionPerformed

    private void _DebugLevelComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__DebugLevelComboBoxActionPerformed
        try {
            setDebugLevel();
        } catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }//GEN-LAST:event__DebugLevelComboBoxActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton _ClearButton;
    private javax.swing.JComboBox _DebugLevelComboBox;
    private javax.swing.JLabel _DebugLevelLabel;
    private javax.swing.JScrollPane _LogOutputScrollPane;
    private javax.swing.JTextArea _LogOutputTextArea;
    private javax.swing.JPanel _SpacerPanel;
    // End of variables declaration//GEN-END:variables

    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
}
