package org.nbirn.fbirn.notecollector.nodes;

import org.openide.nodes.ChildFactory;

public abstract class LevelChildFactory extends ChildFactory<String> {

    NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> _level = null;

    protected LevelChildFactory(NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> level) {
	_level = level;
    }

    public NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> getLevel() {
	return _level;
    }

    public void addNote(EditorNote note) {
	_level.addNote(note);
	refresh(false);
    }

    public void removeNote(EditorNote note) {
	_level.removeNote(note);
	refresh(false);
    }

    public void replaceNote(EditorNote oldNote, EditorNote newNote) {
	_level.replaceNote(oldNote, newNote);
	refresh(false);
    }

    protected abstract LevelChildFactory getSubChildFactory(NoteLevel level);
}
