/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * NewNotePanel.java
 *
 * Created on Mar 30, 2011, 10:55:23 AM
 */
package org.nbirn.fbirn.notecollector.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.nbirn.fbirn.notecollector.gui.shared.CredentialKeeper;
import org.nbirn.fbirn.notecollector.gui.shared.GlobalContainer;
import org.nbirn.fbirn.notes.NoteException;
import org.nbirn.fbirn.notes.NotePrivileges;
import org.nbirn.fbirn.utilities.CanceledException;
import org.nbirn.fbirn.utilities.ExceptionDialog;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ServiceProvider;

/**
 *
 * @author gadde
 */
@ServiceProvider(service = NewNotePanel.class)
public class NewNotePanel extends JPanel implements LookupListener, ActionListener {

    private NotePrivileges _privs = null;
    private GlobalContainer _gcont = null;
    private Lookup.Result<NotePrivileges> _privResult = null;
    private CredentialKeeper _credKeeper = null;

    /** Creates new form NewNotePanel */
    public NewNotePanel() {
        initComponents();

        _credKeeper = Lookup.getDefault().lookup(CredentialKeeper.class);

        _gcont = Lookup.getDefault().lookup(GlobalContainer.class);

        _privResult = _gcont.getLookup().lookupResult(NotePrivileges.class);
        resultChanged(new LookupEvent(_privResult));
        _privResult.addLookupListener(this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        _NamespaceLabel = new javax.swing.JLabel();
        _Namespace = new javax.swing.JComboBox();
        _NameLabel = new javax.swing.JLabel();
        _Name = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        _NamespaceLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _NamespaceLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        _NamespaceLabel.setText(org.openide.util.NbBundle.getMessage(NewNotePanel.class, "NewNotePanel._NamespaceLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(_NamespaceLabel, gridBagConstraints);

        _Namespace.setEditable(true);
        _Namespace.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(_Namespace, gridBagConstraints);

        _NameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _NameLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        _NameLabel.setText(org.openide.util.NbBundle.getMessage(NewNotePanel.class, "NewNotePanel._NameLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(_NameLabel, gridBagConstraints);

        _Name.setEditable(true);
        _Name.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(_Name, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox _Name;
    private javax.swing.JLabel _NameLabel;
    private javax.swing.JComboBox _Namespace;
    private javax.swing.JLabel _NamespaceLabel;
    // End of variables declaration//GEN-END:variables

    public String getNoteNamespace() {
        return _Namespace.getSelectedItem().toString();
    }

    public String getNoteName() {
        return _Name.getSelectedItem().toString();
    }

    private String getUser() {
        GSSCredential cred = null;
        String user = null;
        try {
            if (_credKeeper != null) {
                cred = _credKeeper.getCredential();
            }
        } catch (CanceledException e) {
            return null;
        } catch (NoteException e) {
            ExceptionDialog.show(null, e);
            return null;
        }
        if (cred != null) {
            try {
                user = cred.getName().toString();
            } catch (GSSException e) {
                ExceptionDialog.show(null, e);
                return null;
            }
        }
        return user;
    }

    private void changedPrivs() {
        if (_privs == null) {
            return;
        }
        String user = getUser();
        if (user == null) {
            return;
        }
        _Namespace.removeActionListener(this);
        _Namespace.removeAllItems();
        Set<String> namespaces = new TreeSet<String>();
        Iterator<NotePrivileges.Entry> iter = _privs.iterator();
        while (iter.hasNext()) {
            NotePrivileges.Entry e = iter.next();
            for (NotePrivileges.UserPrivilege up : e.privs) {
                if (up.user == null || up.user.equals(user)) {
                    if (up.priv == NotePrivileges.PRIV_REJECT) {
                        break;
                    }
                    if (up.priv != NotePrivileges.PRIV_UNKNOWN) {
                        namespaces.add(e.namespace);
                    }
                }
            }
        }
        for (String ns : namespaces) {
            _Namespace.addItem(ns);
        }
        actionPerformed(new ActionEvent(_Namespace, -1, null));
        _Namespace.addActionListener(this);
    }

    @Override
    public void resultChanged(LookupEvent le) {
        if (le.getSource() == _privResult) {
            Collection<? extends NotePrivileges> c = _privResult.allInstances();
            if (!c.isEmpty()) {
                _privs = c.iterator().next();
                changedPrivs();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == _Namespace) {
            if (_privs == null) {
                return;
            }
            String user = getUser();
            if (user == null) {
                return;
            }
            String ns = _Namespace.getSelectedItem().toString();
            _Name.removeAllItems();
            Set<String> names = new TreeSet<String>();
            Iterator<NotePrivileges.Entry> iter = _privs.iterator();
            while (iter.hasNext()) {
                NotePrivileges.Entry e = iter.next();
                if (e.namespace != null && !e.namespace.equals(ns)) {
                    continue;
                }
                for (NotePrivileges.UserPrivilege up : e.privs) {
                    if (up.user == null || up.user.equals(user)) {
                        if (e.name == null) {
                            if (up.priv == NotePrivileges.PRIV_REJECT) {
                                // no further entries for this user and namespace will match 
                                break;
                            } else {
                                continue;
                            }
                        }
                        if (up.priv != NotePrivileges.PRIV_UNKNOWN) {
                            names.add(e.name);
                        }
                    }
                }
            }
            for (String name : names) {
                _Name.addItem(name);
            }
        }
    }
}
