/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes;

import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import java.util.HashMap;
import org.nbirn.fbirn.notes.Note;

/**
 *
 * @author gadde
 */
public class NoteLevel<I, K extends Comparable, CK extends Comparable, CV> extends HashMap<CK, CV> {

    private NoteLevel _parent = null;
    private I _ID = null;
    private String _name = null;
    private K _key = null;
    private EditorNoteList _notes = null;

    public NoteLevel(NoteLevel parent, I ID, String name, K key) {
        _parent = parent;
        _ID = ID;
        _name = name;
        _key = key;
        _notes = new EditorNoteList();
    }

    public I getID() {
        return _ID;
    }

    public K getKey() {
        return _key;
    }

    public String getName() {
        return _name;
    }

    public NoteLevel getParent() {
        return _parent;
    }

    public void addNote(EditorNote note) {
        addNote(note, null);
    }

    public void addNote(EditorNote note, String ID) {
        if (note.getName() == Note.NULLVALUE) {
            // just a placeholder -- don't add
            return;
        }
        _notes.add(note);
    }

    public EditorNoteList getNotes() {
        return _notes;
    }

    public void removeNote(EditorNote note) {
        _notes.remove(note);
    }

    public void replaceNote(EditorNote oldNote, EditorNote newNote) {
        int ind = _notes.indexOf(oldNote);
        if (ind != -1) {
            _notes.set(ind, newNote);
        }
    }
}
