/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes.hierarchy;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import org.nbirn.fbirn.notecollector.nodes.LevelChildFactory;
import org.nbirn.fbirn.notecollector.nodes.NoteLevel;
import org.openide.nodes.Node;

/**
 *
 * @author gadde
 */
public abstract class HierarchyLevelChildFactory extends LevelChildFactory {

    public HierarchyLevelChildFactory(NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> level) {
        super(level);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected boolean createKeys(List<String> keys) {
        NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> level = getLevel();
        EditorNoteList noteList = level.getNotes();
        int numNotes = noteList.size();
        for (int i = 0; i < numNotes; i++) {
            keys.add("N" + String.valueOf(i));
        }
        List<Comparable> sortedKeys = new ArrayList<Comparable>();
        for (Comparable key : level.keySet()) {
            sortedKeys.add(key);
        }
        Collections.<Comparable>sort(sortedKeys);
        for (Object s : sortedKeys) {
            keys.add("S" + s.toString());
        }
        return true;
    }

    @Override
    protected Node createNodeForKey(String t) {
        HierarchyNoteLevel level = (HierarchyNoteLevel) getLevel();
        String keyStr = t.substring(1);
        if (t.startsWith("N")) {
            int noteInd = Integer.parseInt(keyStr);
            try {
                return new HierarchyNoteNode("Note " + keyStr, level.getNotes().get(noteInd), level);
            } catch (IntrospectionException e) {
                // skip
            }
        } else if (t.startsWith("S")) {
            HierarchyNoteLevel sublevel = (HierarchyNoteLevel) (level.get(keyStr));
            try {
                return new HierarchyLevelNode(sublevel, getSubChildFactory(sublevel));
            } catch (IntrospectionException e) {
                // skip
            }
        }
        return null;
    }
}
