/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes.hierarchy;

import java.io.File;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nbirn.fbirn.notecollector.nodes.EditorNote;
import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import org.nbirn.fbirn.notecollector.nodes.LevelChildFactory;
import org.nbirn.fbirn.notecollector.nodes.NoteLevel;
import org.nbirn.fbirn.notes.ExperimentHierarchyItem;
import org.nbirn.fbirn.notes.ExperimentHierarchyModel;
import org.nbirn.fbirn.notes.Note;
import org.nbirn.fbirn.notes.NoteException;
import org.nbirn.fbirn.notes.URIWithType;
import org.openide.nodes.Children;

/**
 *
 * @author gadde
 */
public class HierarchyNodeFactories {

    private static class SeriesChildFactory extends HierarchyLevelChildFactory {

        public SeriesChildFactory(HierarchyLevels.Series level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel level) {
            throw new UnsupportedOperationException("Series has no children!");
        }
    }

    private static class StudyChildFactory extends HierarchyLevelChildFactory {

        public StudyChildFactory(HierarchyLevels.Study level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return new SeriesChildFactory((HierarchyLevels.Series) sublevel);
        }
    }

    private static class VisitChildFactory extends HierarchyLevelChildFactory {

        public VisitChildFactory(HierarchyLevels.Visit level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return new StudyChildFactory((HierarchyLevels.Study) sublevel);
        }
    }

    private static class SubjectChildFactory extends HierarchyLevelChildFactory {

        public SubjectChildFactory(HierarchyLevels.Subject level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return new VisitChildFactory((HierarchyLevels.Visit) sublevel);
        }
    }

    private static class ExperimentChildFactory extends HierarchyLevelChildFactory {

        public ExperimentChildFactory(HierarchyLevels.Project level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return new SubjectChildFactory((HierarchyLevels.Subject) sublevel);
        }
    }

    private static class HierarchyRootChildFactory extends HierarchyLevelChildFactory {

        public HierarchyRootChildFactory(HierarchyLevels.Root level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return new ExperimentChildFactory((HierarchyLevels.Project) sublevel);
        }
    }

    public static Children createEmptyChildren() {
        return Children.LEAF;
    }

    public static Children createHierarchyRootChildren(EditorNoteList notelist, ExperimentHierarchyModel model) {
        final DecimalFormat df4 = new DecimalFormat("0000");
        final DecimalFormat df12 = new DecimalFormat("000000000000");
        HierarchyLevels.Root top = new HierarchyLevels.Root();
        for (EditorNote note : notelist) {
            boolean validNote = (note.getName() != Note.NULLVALUE);
            Map<ExperimentHierarchyItem, List<URIWithType>> items = new HashMap<ExperimentHierarchyItem, List<URIWithType>>();
            Iterator<URIWithType> pathiter = note.getPaths().iterator();
            while (pathiter.hasNext()) {
                URIWithType uriwt = pathiter.next();
                try {
                    ExperimentHierarchyItem item = model.pathToItem(uriwt);
                    List<URIWithType> pathList = null;
                    if (items.containsKey(item)) {
                        pathList = items.get(item);
                    } else {
                        pathList = new ArrayList<URIWithType>();
                        items.put(item, pathList);
                    }
                    pathList.add(uriwt);
                } catch (NoteException e) {
                    // just skip it
                }
            }
            for (Map.Entry<ExperimentHierarchyItem, List<URIWithType>> entry : items.entrySet()) {
                ExperimentHierarchyItem item = entry.getKey();
                if (item.expName == null || item.expID == null) {
                    continue;
                }
                EditorNote newNote = null;
                if (validNote) {
                    List<URIWithType> pathList = entry.getValue();
                    newNote = new EditorNote(note.cloneWithoutFiles());
                    newNote.setPaths(pathList);
                }
                String expKey = item.expName + "__" + df4.format(item.expID.longValue());
                HierarchyLevels.Project exp = null;
                HierarchyLevels.Subject subj = null;
                HierarchyLevels.Visit visit = null;
                HierarchyLevels.Study study = null;
                HierarchyLevels.Series series = null;
                if (top.containsKey(expKey)) {
                    exp = top.get(expKey);
                } else {
                    exp = new HierarchyLevels.Project(top, item.expID, item.expName, expKey);
                    top.put(expKey, exp);
                }
                if (item.subjID == null) {
                    if (validNote) {
                        exp.addNote(newNote);
                    }
                    continue;
                }
                String subjKey = item.subjID;
                if (exp.containsKey(subjKey)) {
                    subj = exp.get(subjKey);
                } else {
                    subj = new HierarchyLevels.Subject(exp, item.subjID, (item.subjName == null ? item.subjID : item.subjName), subjKey);
                    exp.put(subjKey, subj);
                }
                if (item.visitID == null) {
                    if (validNote) {
                        subj.addNote(newNote);
                    }
                    continue;
                }
                String visitKey = df4.format(item.visitID.longValue());
                if (item.visitSiteID != null) {
                    visitKey = item.visitSiteID + "__" + visitKey;
                }
                if (item.visitName != null) {
                    visitKey = item.visitName + "__" + visitKey;
                }
                if (subj.containsKey(visitKey)) {
                    visit = subj.get(visitKey);
                } else {
                    visit = new HierarchyLevels.Visit(subj, item.visitID, item.visitName, visitKey);
                    subj.put(visitKey, visit);
                }
                if (item.studyID == null && (item.seriesName == null || item.seriesName.length() == 0)) {
                    if (validNote) {
                        visit.addNote(newNote);
                    }
                    continue;
                }
                String studyKey;
                if (item.studyID == null) {
                    studyKey = "(default study)";
                } else {
                    studyKey = df4.format(item.studyID.longValue());
                    if (item.studyName != null && item.studyName.length() > 0) {
                        studyKey = item.studyName + "__" + studyKey;
                    }
                }
                if (visit.containsKey(studyKey)) {
                    study = visit.get(studyKey);
                } else {
                    study = new HierarchyLevels.Study(visit, item.studyID, item.studyName, studyKey);
                    visit.put(studyKey, study);
                }
                if (item.seriesID == null && item.seriesName == null) {
                    if (validNote) {
                        study.addNote(newNote);
                    }
                    continue;
                }
                String seriesKey = item.seriesName;
                if (item.seriesName == null) {
                    seriesKey = "ID=" + item.seriesID;
                }
                if (study.containsKey(seriesKey)) {
                    series = study.get(seriesKey);
                } else {
                    series = new HierarchyLevels.Series(study, item.seriesID, item.seriesName, seriesKey);
                    study.put(item.seriesName, series);
                }
                if (validNote) {
                    series.addNote(new EditorNote(newNote));
                }
            }
        }
        return Children.create(new HierarchyRootChildFactory(top), false);
    }
}
