/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes.namebased;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nbirn.fbirn.notecollector.nodes.LevelChildFactory;
import org.nbirn.fbirn.notecollector.nodes.NoteLevel;
import org.openide.nodes.Node;

/**
 *
 * @author gadde
 */
public abstract class NameBasedLevelChildFactory extends LevelChildFactory {

    public NameBasedLevelChildFactory(NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> level) {
        super(level);
    }

    @Override
    protected boolean createKeys(List<String> keys) {
        NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> level = getLevel();
        ArrayList<Comparable> sortedKeys = new ArrayList<Comparable>(level.keySet());
        Collections.<Comparable>sort(sortedKeys);
        for (Object s : sortedKeys) {
            keys.add("S" + s.toString());
        }
        return true;
    }

    @Override
    protected Node createNodeForKey(String t) {
        NameBasedNoteLevel level = (NameBasedNoteLevel) getLevel();
        String keyStr = t.substring(1);
        if (t.startsWith("S")) {
            NameBasedNoteLevel sublevel = (NameBasedNoteLevel) (level.get(keyStr));
            try {
                return new NameBasedLevelNode(sublevel, getSubChildFactory(sublevel));
            } catch (IntrospectionException e) {
                // skip
            }
        }
        return null;
    }
}
