/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes.namebased;

import org.nbirn.fbirn.notecollector.nodes.ComparableVoid;
import org.nbirn.fbirn.notecollector.nodes.EditorNote;
import org.nbirn.fbirn.notes.URIWithType;

/**
 *
 * @author gadde
 */
public class NameBasedLevels {

    public static class Path extends NameBasedNoteLevel<URIWithType, ComparableVoid, Void> {

	EditorNote _note = null;

	public Path(NameBasedNoteLevel parent, URIWithType path) {
	    super(parent, path.getURI().toString(), path);
	}

	public void setNote(EditorNote note) {
	    _note = note;
	}

	public EditorNote getNote() {
	    return _note;
	}

	public URIWithType getPath() {
	    return getKey();
	}
    }

    public static class Name extends NameBasedNoteLevel<String, URIWithType, Path> {

	public Name(NameBasedNoteLevel parent, String key) {
	    super(parent, key, key);
	}
    }

    public static class Namespace extends NameBasedNoteLevel<String, String, Name> {

	public Namespace(NameBasedNoteLevel parent, String key) {
	    super(parent, key, key);
	}
    }

    public static class Root extends NameBasedNoteLevel<String, String, Namespace> {

	public Root() {
	    super(null, "", "");
	}
    }
}
