package org.nbirn.fbirn.notecollector.nodes.namebased;

import org.nbirn.fbirn.notecollector.nodes.EditorNote;
import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import org.nbirn.fbirn.notecollector.nodes.NoteLevel;
import org.nbirn.fbirn.notes.URIWithType;

public abstract class NameBasedNoteLevel<K extends Comparable, CK extends Comparable, CV> extends NoteLevel<Void, K, String, CV> {

    NameBasedNoteLevel _parent = null;

    protected NameBasedNoteLevel(NameBasedNoteLevel parent, String name, K key) {
	super(null, null, name, key);
	_parent = parent;
    }

    public CV put(URIWithType key, CV value) {
	return super.put(key.toString(), value);
    }

    @Override
    public EditorNoteList getNotes() {
	throw new UnsupportedOperationException("getNotes() is not supported on name-based levels");
    }

    @Override
    public void removeNote(EditorNote note) {
	throw new UnsupportedOperationException("removeNote() is not supported on name-based levels");
    }

    @Override
    public void replaceNote(EditorNote oldNote, EditorNote newNote) {
	throw new UnsupportedOperationException("replaceNote() is not supported on name-based levels");
    }

    @Override
    public void addNote(EditorNote note) {
	throw new UnsupportedOperationException("addNote() is not supported on name-based levels");
    }

    @Override
    public void addNote(EditorNote note, String ID) {
	throw new UnsupportedOperationException("addNote() is not supported on name-based levels");
    }

    @Override
    public NameBasedNoteLevel getParent() {
	return _parent;
    }
}
