// This file was automatically generated by:
//  ../../bin/GenerateCLP --logoFiles /scratch/gouttard/software/Slicer3/Resources/ITKLogo.h /scratch/gouttard/software/Slicer3/Applications/CLI/TensorRicianNoiseRemovalFilter.xml /scratch/gouttard/software/Slicer3-bin/Applications/CLI/TensorRicianNoiseRemovalFilterCLP.h
//
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string.h>

#include <itksys/ios/sstream>

#include "tclap/CmdLine.h"
#include "ModuleProcessInformation.h"

#ifdef WIN32
#define Module_EXPORT __declspec(dllexport)
#else
#define Module_EXPORT 
#endif

#ifdef main
// If main defined as a preprocessor symbol, redefine it to the expected entry point.
#undef main
#define main ModuleEntryPoint

extern "C" {
  Module_EXPORT char *GetXMLModuleDescription();
  Module_EXPORT int ModuleEntryPoint(int, char*[]);
  Module_EXPORT unsigned char *GetModuleLogo(int *width, int *height, int *pixel_size, unsigned long *bufferLength);
}
#endif

extern "C" {
Module_EXPORT char XMLModuleDescription[] = 
"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<executable>\n"
"  <category>Filtering</category>\n"
"  <title>Tensor smoothing filter in DTI</title>\n"
"  <description>\n"
"Runs a filter that smoothes tensor file in DTI\n"
"  </description>\n"
"\n"
"  <version>1.0</version>\n"
"  <documentation-url>http://www.na-mic.org/Wiki/index.php/Slicer3:Module:Rician_Noise_Removal</documentation-url>\n"
"  <license></license>\n"
"  <contributor>Saurav Basu, Tom Fletcher, Ross Whitaker</contributor>\n"
"\n"
"  <parameters>\n"
"    <label>Tensor Rician noise removal filter parameters</label>\n"
"    <description>\n"
"parameters for the filter\n"
"    </description>\n"
"    <integer-enumeration>\n"
"      <name>filterTypeId</name>\n"
"      <description>\n"
"      0: Euclidean Space filtering (tensors are treated as 6-d vectors)\n"
"      1: Log Space filtering (Fast and Simple Calculus on Tensors in the Log-Euclidean Framework)\n"
"      2: Riemannian Space Filtering(A Riemannian Framework for the Processing of Tensor-Valued Images)\n"
"      </description>\n"
"      <label>Filter type</label> \n"
"      <index>0</index>\n"
"      <default>2</default>\n"
"      <element>0</element>\n"
"      <element>1</element>\n"
"      <element>2</element>\n"
"    </integer-enumeration>\n"
"    <integer>\n"
"      <name>numIterationsVal</name>\n"
"      <description>\n"
"      Number of iterations you want to run the filter for.\n"
"      </description>\n"
"      <label>NumIterations</label> \n"
"      <index>1</index>\n"
"      <default>30</default>\n"
"    </integer>  \n"
"    <float>\n"
"      <name>timeStepVal</name>\n"
"      <description>\n"
"      This determines the step size in the gradient descent. It can be atmost 0.0625.\n"
"      </description>\n"
"      <label>Time step</label> \n"
"      <index>2</index>\n"
"      <default>0.01</default>\n"
"      <constraints>\n"
"        <minimum>0</minimum>\n"
"        <maximum>0.0625</maximum>\n"
"        <step>0.005</step>\n"
"      </constraints>\n"
"    </float>\n"
"    <float>\n"
"      <name>conductanceVal</name>\n"
"      <description>\n"
"      The value of the conductance term in anisotropic diffusion filtering (Ex: 1.0)\n"
"      Note: Large Conductance will oversmooth the image. It is important to tune the conductance to obtain best results.\n"
"      </description>\n"
"      <label>Conductance</label> \n"
"      <index>3</index>\n"
"      <default>1.0</default>\n"
"    </float>\n"
"  </parameters>\n"
"\n"
"  <parameters>\n"
"    <label>IO</label>\n"
"    <description>Input/output parameters</description>   \n"
"    <image type =\"tensor\">\n"
"      <name>inputtensor</name>\n"
"      <description>File containing the dwi</description>\n"
"      <label>Input tensor file</label>\n"
"      <channel>input</channel>\n"
"      <index>4</index>\n"
"    </image>    \n"
"    <image type =\"tensor\">\n"
"      <name>outputtensor</name>\n"
"      <label>Output tensor file name</label>\n"
"      <channel>output</channel>\n"
"      <index>5</index>\n"
"      <description>Output tensor filtered</description>\n"
"    </image>\n"
"  </parameters>\n"
"\n"
"</executable>\n"
"\n"
;

#define static Module_EXPORT
#define const
#define image_ITKLogo_width ModuleLogoWidth
#define image_ITKLogo_height ModuleLogoHeight
#define image_ITKLogo_pixel_size ModuleLogoPixelSize
#define image_ITKLogo_length ModuleLogoLength
#define image_ITKLogo ModuleLogoImage
#include "/scratch/gouttard/software/Slicer3/Resources/ITKLogo.h"
#undef static
#undef const
#undef image_ITKLogo_width
#undef image_ITKLogo_height
#undef image_ITKLogo_pixel_size
#undef image_ITKLogo_length
#undef image_ITKLogo
}

void
splitString (const std::string &text,
             const std::string &separators,
             std::vector<std::string> &words)
{
  int n = text.length();
  int start, stop;
  start = text.find_first_not_of(separators);
  while ((start >= 0) && (start < n))
    {
    stop = text.find_first_of(separators, start);
    if ((stop < 0) || (stop > n)) stop = n;
    words.push_back(text.substr(start, stop - start));
    start = text.find_first_not_of(separators, stop+1);
    }
}

void
splitFilenames (const std::string &text,
                std::vector<std::string> &words)
{
  int n = text.length();
  int start, stop, startq, stopq;
  bool quoted;
  std::string comma(",");
  std::string quote("\"");
  start = text.find_first_not_of(comma);
  while ((start >= 0) && (start < n))
    {
    quoted = false;
    startq = text.find_first_of(quote, start);
    stopq = text.find_first_of(quote, startq+1);
    stop = text.find_first_of(comma, start);
    if ((stop < 0) || (stop > n)) stop = n;
    if (startq != std::string::npos && stopq != std::string::npos)
      {
      while (startq < stop && stop < stopq && stop != n)
         {
         quoted = true;
         stop = text.find_first_of(comma, stop+1);
         if ((stop < 0) || (stop > n)) stop = n;
         }
      }
    if (!quoted)
      {
      words.push_back(text.substr(start, stop - start));
      }
    else
      {
      words.push_back(text.substr(start+1, stop - start-2));
      }
    start = text.find_first_not_of(comma, stop+1);
    }
}

unsigned char *GetModuleLogo(int *width,
                             int *height,
                             int *pixel_size,
                             unsigned long *length)
{
  *width = ModuleLogoWidth;
  *height = ModuleLogoHeight;
  *pixel_size = ModuleLogoPixelSize;
  *length = ModuleLogoLength;
  return const_cast<unsigned char *>(ModuleLogoImage);
}

char *GetXMLModuleDescription()
{
   return XMLModuleDescription;
}

#define GENERATE_LOGO \
  if (argc >= 2 && (strcmp(argv[1],"--logo") == 0)) \
    { \
    int width, height, pixel_size;     \
    unsigned long length;  \
    unsigned char *logo = GetModuleLogo(&width, &height, &pixel_size, &length);  \
    std::cout << "LOGO" << std::endl;  \
    std::cout << width << std::endl;  \
    std::cout << height << std::endl;  \
    std::cout << pixel_size << std::endl;  \
    std::cout << length << std::endl;  \
    std::cout << logo << std::endl;  \
    return EXIT_SUCCESS;  \
    }
#define GENERATE_XML \
  if (argc >= 2 && (strcmp(argv[1],"--xml") == 0)) \
    { \
    std::cout << GetXMLModuleDescription(); \
    return EXIT_SUCCESS; \
    }
#define GENERATE_TCLAP \
    int filterTypeId = 2; \
    std::vector<int> filterTypeIdAllowed; \
    filterTypeIdAllowed.push_back(0);  \
    filterTypeIdAllowed.push_back(1);  \
    filterTypeIdAllowed.push_back(2);  \
    TCLAP::ValuesConstraint<int> filterTypeIdAllowedVals (filterTypeIdAllowed);  \
    int numIterationsVal = 30; \
    float timeStepVal = 0.01; \
    float conductanceVal = 1.0; \
    std::string inputtensor; \
    std::string outputtensor; \
    bool echoSwitch = false; \
    bool xmlSwitch = false; \
    std::string processInformationAddressString = "0"; \
try \
  { \
    std::string fullDescription("Description: "); \
    fullDescription += "Runs a filter that removes the rician noise from tensor images"; \
    if ("Saurav Basu, Tom Fletcher, Ross Whitaker" != "") \
      { \
      fullDescription += "\nAuthor(s): Saurav Basu, Tom Fletcher, Ross Whitaker"; \
      } \
    if ("" != "") \
      { \
      fullDescription += "\nAcknowledgements: "; \
      } \
    TCLAP::CmdLine commandLine (fullDescription, \
       ' ', \
      "1.0" ); \
 \
      itksys_ios::ostringstream msg; \
    msg.str("");msg << "0: Euclidean Space filtering (tensors are treated as 6-d vectors)       1: Log Space filtering (Fast and Simple Calculus on Tensors in the Log-Euclidean Framework)       2: Riemannian Space Filtering(A Riemannian Framework for the Processing of Tensor-Valued Images) (default: " << filterTypeId << ")"; \
    TCLAP::UnlabeledValueArg<int> filterTypeIdArg("filterTypeId", msg.str(), 1, filterTypeId, "int", commandLine); \
 \
    msg.str("");msg << "Number of iterations you want to run the filter for. (default: " << numIterationsVal << ")"; \
    TCLAP::UnlabeledValueArg<int> numIterationsValArg("numIterationsVal", msg.str(), 1, numIterationsVal, "int", commandLine); \
 \
    msg.str("");msg << "This determines the step size in the gradient descent. It can be atmost 0.0625. (default: " << timeStepVal << ")"; \
    TCLAP::UnlabeledValueArg<float> timeStepValArg("timeStepVal", msg.str(), 1, timeStepVal, "float", commandLine); \
 \
    msg.str("");msg << "The value of the conductance term in anisotropic diffusion filtering (Ex: 1.0)       Note: Large Conductance will oversmooth the image. It is important to tune the conductance to obtain best results. (default: " << conductanceVal << ")"; \
    TCLAP::UnlabeledValueArg<float> conductanceValArg("conductanceVal", msg.str(), 1, conductanceVal, "float", commandLine); \
 \
    msg.str("");msg << "File containing the dwi";    TCLAP::UnlabeledValueArg<std::string> inputtensorArg("inputtensor", msg.str(), 1, inputtensor, "std::string", commandLine); \
 \
    msg.str("");msg << "Output tensor filtered";    TCLAP::UnlabeledValueArg<std::string> outputtensorArg("outputtensor", msg.str(), 1, outputtensor, "std::string", commandLine); \
 \
    msg.str("");msg << "Echo the command line arguments (default: " << echoSwitch << ")"; \
    TCLAP::SwitchArg echoSwitchArg("", "echo", msg.str(), commandLine, echoSwitch); \
 \
    msg.str("");msg << "Produce xml description of command line arguments (default: " << xmlSwitch << ")"; \
    TCLAP::SwitchArg xmlSwitchArg("", "xml", msg.str(), commandLine, xmlSwitch); \
 \
    msg.str("");msg << "Address of a structure to store process information (progress, abort, etc.). (default: " << processInformationAddressString << ")"; \
    TCLAP::ValueArg<std::string > processInformationAddressStringArg("", "processinformationaddress", msg.str(), 0, processInformationAddressString, "std::string", commandLine); \
 \
    commandLine.parse ( argc, (char**) argv ); \
    filterTypeId = filterTypeIdArg.getValue(); \
    numIterationsVal = numIterationsValArg.getValue(); \
    timeStepVal = timeStepValArg.getValue(); \
    conductanceVal = conductanceValArg.getValue(); \
    inputtensor = inputtensorArg.getValue(); \
    outputtensor = outputtensorArg.getValue(); \
    echoSwitch = echoSwitchArg.getValue(); \
    xmlSwitch = xmlSwitchArg.getValue(); \
    processInformationAddressString = processInformationAddressStringArg.getValue(); \
      } \
catch ( TCLAP::ArgException e ) \
  { \
  std::cerr << "error: " << e.error() << " for arg " << e.argId() << std::endl; \
  return ( EXIT_FAILURE ); \
    }
#define GENERATE_ECHOARGS \
if (echoSwitch) \
{ \
std::cout << "Command Line Arguments" << std::endl; \
std::cout << "    filterTypeId: " << filterTypeId << std::endl; \
std::cout << "    numIterationsVal: " << numIterationsVal << std::endl; \
std::cout << "    timeStepVal: " << timeStepVal << std::endl; \
std::cout << "    conductanceVal: " << conductanceVal << std::endl; \
std::cout << "    inputtensor: " << inputtensor << std::endl; \
std::cout << "    outputtensor: " << outputtensor << std::endl; \
std::cout << "    echoSwitch: " << echoSwitch << std::endl; \
std::cout << "    xmlSwitch: " << xmlSwitch << std::endl; \
std::cout << "    processInformationAddressString: " << processInformationAddressString << std::endl; \
}
#define GENERATE_ProcessInformationAddressDecoding \
ModuleProcessInformation *CLPProcessInformation = 0; \
if (processInformationAddressString != "") \
{ \
sscanf(processInformationAddressString.c_str(), "%p", &CLPProcessInformation); \
}
#define PARSE_ARGS GENERATE_LOGO;GENERATE_XML;GENERATE_TCLAP;GENERATE_ECHOARGS;GENERATE_ProcessInformationAddressDecoding;
