#ifndef __GAUSSIANATTACHMENT_TERM_H
#define __GAUSSIANATTACHMENT_TERM_H

#include "AttachmentTerm.h"

class GaussianAttachmentTerm : public AttachmentTerm
{ 
public:	
   GaussianAttachmentTerm(float sigma,float lamda):AttachmentTerm(sigma),_lamda(lamda){};
   float GetAttachmentTerm(float u0,float u)
   {
        float bias=0;
       float sigmaSquared=(_sigma*_sigma);	   
       bias= 1/sigmaSquared*(u0-u);	       	
       //std::cout<<"Bias="<<bias<<std::endl;
       //std::cout<<"u="<<u<<",u0="<<u0<<"sigma="<<_sigma<<std::endl;       
       //std::cout<<"(u,u0)=("<<u<<","<<u0<<")"<<std::endl;
       //std::cout<<"lamda="<<_lamda<<std::endl; 
       //std::cout<<"bias="<<bias<<std::endl;
       return ((bias)*_lamda);
   }
private:
   float _lamda;
};

#endif
