// This file was automatically generated by:
//  ../../bin/GenerateCLP --logoFiles /scratch/gouttard/software/Slicer3/Resources/ITKLogo.h /scratch/gouttard/software/Slicer3/Applications/CLI/DWIRicianNoiseRemovalFilter.xml /scratch/gouttard/software/Slicer3-bin/Applications/CLI/DWIRicianNoiseRemovalFilterCLP.h
//
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string.h>

#include <itksys/ios/sstream>

#include "tclap/CmdLine.h"
#include "ModuleProcessInformation.h"

#ifdef WIN32
#define Module_EXPORT __declspec(dllexport)
#else
#define Module_EXPORT 
#endif

#ifdef main
// If main defined as a preprocessor symbol, redefine it to the expected entry point.
#undef main
#define main ModuleEntryPoint

extern "C" {
  Module_EXPORT char *GetXMLModuleDescription();
  Module_EXPORT int ModuleEntryPoint(int, char*[]);
  Module_EXPORT unsigned char *GetModuleLogo(int *width, int *height, int *pixel_size, unsigned long *bufferLength);
}
#endif

extern "C" {
Module_EXPORT char XMLModuleDescription[] = 
"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<executable>\n"
"  <category>Filtering.DWI</category>\n"
"  <title>Rician noise removal in DWI</title>\n"
"  <description>\n"
"Runs a filter that removes the rician noise - ASK TOM !!\n"
"  </description>\n"
"\n"
"  <version>1.0</version>\n"
"  <documentation-url>http://www.na-mic.org/Wiki/index.php/Slicer3:Module:Rician_Noise_Removal</documentation-url>\n"
"  <license></license>\n"
"  <contributor>Saurav Basu, Tom Fletcher, Ross Whitaker</contributor>\n"
"\n"
"  <parameters>\n"
"    <label>IO</label>\n"
"    <description>Input/output parameters</description>   \n"
"    <image type =\"diffusion-weighted\">\n"
"      <name>inputdwi</name>\n"
"      <description>Nrrd file containing the dwi</description>\n"
"      <label>Input DWI file</label>\n"
"      <channel>input</channel>\n"
"      <index>0</index>\n"
"    </image>    \n"
"    <image type =\"diffusion-weighted\">\n"
"      <name>outputdwi</name>\n"
"      <label>Output DWI file name</label>\n"
"      <channel>output</channel>\n"
"      <index>1</index>\n"
"      <description>Output filtered</description>\n"
"    </image>\n"
"  </parameters>\n"
"\n"
"  <parameters>\n"
"    <label>DWI Rician noise removal filter parameters</label>\n"
"    <description>\n"
"parameters for the filter\n"
"    </description>\n"
"    <integer>\n"
"      <name>numIterations</name>\n"
"      <description>\n"
"      Number of iterations you want to run the filter for.\n"
"      </description>\n"
"      <label>NumIterations</label> \n"
"      <index>2</index>\n"
"      <default>1</default>\n"
"    </integer>  \n"
"    <float>\n"
"      <name>conductanceVal</name>\n"
"      <description>\n"
"      The value of the conductance term in anisotropic diffusion filtering (Ex: 1.0)\n"
"      Note: Large Conductance will oversmooth the image. It is\n"
"important to tune the conductance to obtain best results.\n"
"      </description>\n"
"      <label>Conductance</label> \n"
"      <index>3</index>\n"
"      <default>1.0</default>\n"
"    </float>\n"
"    <float>\n"
"      <name>timeStepVal</name>\n"
"      <description>\n"
"      This determines the step size in the gradient descent. It can be atmost 0.0625.\n"
"      </description>\n"
"      <label>Time step</label> \n"
"      <index>4</index>\n"
"      <default>0.0625</default>\n"
"      <constraints>\n"
"        <minimum>0</minimum>\n"
"        <maximum>0.0625</maximum>\n"
"        <step>0.05</step>\n"
"      </constraints>\n"
"    </float>\n"
"    <integer-enumeration>\n"
"      <name>filterTypeId</name>\n"
"      <description>\n"
"      0 - Perform simple anisotropic diffusion\n"
"      1 - Perform Chi-Squared smoothing \n"
"      2 - Perform Rician bias correction filtering\n"
"      3 - Same as 2 except use a Gaussian Attachment Term\n"
"      </description>\n"
"      <label>Filter type</label> \n"
"      <index>5</index>\n"
"      <default>2</default>\n"
"      <element>0</element>\n"
"      <element>1</element>\n"
"      <element>2</element>\n"
"      <element>3</element>\n"
"    </integer-enumeration>\n"
"    <float>\n"
"      <name>sigmaVal</name>\n"
"      <description>\n"
"      Estimate of noise in the data.This can be done by squaring the\n"
"airvoxels in the real data. The sum of square of all the intensities\n"
"in the air region should equal 2*variance of the noise in the data.\n"
"      </description>\n"
"      <label>Sigma for bias correction</label> \n"
"      <index>6</index>\n"
"      <default>10</default>\n"
"    </float>\n"
"    <float>\n"
"      <name>lamda1Val</name>\n"
"      <description>\n"
"      The weights for the Rician attachment terms. \n"
"      </description>\n"
"      <label>Weight for the Rician attachment term</label> \n"
"      <index>7</index>\n"
"      <default>100</default>\n"
"    </float> \n"
"    <float>\n"
"      <name>lamda2Val</name>\n"
"      <description>\n"
"      The weights for the Gaussian attachment terms. \n"
"      </description>\n"
"      <label>Weight for the Gaussian attachment term</label> \n"
"      <index>8</index>\n"
"      <default>100</default>\n"
"    </float>\n"
"  </parameters>\n"
"\n"
"</executable>\n"
"\n"
;

#define static Module_EXPORT
#define const
#define image_ITKLogo_width ModuleLogoWidth
#define image_ITKLogo_height ModuleLogoHeight
#define image_ITKLogo_pixel_size ModuleLogoPixelSize
#define image_ITKLogo_length ModuleLogoLength
#define image_ITKLogo ModuleLogoImage
#include "/scratch/gouttard/software/Slicer3/Resources/ITKLogo.h"
#undef static
#undef const
#undef image_ITKLogo_width
#undef image_ITKLogo_height
#undef image_ITKLogo_pixel_size
#undef image_ITKLogo_length
#undef image_ITKLogo
}

void
splitString (const std::string &text,
             const std::string &separators,
             std::vector<std::string> &words)
{
  int n = text.length();
  int start, stop;
  start = text.find_first_not_of(separators);
  while ((start >= 0) && (start < n))
    {
    stop = text.find_first_of(separators, start);
    if ((stop < 0) || (stop > n)) stop = n;
    words.push_back(text.substr(start, stop - start));
    start = text.find_first_not_of(separators, stop+1);
    }
}

void
splitFilenames (const std::string &text,
                std::vector<std::string> &words)
{
  int n = text.length();
  int start, stop, startq, stopq;
  bool quoted;
  std::string comma(",");
  std::string quote("\"");
  start = text.find_first_not_of(comma);
  while ((start >= 0) && (start < n))
    {
    quoted = false;
    startq = text.find_first_of(quote, start);
    stopq = text.find_first_of(quote, startq+1);
    stop = text.find_first_of(comma, start);
    if ((stop < 0) || (stop > n)) stop = n;
    if (startq != std::string::npos && stopq != std::string::npos)
      {
      while (startq < stop && stop < stopq && stop != n)
         {
         quoted = true;
         stop = text.find_first_of(comma, stop+1);
         if ((stop < 0) || (stop > n)) stop = n;
         }
      }
    if (!quoted)
      {
      words.push_back(text.substr(start, stop - start));
      }
    else
      {
      words.push_back(text.substr(start+1, stop - start-2));
      }
    start = text.find_first_not_of(comma, stop+1);
    }
}

unsigned char *GetModuleLogo(int *width,
                             int *height,
                             int *pixel_size,
                             unsigned long *length)
{
  *width = ModuleLogoWidth;
  *height = ModuleLogoHeight;
  *pixel_size = ModuleLogoPixelSize;
  *length = ModuleLogoLength;
  return const_cast<unsigned char *>(ModuleLogoImage);
}

char *GetXMLModuleDescription()
{
   return XMLModuleDescription;
}

#define GENERATE_LOGO \
  if (argc >= 2 && (strcmp(argv[1],"--logo") == 0)) \
    { \
    int width, height, pixel_size;     \
    unsigned long length;  \
    unsigned char *logo = GetModuleLogo(&width, &height, &pixel_size, &length);  \
    std::cout << "LOGO" << std::endl;  \
    std::cout << width << std::endl;  \
    std::cout << height << std::endl;  \
    std::cout << pixel_size << std::endl;  \
    std::cout << length << std::endl;  \
    std::cout << logo << std::endl;  \
    return EXIT_SUCCESS;  \
    }
#define GENERATE_XML \
  if (argc >= 2 && (strcmp(argv[1],"--xml") == 0)) \
    { \
    std::cout << GetXMLModuleDescription(); \
    return EXIT_SUCCESS; \
    }
#define GENERATE_TCLAP \
    std::string inputdwi; \
    std::string outputdwi; \
    int numIterations = 1; \
    float conductanceVal = 1.0; \
    float timeStepVal = 0.0625; \
    int filterTypeId = 2; \
    std::vector<int> filterTypeIdAllowed; \
    filterTypeIdAllowed.push_back(0);  \
    filterTypeIdAllowed.push_back(1);  \
    filterTypeIdAllowed.push_back(2);  \
    filterTypeIdAllowed.push_back(3);  \
    TCLAP::ValuesConstraint<int> filterTypeIdAllowedVals (filterTypeIdAllowed);  \
    float sigmaVal = 10; \
    float lamda1Val = 100; \
    float lamda2Val = 100; \
    bool echoSwitch = false; \
    bool xmlSwitch = false; \
    std::string processInformationAddressString = "0"; \
try \
  { \
    std::string fullDescription("Description: "); \
    fullDescription += "Runs a filter that removes the rician noise"; \
    if ("Saurav Basu, Tom Fletcher, Ross Whitaker" != "") \
      { \
      fullDescription += "\nAuthor(s): Saurav Basu, Tom Fletcher, Ross Whitaker"; \
      } \
    if ("" != "") \
      { \
      fullDescription += "\nAcknowledgements: "; \
      } \
    TCLAP::CmdLine commandLine (fullDescription, \
       ' ', \
      "1.0" ); \
 \
      itksys_ios::ostringstream msg; \
    msg.str("");msg << "Nrrd file containing the dwi";    TCLAP::UnlabeledValueArg<std::string> inputdwiArg("inputdwi", msg.str(), 1, inputdwi, "std::string", commandLine); \
 \
    msg.str("");msg << "Output filtered";    TCLAP::UnlabeledValueArg<std::string> outputdwiArg("outputdwi", msg.str(), 1, outputdwi, "std::string", commandLine); \
 \
    msg.str("");msg << "Number of iterations you want to run the filter for. (default: " << numIterations << ")"; \
    TCLAP::UnlabeledValueArg<int> numIterationsArg("numIterations", msg.str(), 1, numIterations, "int", commandLine); \
 \
    msg.str("");msg << "The value of the conductance term in anisotropic diffusion filtering (Ex: 1.0)       Note: Large Conductance will oversmooth the image. It is important to tune the conductance to obtain best results. (default: " << conductanceVal << ")"; \
    TCLAP::UnlabeledValueArg<float> conductanceValArg("conductanceVal", msg.str(), 1, conductanceVal, "float", commandLine); \
 \
    msg.str("");msg << "This determines the step size in the gradient descent. It can be atmost 0.0625. (default: " << timeStepVal << ")"; \
    TCLAP::UnlabeledValueArg<float> timeStepValArg("timeStepVal", msg.str(), 1, timeStepVal, "float", commandLine); \
 \
    msg.str("");msg << "0 - Perform simple anisotropic diffusion       1 - Perform Chi-Squared smoothing        2 - Perform Rician bias correction filtering       3 - Same as 2 except use a Gaussian Attachment Term (default: " << filterTypeId << ")"; \
    TCLAP::UnlabeledValueArg<int> filterTypeIdArg("filterTypeId", msg.str(), 1, filterTypeId, "int", commandLine); \
 \
    msg.str("");msg << "Estimate of noise in the data.This can be done by squaring the airvoxels in the real data. The sum of square of all the intensities in the air region should equal 2*variance of the noise in the data. (default: " << sigmaVal << ")"; \
    TCLAP::UnlabeledValueArg<float> sigmaValArg("sigmaVal", msg.str(), 1, sigmaVal, "float", commandLine); \
 \
    msg.str("");msg << "The weights for the Rician attachment terms. (default: " << lamda1Val << ")"; \
    TCLAP::UnlabeledValueArg<float> lamda1ValArg("lamda1Val", msg.str(), 1, lamda1Val, "float", commandLine); \
 \
    msg.str("");msg << "The weights for the Gaussian attachment terms. (default: " << lamda2Val << ")"; \
    TCLAP::UnlabeledValueArg<float> lamda2ValArg("lamda2Val", msg.str(), 1, lamda2Val, "float", commandLine); \
 \
    msg.str("");msg << "Echo the command line arguments (default: " << echoSwitch << ")"; \
    TCLAP::SwitchArg echoSwitchArg("", "echo", msg.str(), commandLine, echoSwitch); \
 \
    msg.str("");msg << "Produce xml description of command line arguments (default: " << xmlSwitch << ")"; \
    TCLAP::SwitchArg xmlSwitchArg("", "xml", msg.str(), commandLine, xmlSwitch); \
 \
    msg.str("");msg << "Address of a structure to store process information (progress, abort, etc.). (default: " << processInformationAddressString << ")"; \
    TCLAP::ValueArg<std::string > processInformationAddressStringArg("", "processinformationaddress", msg.str(), 0, processInformationAddressString, "std::string", commandLine); \
 \
    commandLine.parse ( argc, (char**) argv ); \
    inputdwi = inputdwiArg.getValue(); \
    outputdwi = outputdwiArg.getValue(); \
    numIterations = numIterationsArg.getValue(); \
    conductanceVal = conductanceValArg.getValue(); \
    timeStepVal = timeStepValArg.getValue(); \
    filterTypeId = filterTypeIdArg.getValue(); \
    sigmaVal = sigmaValArg.getValue(); \
    lamda1Val = lamda1ValArg.getValue(); \
    lamda2Val = lamda2ValArg.getValue(); \
    echoSwitch = echoSwitchArg.getValue(); \
    xmlSwitch = xmlSwitchArg.getValue(); \
    processInformationAddressString = processInformationAddressStringArg.getValue(); \
      } \
catch ( TCLAP::ArgException e ) \
  { \
  std::cerr << "error: " << e.error() << " for arg " << e.argId() << std::endl; \
  return ( EXIT_FAILURE ); \
    }
#define GENERATE_ECHOARGS \
if (echoSwitch) \
{ \
std::cout << "Command Line Arguments" << std::endl; \
std::cout << "    inputdwi: " << inputdwi << std::endl; \
std::cout << "    outputdwi: " << outputdwi << std::endl; \
std::cout << "    numIterations: " << numIterations << std::endl; \
std::cout << "    conductanceVal: " << conductanceVal << std::endl; \
std::cout << "    timeStepVal: " << timeStepVal << std::endl; \
std::cout << "    filterTypeId: " << filterTypeId << std::endl; \
std::cout << "    sigmaVal: " << sigmaVal << std::endl; \
std::cout << "    lamda1Val: " << lamda1Val << std::endl; \
std::cout << "    lamda2Val: " << lamda2Val << std::endl; \
std::cout << "    echoSwitch: " << echoSwitch << std::endl; \
std::cout << "    xmlSwitch: " << xmlSwitch << std::endl; \
std::cout << "    processInformationAddressString: " << processInformationAddressString << std::endl; \
}
#define GENERATE_ProcessInformationAddressDecoding \
ModuleProcessInformation *CLPProcessInformation = 0; \
if (processInformationAddressString != "") \
{ \
sscanf(processInformationAddressString.c_str(), "%p", &CLPProcessInformation); \
}
#define PARSE_ARGS GENERATE_LOGO;GENERATE_XML;GENERATE_TCLAP;GENERATE_ECHOARGS;GENERATE_ProcessInformationAddressDecoding;
