#ifndef __RICIANATTACHMENT_TERM_H
#define __RICIANATTACHMENT_TERM_H
#include "AttachmentTerm.h"
#include "../besselFunction.h"

class RicianAttachmentTerm : public AttachmentTerm
{ 
public:	
   RicianAttachmentTerm(float sigma,float lamda):AttachmentTerm(sigma),_lamda(lamda){};
   float GetAttachmentTerm(float u0,float u)
   {
	   float bias=0;
	   float sigmaSquared=(_sigma*_sigma);	   
	   float term=u0/(sigmaSquared);
           float besselCutoff=700;
	   
       if(( term*u) < besselCutoff )
       {
          bias= (term*bessi1(term*u)/bessi0(term*u))- u/sigmaSquared;	       	
       //std::cout<<"Bias="<<bias<<std::endl;
       //std::cout<<"term="<<term<<",u="<<u<<",u0="<<u0<<"sigma="<<_sigma<<std::endl;       
       }
       else
       {
	       bias= term-u/sigmaSquared;
       }
	return (bias)*_lamda;
   }
private:
   float _lamda;
};

#endif
