/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public class BERConstructedOctetString
extends DEROctetString {
    private Vector octs;

    private static byte[] toBytes(Vector vector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n != vector.size()) {
            try {
                DEROctetString dEROctetString = (DEROctetString)vector.elementAt(n);
                byteArrayOutputStream.write(dEROctetString.getOctets());
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(vector.elementAt(n).getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("exception converting octets " + iOException.toString());
            }
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BERConstructedOctetString(byte[] byArray) {
        super(byArray);
    }

    public BERConstructedOctetString(Vector vector) {
        super(BERConstructedOctetString.toBytes(vector));
        this.octs = vector;
    }

    public BERConstructedOctetString(DERObject dERObject) {
        super(dERObject);
    }

    public BERConstructedOctetString(DEREncodable dEREncodable) {
        super(dEREncodable.getDERObject());
    }

    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        byte[] byArray;
        int n = 0;
        int n2 = 0;
        Vector<DEROctetString> vector = new Vector<DEROctetString>();
        while (n2 + 1 < this.string.length) {
            if (this.string[n2] == 0 && this.string[n2 + 1] == 0) {
                byArray = new byte[n2 - n + 1];
                System.arraycopy(this.string, n, byArray, 0, byArray.length);
                vector.addElement(new DEROctetString(byArray));
                n = n2 + 1;
            }
            ++n2;
        }
        byArray = new byte[this.string.length - n];
        System.arraycopy(this.string, n, byArray, 0, byArray.length);
        vector.addElement(new DEROctetString(byArray));
        return vector;
    }

    public void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(36);
            dEROutputStream.write(128);
            if (this.octs != null) {
                int n = 0;
                while (n != this.octs.size()) {
                    dEROutputStream.writeObject(this.octs.elementAt(n));
                    ++n;
                }
            } else {
                byte[] byArray;
                int n = 0;
                int n2 = 0;
                while (n2 + 1 < this.string.length) {
                    if (this.string[n2] == 0 && this.string[n2 + 1] == 0) {
                        byArray = new byte[n2 - n + 1];
                        System.arraycopy(this.string, n, byArray, 0, byArray.length);
                        dEROutputStream.writeObject(new DEROctetString(byArray));
                        n = n2 + 1;
                    }
                    ++n2;
                }
                byArray = new byte[this.string.length - n];
                System.arraycopy(this.string, n, byArray, 0, byArray.length);
                dEROutputStream.writeObject(new DEROctetString(byArray));
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
        } else {
            super.encode(dEROutputStream);
        }
    }
}

