/*
 * Decompiled with CFR 0.152.
 */
package net.nbirn.mediator.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import net.nbirn.mediator.client.Connection;
import net.nbirn.mediator.client.Definition;
import net.nbirn.mediator.client.Mediator;
import net.nbirn.mediator.client.Query;
import net.nbirn.mediator.client.Relation;
import net.nbirn.mediator.client.Source;
import net.nbirn.mediator.client.View;
import net.nbirn.mediator.exception.MediatorException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;

public class ConnectionHandler {
    private static QName qnSource = new QName("urn:MediatorService", "Source");
    private static QName qnView = new QName("urn:MediatorService", "View");
    private static QName qnRelation = new QName("urn:MediatorService", "Relation");
    private static QName qnKin = new QName("urn:MediatorService", "Kin");
    private static QName qnMediator = new QName("urn:MediatorService", "Mediator");
    private static QName qnConnection = new QName("urn:MediatorService", "Connection");
    private static QName qnDefinition = new QName("urn:MediatorService", "Definition");
    private static QName qnString = new QName("String");
    private static QName qnTuple = new QName("urn:MediatorService", "Tuple");
    private static QName qnTestObject = new QName("urn:MediatorService", "TestObject");
    static /* synthetic */ Class class$net$nbirn$mediator$client$Tuple;
    static /* synthetic */ Class class$net$nbirn$mediator$client$Source;
    static /* synthetic */ Class class$net$nbirn$mediator$client$View;
    static /* synthetic */ Class class$net$nbirn$mediator$client$Relation;
    static /* synthetic */ Class class$net$nbirn$mediator$client$Kin;
    static /* synthetic */ Class class$net$nbirn$mediator$client$Mediator;
    static /* synthetic */ Class class$net$nbirn$mediator$client$Connection;
    static /* synthetic */ Class class$net$nbirn$mediator$client$Definition;

    protected static boolean registerSource(Source s) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(s.getMediator(), "registerSource");
            call.addParameter("Source", qnSource, ParameterMode.IN);
            call.setReturnType(XMLType.SOAP_BOOLEAN);
            if (null == call) {
                return false;
            }
            Boolean b = (Boolean)call.invoke(new Object[]{s});
            Relation r = new Relation();
            if (!b.booleanValue()) {
                throw new MediatorException(5001, "Failed to register a source");
            }
            return b;
        }
        catch (RemoteException e) {
            throw new MediatorException(5111, e.toString());
        }
    }

    protected static Source retrieveSource(String s, Mediator m) throws MediatorException {
        Source src = null;
        try {
            Call call = ConnectionHandler.getSimpleCall(m, "retrieveSource");
            call.addParameter("arg1", qnString, ParameterMode.IN);
            call.setReturnType(qnSource);
            if (null == call) {
                return null;
            }
            src = (Source)call.invoke(new Object[]{s});
        }
        catch (RemoteException e) {
            throw new MediatorException(5101, e.toString());
        }
        return src;
    }

    protected static View retrieveView(String name, Mediator m) throws MediatorException {
        View view = null;
        try {
            Call call = ConnectionHandler.getSimpleCall(m, "retrieveView");
            call.addParameter("arg1", qnString, ParameterMode.IN);
            call.setReturnType(qnView);
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            view = (View)call.invoke(new Object[]{name});
        }
        catch (RemoteException e) {
            throw new MediatorException(5102, e.toString());
        }
        return view;
    }

    protected static boolean registerView(View v) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(v.getMediator(), "registerView");
            call.addParameter("arg1", qnView, ParameterMode.IN);
            call.setReturnType(XMLType.SOAP_BOOLEAN);
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            Boolean b = (Boolean)call.invoke(new Object[]{v});
            return b;
        }
        catch (RemoteException e) {
            throw new MediatorException(5112, e.toString());
        }
    }

    protected static boolean removeSource(Source s) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(s.getMediator(), "removeSource");
            call.addParameter("arg1", qnSource, ParameterMode.IN);
            call.setReturnType(XMLType.SOAP_BOOLEAN);
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            Boolean b = (Boolean)call.invoke(new Object[]{s});
            return b;
        }
        catch (RemoteException e) {
            throw new MediatorException(5103, e.toString());
        }
    }

    protected static boolean removeView(View v) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(v.getMediator(), "removeView");
            call.addParameter("arg1", qnView, ParameterMode.IN);
            call.setReturnType(XMLType.XSD_BOOLEAN);
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            Boolean b = (Boolean)call.invoke(new Object[]{v});
            return b;
        }
        catch (RemoteException e) {
            throw new MediatorException(5104, e.toString());
        }
    }

    protected static boolean changeRelation(Source s, Relation r) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(s.getMediator(), "changeRelation");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.addParameter("arg1", qnSource, ParameterMode.IN);
            call.addParameter("arg2", qnRelation, ParameterMode.IN);
            call.setReturnType(XMLType.XSD_BOOLEAN);
            Boolean b = (Boolean)call.invoke(new Object[]{s, r});
            return b;
        }
        catch (RemoteException e) {
            throw new MediatorException(5105, e.toString());
        }
    }

    protected static boolean changeRelation(View v, Relation r) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(v.getMediator(), "changeRelation");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.addParameter("arg1", qnView, ParameterMode.IN);
            call.addParameter("arg2", qnRelation, ParameterMode.IN);
            call.setReturnType(XMLType.XSD_BOOLEAN);
            Boolean b = (Boolean)call.invoke(new Object[]{v, r});
            return b;
        }
        catch (RemoteException e) {
            throw new MediatorException(5106, e.toString());
        }
    }

    protected static boolean changeDefinition(View v, Definition d) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(v.getMediator(), "changeDefinition");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.addParameter("arg1", qnView, ParameterMode.IN);
            call.addParameter("arg2", qnDefinition, ParameterMode.IN);
            call.setReturnType(XMLType.XSD_BOOLEAN);
            Boolean b = (Boolean)call.invoke(new Object[]{v.getName(), d});
            return b;
        }
        catch (RemoteException e) {
            throw new MediatorException(5106, e.toString());
        }
    }

    protected static List retrieveViewNames(Mediator m) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(m, "retrieveViewNames");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.setReturnType(XMLType.SOAP_VECTOR);
            Vector l = (Vector)call.invoke(new Object[0]);
            return l;
        }
        catch (RemoteException e) {
            throw new MediatorException(5108, e.toString());
        }
    }

    protected static List retrieveSimpleViews(Mediator m) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(m, "retrieveSimpleViews");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.setReturnType(XMLType.SOAP_VECTOR);
            Vector l = (Vector)call.invoke(new Object[0]);
            return l;
        }
        catch (RemoteException e) {
            System.out.println("RemoteException" + e);
            return Collections.EMPTY_LIST;
        }
    }

    protected static List retrieveSourceNames(Mediator m) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(m, "retrieveSourceNames");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.setReturnType(XMLType.SOAP_VECTOR);
            Vector l = (Vector)call.invoke(new Object[0]);
            return l;
        }
        catch (RemoteException e) {
            throw new MediatorException(5107, e.toString());
        }
    }

    protected static List searchSource(Mediator m, String[] keyword, boolean searchType) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(m, "searchSource");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.addParameter("arg1", XMLType.SOAP_ARRAY, ParameterMode.IN);
            call.addParameter("arg2", XMLType.SOAP_BOOLEAN, ParameterMode.IN);
            call.setReturnType(XMLType.SOAP_VECTOR);
            List l = (List)call.invoke(new Object[]{keyword, new Boolean(searchType)});
            return l;
        }
        catch (RemoteException e) {
            throw new MediatorException(5109, e.toString());
        }
    }

    protected static List searchView(Mediator m, String[] keyword, boolean searchType) throws MediatorException {
        try {
            Call call = ConnectionHandler.getSimpleCall(m, "searchView");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.addParameter("arg1", XMLType.SOAP_ARRAY, ParameterMode.IN);
            call.addParameter("arg2", XMLType.SOAP_BOOLEAN, ParameterMode.IN);
            call.setReturnType(XMLType.SOAP_VECTOR);
            List l = (List)call.invoke(new Object[]{keyword, new Boolean(searchType)});
            return l;
        }
        catch (RemoteException e) {
            throw new MediatorException(5110, e.toString());
        }
    }

    protected static String executeQuery(Query q) throws MediatorException {
        try {
            Call call = ConnectionHandler.getQueryCall(q.getMediator(), "executeQuery");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.addParameter("arg1", qnString, ParameterMode.IN);
            call.setReturnType(XMLType.SOAP_STRING);
            call.setTimeout(new Integer(6000000));
            return (String)call.invoke(new Object[]{q.getQuery()});
        }
        catch (RemoteException e) {
            throw new MediatorException(5113, e.toString());
        }
    }

    public static List nextBatch(Query q, String rid, int batchId) throws MediatorException {
        try {
            Call call = ConnectionHandler.getQueryCall(q.getMediator(), "nextBatch");
            if (null == call) {
                throw new MediatorException(5202, "");
            }
            call.addParameter("arg1", qnString, ParameterMode.IN);
            call.addParameter("arg2", XMLType.SOAP_INTEGER, ParameterMode.IN);
            call.setReturnType(XMLType.SOAP_VECTOR);
            call.setTimeout(new Integer(6000000));
            return (List)call.invoke(new Object[]{rid, new Integer(batchId)});
        }
        catch (RemoteException e) {
            throw new MediatorException(5113, e.toString());
        }
    }

    public static void runTest() throws MediatorException {
    }

    private static Call getProxyCall(Mediator m) {
        Connection c = m.getConnection();
        Object proxy = null;
        Object call = null;
        return null;
    }

    private static Call getQueryCall(Mediator m, String methodName) {
        Connection c = m.getConnection();
        Service service = null;
        Call call = null;
        try {
            service = new Service();
            call = (Call)service.createCall();
            call.registerTypeMapping(class$net$nbirn$mediator$client$Tuple == null ? (class$net$nbirn$mediator$client$Tuple = ConnectionHandler.class$("net.nbirn.mediator.client.Tuple")) : class$net$nbirn$mediator$client$Tuple, qnTuple, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$Tuple == null ? (class$net$nbirn$mediator$client$Tuple = ConnectionHandler.class$("net.nbirn.mediator.client.Tuple")) : class$net$nbirn$mediator$client$Tuple, qnTuple), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$Tuple == null ? (class$net$nbirn$mediator$client$Tuple = ConnectionHandler.class$("net.nbirn.mediator.client.Tuple")) : class$net$nbirn$mediator$client$Tuple, qnTuple));
            call.setTargetEndpointAddress(new URL(c.getUrl()));
            call.setOperationName(new QName(c.getServiceName(), methodName));
        }
        catch (ServiceException e) {
            System.out.println("ServiceException : " + (Object)((Object)e));
        }
        catch (MalformedURLException e) {
            System.out.println("malformed ex" + e);
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
        return call;
    }

    private static Call getSimpleCall(Mediator m, String methodName) {
        Connection c = m.getConnection();
        Service service = null;
        Call call = null;
        try {
            service = new Service();
            call = (Call)service.createCall();
            call.registerTypeMapping(class$net$nbirn$mediator$client$Source == null ? (class$net$nbirn$mediator$client$Source = ConnectionHandler.class$("net.nbirn.mediator.client.Source")) : class$net$nbirn$mediator$client$Source, qnSource, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$Source == null ? (class$net$nbirn$mediator$client$Source = ConnectionHandler.class$("net.nbirn.mediator.client.Source")) : class$net$nbirn$mediator$client$Source, qnSource), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$Source == null ? (class$net$nbirn$mediator$client$Source = ConnectionHandler.class$("net.nbirn.mediator.client.Source")) : class$net$nbirn$mediator$client$Source, qnSource));
            call.registerTypeMapping(class$net$nbirn$mediator$client$View == null ? (class$net$nbirn$mediator$client$View = ConnectionHandler.class$("net.nbirn.mediator.client.View")) : class$net$nbirn$mediator$client$View, qnView, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$View == null ? (class$net$nbirn$mediator$client$View = ConnectionHandler.class$("net.nbirn.mediator.client.View")) : class$net$nbirn$mediator$client$View, qnView), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$View == null ? (class$net$nbirn$mediator$client$View = ConnectionHandler.class$("net.nbirn.mediator.client.View")) : class$net$nbirn$mediator$client$View, qnView));
            call.registerTypeMapping(class$net$nbirn$mediator$client$Relation == null ? (class$net$nbirn$mediator$client$Relation = ConnectionHandler.class$("net.nbirn.mediator.client.Relation")) : class$net$nbirn$mediator$client$Relation, qnRelation, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$Relation == null ? (class$net$nbirn$mediator$client$Relation = ConnectionHandler.class$("net.nbirn.mediator.client.Relation")) : class$net$nbirn$mediator$client$Relation, qnRelation), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$Relation == null ? (class$net$nbirn$mediator$client$Relation = ConnectionHandler.class$("net.nbirn.mediator.client.Relation")) : class$net$nbirn$mediator$client$Relation, qnRelation));
            call.registerTypeMapping(class$net$nbirn$mediator$client$Kin == null ? (class$net$nbirn$mediator$client$Kin = ConnectionHandler.class$("net.nbirn.mediator.client.Kin")) : class$net$nbirn$mediator$client$Kin, qnKin, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$Kin == null ? (class$net$nbirn$mediator$client$Kin = ConnectionHandler.class$("net.nbirn.mediator.client.Kin")) : class$net$nbirn$mediator$client$Kin, qnKin), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$Kin == null ? (class$net$nbirn$mediator$client$Kin = ConnectionHandler.class$("net.nbirn.mediator.client.Kin")) : class$net$nbirn$mediator$client$Kin, qnKin));
            call.registerTypeMapping(class$net$nbirn$mediator$client$Mediator == null ? (class$net$nbirn$mediator$client$Mediator = ConnectionHandler.class$("net.nbirn.mediator.client.Mediator")) : class$net$nbirn$mediator$client$Mediator, qnMediator, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$Mediator == null ? (class$net$nbirn$mediator$client$Mediator = ConnectionHandler.class$("net.nbirn.mediator.client.Mediator")) : class$net$nbirn$mediator$client$Mediator, qnMediator), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$Mediator == null ? (class$net$nbirn$mediator$client$Mediator = ConnectionHandler.class$("net.nbirn.mediator.client.Mediator")) : class$net$nbirn$mediator$client$Mediator, qnMediator));
            call.registerTypeMapping(class$net$nbirn$mediator$client$Connection == null ? (class$net$nbirn$mediator$client$Connection = ConnectionHandler.class$("net.nbirn.mediator.client.Connection")) : class$net$nbirn$mediator$client$Connection, qnConnection, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$Connection == null ? (class$net$nbirn$mediator$client$Connection = ConnectionHandler.class$("net.nbirn.mediator.client.Connection")) : class$net$nbirn$mediator$client$Connection, qnConnection), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$Connection == null ? (class$net$nbirn$mediator$client$Connection = ConnectionHandler.class$("net.nbirn.mediator.client.Connection")) : class$net$nbirn$mediator$client$Connection, qnConnection));
            call.registerTypeMapping(class$net$nbirn$mediator$client$Definition == null ? (class$net$nbirn$mediator$client$Definition = ConnectionHandler.class$("net.nbirn.mediator.client.Definition")) : class$net$nbirn$mediator$client$Definition, qnDefinition, (SerializerFactory)new BeanSerializerFactory(class$net$nbirn$mediator$client$Definition == null ? (class$net$nbirn$mediator$client$Definition = ConnectionHandler.class$("net.nbirn.mediator.client.Definition")) : class$net$nbirn$mediator$client$Definition, qnDefinition), (DeserializerFactory)new BeanDeserializerFactory(class$net$nbirn$mediator$client$Definition == null ? (class$net$nbirn$mediator$client$Definition = ConnectionHandler.class$("net.nbirn.mediator.client.Definition")) : class$net$nbirn$mediator$client$Definition, qnDefinition));
            call.setTargetEndpointAddress(new URL(c.getUrl()));
            call.setOperationName(new QName(c.getServiceName(), methodName));
        }
        catch (ServiceException e) {
            System.out.println("ServiceException : " + (Object)((Object)e));
        }
        catch (MalformedURLException e) {
            System.out.println("malformed ex" + e);
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
        return call;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

