/*
 * Decompiled with CFR 0.152.
 */
package net.nbirn.mediator.client;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import net.nbirn.mediator.client.Connection;
import net.nbirn.mediator.client.ConnectionHandler;
import net.nbirn.mediator.client.Mediator;
import net.nbirn.mediator.client.Query;
import net.nbirn.mediator.client.Relation;
import net.nbirn.mediator.exception.MediatorException;

public class Source {
    private String name;
    private Hashtable relations = new Hashtable();
    private Connection c;
    private Mediator m = null;
    private Collection relation;
    private Query query;
    private Connection connection;
    private ConnectionHandler connectionHandler;
    private String description = "";

    public Source() {
    }

    public Source(String name, Mediator m) throws MediatorException {
        this.name = name;
        this.m = m;
        Source s = ConnectionHandler.retrieveSource(name, m);
        if (null == s) {
            throw new MediatorException(5101, "No source does exist.");
        }
        this.description = s.getDescription();
        this.connection = s.getConnection();
        this.relations = s.getRelations();
    }

    public Source(String name, Mediator m, Connection c) {
        this.name = name;
        this.m = m;
        this.c = c;
    }

    public boolean add(Relation relation) {
        this.relations.put(relation.getName(), relation);
        return true;
    }

    public void setRelations(Hashtable relations) {
        this.relations = relations;
    }

    public Hashtable getRelations() {
        return this.relations;
    }

    public Relation getRelation(String relationName) {
        return (Relation)this.relations.get(relationName);
    }

    public boolean change(Relation r) throws MediatorException {
        return ConnectionHandler.changeRelation(this, r);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean deleteRelation(String name) {
        return true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean register(boolean validate) throws MediatorException {
        return ConnectionHandler.registerSource(this);
    }

    public boolean remove() throws MediatorException {
        return ConnectionHandler.removeSource(this);
    }

    public boolean validate() {
        return true;
    }

    public String lastError() {
        return "";
    }

    public Vector getRelationNames() {
        return new Vector(this.relations.keySet());
    }

    public void setRelation(Collection relation) {
        this.relation = relation;
    }

    public Collection getRelation() {
        return this.relation;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public Mediator getMediator() {
        return this.m;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

