/*
 * Decompiled with CFR 0.152.
 */
package net.nbirn.mediator.client;

import net.nbirn.mediator.client.Connection;
import net.nbirn.mediator.client.ConnectionHandler;
import net.nbirn.mediator.client.Definition;
import net.nbirn.mediator.client.Mediator;
import net.nbirn.mediator.client.Relation;
import net.nbirn.mediator.exception.MediatorException;
import net.nbirn.mediator.server.messenger.MediatorService;

public class View {
    private String name;
    private Connection c;
    private Mediator m;
    private Relation r;
    private Definition definition;
    private MediatorService mediatorService;
    private String description;

    public View() {
    }

    public View(String name, Mediator m, Definition definition) {
        this.name = name;
        this.m = m;
        this.definition = definition;
    }

    public View(String name, Mediator m) throws MediatorException {
        this.name = name;
        this.m = m;
        View v = ConnectionHandler.retrieveView(name, m);
        this.r = v.getRelation();
        this.definition = v.getDefinition();
        this.description = v.getDescription();
    }

    public boolean register(boolean validate) throws MediatorException {
        return ConnectionHandler.registerView(this);
    }

    public boolean remove() throws MediatorException {
        return ConnectionHandler.removeView(this);
    }

    public boolean change(Relation r) throws MediatorException {
        return ConnectionHandler.changeRelation(this, r);
    }

    public boolean change(Definition d) throws MediatorException {
        return ConnectionHandler.changeDefinition(this, d);
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void defineAs(Definition d) {
    }

    public boolean isSafe() {
        return true;
    }

    public void makeSafe() {
    }

    public void makeUnsafe() {
    }

    public boolean validate() {
        return true;
    }

    public Relation getRelation() {
        return this.r;
    }

    public void setRelation(Relation r) {
        this.r = r;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Mediator getMediator() {
        return this.m;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

