/*
 * Decompiled with CFR 0.152.
 */
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;

public class CopyTest {
    static final String checksum = "md5sum";
    GeneralFile source;
    GeneralFile remoteDestination;
    GeneralFile returnDestination;

    public CopyTest(GeneralFile generalFile, GeneralFile generalFile2) throws IOException {
        if (generalFile.mkdir()) {
            int n;
            GeneralRandomAccessFile generalRandomAccessFile = null;
            for (double d = 0.0; d < 5015.0; d += 1.0) {
                generalRandomAccessFile = FileFactory.newRandomAccessFile(FileFactory.newFile(generalFile, "f" + d), "rw");
                generalRandomAccessFile.write(d + "\n");
                generalRandomAccessFile.write(new byte[(int)d]);
                generalRandomAccessFile.write(d + "\n");
                generalRandomAccessFile.write(new byte[(int)d]);
                generalRandomAccessFile.write(d + "\n");
                generalRandomAccessFile.close();
            }
            generalRandomAccessFile = FileFactory.newRandomAccessFile(FileFactory.newFile(generalFile, "fbig1"), "rw");
            for (n = 0; n < 10; ++n) {
                generalRandomAccessFile.write(n + " ");
                generalRandomAccessFile.write(new byte[1000000]);
            }
            generalRandomAccessFile.close();
            generalRandomAccessFile = FileFactory.newRandomAccessFile(FileFactory.newFile(generalFile, "fbig2"), "rw");
            for (n = 0; n < 65; ++n) {
                generalRandomAccessFile.write(n + " ");
                generalRandomAccessFile.write(new byte[1000000]);
            }
            generalRandomAccessFile.close();
        }
        this.source = generalFile;
        this.remoteDestination = generalFile2;
    }

    public void copy() throws IOException {
        double d = new Date().getTime();
        System.out.println("srb: " + this.remoteDestination + " time: " + d);
        ((SRBFile)this.remoteDestination).copyFrom(this.source, true);
        System.out.println("upload time: " + ((double)new Date().getTime() - d));
        this.returnDestination = FileFactory.newFile(this.source, "download");
        ((SRBFile)this.remoteDestination).copyTo(this.returnDestination, true, false);
        System.out.println("localFile: " + this.returnDestination);
        System.out.println("total copy time: " + ((double)new Date().getTime() - d));
    }

    public boolean compare() throws IOException {
        return this.compare(false);
    }

    public boolean compare(boolean bl) throws IOException {
        String string = null;
        String string2 = null;
        Process process = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        byte[] byArray = new byte[33];
        boolean bl2 = false;
        GeneralFile generalFile = null;
        if (bl) {
            if (!this.remoteDestination.exists()) {
                return false;
            }
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.remoteDestination.getAbsolutePath())};
            String[] stringArray = new String[]{"file name", "PATH_NAME", "file size"};
            MetaDataSelect[] metaDataSelectArray = MetaDataSet.newSelection(stringArray);
            MetaDataRecordList[] metaDataRecordListArray = ((SRBFileSystem)this.remoteDestination.getFileSystem()).query(metaDataConditionArray, metaDataSelectArray);
            metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                if (metaDataRecordListArray[i].getIntValue(2) > 0) {
                    inputStream2 = ((SRBFileSystem)this.remoteDestination.getFileSystem()).executeProxyCommand(checksum, metaDataRecordListArray[i].getValue("PATH_NAME").toString());
                    int n = inputStream2.read();
                    while (n != -1) {
                        string = string + "" + (char)n;
                        n = inputStream2.read();
                    }
                    string = string + "" + (char)n;
                    inputStream2.close();
                    generalFile = FileFactory.newFile(this.source, metaDataRecordListArray[i].getValue("file name").toString());
                    process = Runtime.getRuntime().exec("md5sum " + generalFile.getAbsolutePath());
                    inputStream = process.getInputStream();
                    inputStream.read(byArray);
                    string2 = new String(byArray);
                    inputStream.close();
                    if (string.indexOf(string2) < 0) {
                        System.out.println("error " + generalFile);
                        bl2 = true;
                    }
                    string = "";
                }
                System.out.print(i + " ");
            }
        } else {
            if (!this.returnDestination.exists()) {
                return false;
            }
            String[] stringArray = this.source.list();
            for (int i = 0; i < stringArray.length; ++i) {
                generalFile = FileFactory.newFile(this.source, stringArray[i]);
                if (!generalFile.isFile()) continue;
                process = Runtime.getRuntime().exec("md5sum " + generalFile.getAbsolutePath());
                inputStream = process.getInputStream();
                inputStream.read(byArray);
                string2 = new String(byArray);
                generalFile = FileFactory.newFile(this.returnDestination, generalFile.getName());
                process = Runtime.getRuntime().exec("md5sum " + generalFile.getAbsolutePath());
                inputStream = process.getInputStream();
                inputStream.read(byArray);
                string = new String(byArray);
                inputStream.close();
                if (string.equals(string2)) continue;
                System.out.println("error " + generalFile);
                bl2 = true;
            }
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            String string = "file:/scratch/slocal/iktome/sourcedata";
            String string2 = "mySRBCopyTest";
            LocalFile localFile = null;
            SRBFile sRBFile = null;
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            try {
                localFile = new LocalFile(new URI(string));
                if (localFile.createNewFile()) {
                    localFile.delete();
                }
            }
            catch (Throwable throwable) {
                localFile = new LocalFile(string2);
            }
            if (stringArray.length > 1) {
                sRBFile = new SRBFile(new URI(stringArray[1]));
            } else {
                object = new SRBFileSystem();
                int n = 0;
                do {
                    sRBFile = new SRBFile((SRBFileSystem)object, "copyTest" + n);
                    ++n;
                } while (sRBFile.exists());
            }
            object = new CopyTest(localFile, sRBFile);
            ((CopyTest)object).copy();
            ((CopyTest)object).compare();
        }
        catch (Throwable throwable) {
            System.out.println("\nJava Error Message: " + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

